/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.mixin;

import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import com.wenxin2.warp_pipes.init.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends Entity {
    private static final int MAX_PARTICLE_AMOUNT = 40;
    private int warpCooldown;

    @Shadow
    protected abstract float m_6041_();

    @Shadow
    public abstract void m_5661_(Component var1, boolean var2);

    public PlayerMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    public void m_6075_() {
        Level world = this.m_9236_();
        BlockPos pos = this.m_20183_();
        BlockState state = world.m_8055_(pos);
        BlockState stateAboveEntity = world.m_8055_(pos.m_6630_(Math.round(this.m_20206_())));
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos = pos.m_121945_(facing);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (offsetState.m_60734_() instanceof WarpPipeBlock) {
                this.enterPipe(offsetPos);
            }
            if (!(state.m_60734_() instanceof WarpPipeBlock)) continue;
            this.enterPipe(pos);
        }
        if (stateAboveEntity.m_60734_() instanceof WarpPipeBlock) {
            this.enterPipeBelow(pos);
        }
        if (this.warpCooldown > 0) {
            --this.warpCooldown;
        }
        super.m_6075_();
    }

    public void spawnParticles(Entity entity, Level world) {
        RandomSource random = world.m_213780_();
        for (int i = 0; i < 40; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), (random.m_188500_() - 0.5) * 2.0, -random.m_188500_(), (random.m_188500_() - 0.5) * 2.0);
        }
    }

    public int getWarpCooldown() {
        return this.warpCooldown;
    }

    public void setWarpCooldown(int cooldown) {
        this.warpCooldown = cooldown;
    }

    public void enterPipeBelow(BlockPos pos) {
        WarpPipeBlockEntity warpPipeBE;
        Level world = this.m_9236_();
        BlockState stateAboveEntity = world.m_8055_(pos.m_6630_(Math.round(this.m_20206_())));
        BlockEntity blockEntity = world.m_7702_(pos.m_6630_(Math.round(this.m_20206_())));
        double entityX = this.m_20185_();
        double entityZ = this.m_20189_();
        int blockX = pos.m_123341_();
        int blockZ = pos.m_123343_();
        if (!((Boolean)stateAboveEntity.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity && (warpPipeBE = (WarpPipeBlockEntity)blockEntity).m_58904_() != null && !warpPipeBE.preventWarp && ((Boolean)Config.TELEPORT_PLAYERS.get()).booleanValue() && !this.m_6095_().m_204039_(ModTags.WARP_BlACKLIST) && !this.getPersistentData().m_128471_("warp_pipes:prevent_warp")) {
            BlockPos warpPos = warpPipeBE.destinationPos;
            int entityId = this.m_19879_();
            if (world.m_5776_() && WarpPipeBlock.teleportedEntities.getOrDefault(entityId, false).booleanValue()) {
                this.spawnParticles(this, world);
                WarpPipeBlock.teleportedEntities.put(entityId, false);
            }
            if (warpPipeBE.hasDestinationPos() && stateAboveEntity.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN && this.m_20184_().f_82480_ > 0.0 && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                System.out.println("Below Pipe ");
                if (this.getWarpCooldown() == 0) {
                    if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                        WarpPipeBlock.warp(this, warpPos, world, stateAboveEntity);
                    } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                        WarpPipeBlock.warp(this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, stateAboveEntity);
                    }
                    this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                } else {
                    this.displayCooldownMessage();
                }
            }
        }
    }

    public void enterPipe(BlockPos pos) {
        WarpPipeBlockEntity warpPipeBE;
        Level world = this.m_9236_();
        BlockState state = world.m_8055_(pos);
        BlockEntity blockEntity = world.m_7702_(pos);
        double entityX = this.m_20185_();
        double entityY = this.m_20186_();
        double entityZ = this.m_20189_();
        int blockX = pos.m_123341_();
        int blockY = pos.m_123342_();
        int blockZ = pos.m_123343_();
        if (!((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity && (warpPipeBE = (WarpPipeBlockEntity)blockEntity).m_58904_() != null && !warpPipeBE.preventWarp && ((Boolean)Config.TELEPORT_PLAYERS.get()).booleanValue() && !this.m_6095_().m_204039_(ModTags.WARP_BlACKLIST) && !this.getPersistentData().m_128471_("warp_pipes:prevent_warp")) {
            BlockPos warpPos = warpPipeBE.destinationPos;
            int entityId = this.m_19879_();
            if (world.m_5776_() && WarpPipeBlock.teleportedEntities.getOrDefault(entityId, false).booleanValue()) {
                this.spawnParticles(this, world);
                WarpPipeBlock.teleportedEntities.put(entityId, false);
            }
            if (warpPipeBE.hasDestinationPos()) {
                if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP && this.m_6144_() && entityY + (double)this.m_20206_() >= (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    if (this.getWarpCooldown() == 0) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp(this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp(this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    } else {
                        this.displayCooldownMessage();
                    }
                }
                if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH && !this.m_6144_() && this.m_6374_() == Direction.SOUTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                    if (this.getWarpCooldown() == 0) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp(this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp(this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    } else {
                        this.displayCooldownMessage();
                    }
                }
                if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH && !this.m_6144_() && this.m_6374_() == Direction.NORTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ + 0.25) {
                    if (this.getWarpCooldown() == 0) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp(this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp(this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    } else {
                        this.displayCooldownMessage();
                    }
                }
                if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST && !this.m_6144_() && this.m_6374_() == Direction.WEST && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    if (this.getWarpCooldown() == 0) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp(this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp(this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    } else {
                        this.displayCooldownMessage();
                    }
                }
                if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST && !this.m_6144_() && this.m_6374_() == Direction.EAST && entityX < (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    if (this.getWarpCooldown() == 0) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp(this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp(this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    } else {
                        this.displayCooldownMessage();
                    }
                }
            }
        } else if (!(((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || ((Boolean)Config.TELEPORT_PLAYERS.get()).booleanValue() && !this.m_6095_().m_204039_(ModTags.WARP_BlACKLIST))) {
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP && this.m_6144_() && entityY + (double)this.m_20206_() >= (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                this.displayNoTeleportMessage();
            }
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN && this.m_146904_() < blockY && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                this.displayNoTeleportMessage();
            }
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH && !this.m_6144_() && this.m_6374_() == Direction.SOUTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                this.displayNoTeleportMessage();
            }
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH && !this.m_6144_() && this.m_6374_() == Direction.NORTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ + 0.25) {
                this.displayNoTeleportMessage();
            }
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST && !this.m_6144_() && this.m_6374_() == Direction.WEST && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                this.displayNoTeleportMessage();
            }
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST && !this.m_6144_() && this.m_6374_() == Direction.EAST && entityX < (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                this.displayNoTeleportMessage();
            }
        }
    }

    public void displayCooldownMessage() {
        if (this.getWarpCooldown() >= 10 && ((Boolean)Config.WARP_COOLDOWN_MESSAGE.get()).booleanValue()) {
            if (((Boolean)Config.WARP_COOLDOWN_MESSAGE_TICKS.get()).booleanValue()) {
                this.m_5661_((Component)Component.m_237110_((String)"display.warp_pipes.warp_cooldown.ticks", (Object[])new Object[]{this.getWarpCooldown()}).m_130940_(ChatFormatting.RED), true);
            } else {
                this.m_5661_((Component)Component.m_237115_((String)"display.warp_pipes.warp_cooldown").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public void displayNoTeleportMessage() {
        if (!((Boolean)Config.TELEPORT_PLAYERS.get()).booleanValue() || this.m_6095_().m_204039_(ModTags.WARP_BlACKLIST)) {
            this.m_5661_((Component)Component.m_237115_((String)"display.warp_pipes.players_cannot_teleport").m_130940_(ChatFormatting.RED), true);
        }
    }

    public void displayDestinationMissingMessage() {
        this.m_5661_((Component)Component.m_237115_((String)"display.warp_pipes.warp_destination_missing").m_130940_(ChatFormatting.RED), true);
    }
}

