/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.mixin;

import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import com.wenxin2.warp_pipes.init.ModTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    @Final
    protected RandomSource f_19796_;
    private static final int MAX_PARTICLE_AMOUNT = 100;
    private int warpCooldown;

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract float m_20206_();

    @Shadow
    public abstract float m_20205_();

    @Shadow
    public abstract int m_19879_();

    @Shadow
    public abstract BlockPos m_20183_();

    @Shadow
    public abstract int m_146904_();

    @Shadow
    public abstract double m_20208_(double var1);

    @Shadow
    public abstract double m_20187_();

    @Shadow
    public abstract double m_20262_(double var1);

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract void m_20256_(Vec3 var1);

    @Shadow
    public abstract void m_183634_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    @Nullable
    public abstract Entity m_146895_();

    @Shadow
    public abstract void m_146884_(Vec3 var1);

    @Shadow
    public abstract boolean m_20160_();

    @Shadow
    public abstract void m_6478_(MoverType var1, Vec3 var2);

    @Shadow
    public abstract boolean m_20069_();

    @Inject(at={@At(value="TAIL")}, method={"baseTick"})
    public void baseTick(CallbackInfo ci) {
        Level world = this.m_9236_();
        BlockPos pos = this.m_20183_();
        BlockState state = world.m_8055_(pos);
        BlockState stateAboveEntity = world.m_8055_(pos.m_6630_(Math.round(this.m_20206_())));
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos = pos.m_121945_(facing);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (offsetState.m_60734_() instanceof WarpPipeBlock) {
                this.enterPipe(offsetPos);
            }
            if (!(state.m_60734_() instanceof WarpPipeBlock)) continue;
            this.enterPipe(pos);
        }
        if (stateAboveEntity.m_60734_() instanceof WarpPipeBlock) {
            this.enterPipeBelow(pos);
        }
        if (this.warpCooldown > 0) {
            --this.warpCooldown;
        }
    }

    public void spawnParticles(Level world) {
        RandomSource random = world.m_213780_();
        float scaleFactor = this.m_20206_() * this.m_20205_();
        int particleCount = (int)(scaleFactor * 40.0f);
        particleCount = Math.min(particleCount, 100);
        List players = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            for (int i = 0; i < particleCount; ++i) {
                player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123809_, false, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (random.m_188501_() - 0.5f) * 2.0f, -random.m_188501_(), (random.m_188501_() - 0.5f) * 2.0f, 0.0f, 2));
            }
        }
    }

    public int getWarpCooldown() {
        return this.warpCooldown;
    }

    public void setWarpCooldown(int cooldown) {
        this.warpCooldown = cooldown;
    }

    public void enterPipeBelow(BlockPos pos) {
        WarpPipeBlockEntity warpPipeBE;
        Level world = this.m_9236_();
        BlockState stateAboveEntity = world.m_8055_(pos.m_6630_(Math.round(this.m_20206_())));
        BlockEntity blockEntity = world.m_7702_(pos.m_6630_(Math.round(this.m_20206_())));
        double entityX = this.m_20185_();
        double entityZ = this.m_20189_();
        int blockX = pos.m_123341_();
        int blockZ = pos.m_123343_();
        if (!((Boolean)stateAboveEntity.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity && (warpPipeBE = (WarpPipeBlockEntity)blockEntity).m_58904_() != null && !warpPipeBE.preventWarp && ((Boolean)Config.TELEPORT_PLAYERS.get()).booleanValue() && !this.m_6095_().m_204039_(ModTags.WARP_BlACKLIST)) {
            BlockPos warpPos = warpPipeBE.destinationPos;
            int entityId = this.m_19879_();
            if (!world.m_5776_() && WarpPipeBlock.teleportedEntities.getOrDefault(entityId, false).booleanValue()) {
                this.spawnParticles(world);
                WarpPipeBlock.teleportedEntities.put(entityId, false);
            }
            if (this.getWarpCooldown() == 0 && warpPipeBE.hasDestinationPos() && stateAboveEntity.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                    WarpPipeBlock.warp((Entity)this, warpPos, world, stateAboveEntity);
                } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                    WarpPipeBlock.warp((Entity)this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, stateAboveEntity);
                }
                this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
            }
        }
    }

    public void enterPipe(BlockPos pos) {
        Level world = this.m_9236_();
        BlockState state = world.m_8055_(pos);
        BlockEntity blockEntity = world.m_7702_(pos);
        double entityX = this.m_20185_();
        double entityY = this.m_20186_();
        double entityZ = this.m_20189_();
        int blockX = pos.m_123341_();
        int blockY = pos.m_123342_();
        int blockZ = pos.m_123343_();
        if (!((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity warpPipeBE = (WarpPipeBlockEntity)blockEntity;
            if (!warpPipeBE.preventWarp && ((Boolean)Config.TELEPORT_NON_MOBS.get()).booleanValue() && !this.m_6095_().m_204039_(ModTags.WARP_BlACKLIST)) {
                BlockPos warpPos = warpPipeBE.destinationPos;
                int entityId = this.m_19879_();
                if (!world.m_5776_() && WarpPipeBlock.teleportedEntities.getOrDefault(entityId, false).booleanValue()) {
                    this.spawnParticles(world);
                    WarpPipeBlock.teleportedEntities.put(entityId, false);
                }
                if (this.getWarpCooldown() == 0 && warpPipeBE.hasDestinationPos()) {
                    if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP && entityY > (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp((Entity)this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp((Entity)this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    }
                    if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp((Entity)this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp((Entity)this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    }
                    if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp((Entity)this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp((Entity)this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    }
                    if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp((Entity)this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp((Entity)this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    }
                    if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST && entityX < (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                        if (warpPos != null && world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock) {
                            WarpPipeBlock.warp((Entity)this, warpPos, world, state);
                        } else if (warpPipeBE.getUuid() != null && WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos) != null) {
                            WarpPipeBlock.warp((Entity)this, WarpPipeBlock.findMatchingUUID(warpPipeBE.getUuid(), world, pos), world, state);
                        }
                        this.setWarpCooldown((Integer)Config.WARP_COOLDOWN.get());
                    }
                }
            }
        }
    }
}

