/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.items;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import com.wenxin2.warp_pipes.init.SoundRegistry;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public class LinkerItem
extends TieredItem {
    public static final String WARP_POS = "WarpPos";
    public static final String WARP_DIMENSION = "Dimension";
    public static final String WARP_UUID = "WarpUUID";
    public static final String POS_X = "X";
    public static final String POS_Y = "Y";
    public static final String POS_Z = "Z";
    private static final Logger LOGGER = LogUtils.getLogger();
    public boolean isBound;

    public LinkerItem(Item.Properties properties, Tier tier) {
        super(tier, properties);
    }

    public boolean setBound(boolean isBound) {
        this.isBound = isBound;
        return this.isBound;
    }

    public boolean getBound() {
        return this.isBound;
    }

    /*
     * Unable to fully structure code
     */
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        block11: {
            block13: {
                block12: {
                    player = useOnContext.m_43723_();
                    world = useOnContext.m_43725_();
                    pos = useOnContext.m_8083_();
                    state = world.m_8055_(pos);
                    blockEntity = world.m_7702_(pos);
                    stack = useOnContext.m_43722_();
                    wrenchTag = stack.m_41783_();
                    dimension = world.m_46472_().m_135782_().toString();
                    if (wrenchTag != null && wrenchTag.m_128441_("Bound")) {
                        this.isBound = wrenchTag.m_128471_("Bound");
                    }
                    if (player != null && !player.m_7500_() && ((Boolean)Config.CREATIVE_WRENCH_PIPE_LINKING.get()).booleanValue()) {
                        player.m_5661_((Component)Component.m_237115_((String)"display.warp_pipes.linker.requires_creative").m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.m_19078_((boolean)world.f_46443_);
                    }
                    if (player == null || !(state.m_60734_() instanceof ClearWarpPipeBlock) && (!(state.m_60734_() instanceof WarpPipeBlock) || !((Boolean)state.m_61143_((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) || !player.m_6144_() || !(blockEntity instanceof WarpPipeBlockEntity)) break block11;
                    pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
                    uuid = pipeBlockEntity.getUuid();
                    if (this.getBound() != Boolean.FALSE.booleanValue()) break block12;
                    if (wrenchTag == null) {
                        wrenchTag = new CompoundTag();
                    }
                    warpPos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    wrenchTag.m_128379_("Bound", Boolean.TRUE.booleanValue());
                    wrenchTag.m_128405_("X", pos.m_123341_());
                    wrenchTag.m_128405_("Y", pos.m_123342_());
                    wrenchTag.m_128405_("Z", pos.m_123343_());
                    wrenchTag.m_128365_("WarpPos", (Tag)NbtUtils.m_129224_((BlockPos)warpPos));
                    wrenchTag.m_128359_("Dimension", dimension);
                    if (uuid != null) {
                        wrenchTag.m_128362_("WarpUUID", uuid);
                    }
                    this.setBound(Boolean.TRUE);
                    player.m_5661_((Component)Component.m_237110_((String)"display.warp_pipes.linker.bound", (Object[])new Object[]{wrenchTag.m_128451_("X"), wrenchTag.m_128451_("Y"), wrenchTag.m_128451_("Z"), wrenchTag.m_128461_("Dimension")}).m_130940_(ChatFormatting.DARK_GREEN), true);
                    this.spawnParticles(world, pos, (ParticleOptions)ParticleTypes.f_123809_);
                    this.playSound(world, pos, (SoundEvent)SoundRegistry.WRENCH_BOUND.get(), SoundSource.PLAYERS, 1.0f, 0.1f);
                    break block13;
                }
                if (!this.getBound()) break block13;
                player1 = useOnContext.m_43723_();
                if (wrenchTag == null) {
                    wrenchTag = new CompoundTag();
                }
                wrenchTag.m_128379_("Bound", Boolean.FALSE.booleanValue());
                this.setBound(Boolean.FALSE);
                this.writeTag((ResourceKey<Level>)world.m_46472_(), pos, stack.m_41784_());
                warpPos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (player1 != null) {
                    stack.m_41622_(1, (LivingEntity)player1, (Consumer<Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$useOn$0(net.minecraft.world.item.context.UseOnContext net.minecraft.world.entity.player.Player ), (Lnet/minecraft/world/entity/player/Player;)V)((UseOnContext)useOnContext));
                    player1.m_5661_((Component)Component.m_237110_((String)"display.warp_pipes.linker.linked", (Object[])new Object[]{wrenchTag.m_128451_("X"), wrenchTag.m_128451_("Y"), wrenchTag.m_128451_("Z"), wrenchTag.m_128461_("Dimension")}).m_130940_(ChatFormatting.GOLD), true);
                }
                if ((globalPos = LinkerItem.createWarpPos(wrenchTag)) == null) {
                    return super.m_6225_(useOnContext);
                }
                blockEntity1 = world.m_7702_(globalPos.m_122646_());
                warpPipeBE = (WarpPipeBlockEntity)blockEntity;
                if (!(blockEntity1 instanceof WarpPipeBlockEntity)) ** GOTO lbl-1000
                warpPipeBEGlobal = (WarpPipeBlockEntity)blockEntity1;
                if (LinkerItem.isLinked(stack)) {
                    wrenchTag.m_128365_("WarpPos", (Tag)NbtUtils.m_129224_((BlockPos)warpPos));
                    if (uuid != null) {
                        wrenchTag.m_128362_("WarpUUID", wrenchTag.m_128342_("WarpUUID"));
                    }
                    this.link(pos, world, wrenchTag, warpPipeBE, warpPipeBEGlobal);
                } else if (player1 != null) {
                    player1.m_5661_((Component)Component.m_237110_((String)"display.warp_pipes.linker.dimension_fail", (Object[])new Object[]{wrenchTag.m_128451_("X"), wrenchTag.m_128451_("Y"), wrenchTag.m_128451_("Z"), wrenchTag.m_128461_("Dimension")}).m_130940_(ChatFormatting.RED), true);
                }
                this.spawnParticles(world, pos, (ParticleOptions)ParticleTypes.f_123809_);
                this.playSound(world, pos, (SoundEvent)SoundRegistry.PIPES_LINKED.get(), SoundSource.BLOCKS, 1.0f, 0.1f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6225_(useOnContext);
    }

    public void clearTags(CompoundTag wrenchTag) {
        wrenchTag.m_128473_(POS_X);
        wrenchTag.m_128473_(POS_Y);
        wrenchTag.m_128473_(POS_Z);
        wrenchTag.m_128473_(WARP_DIMENSION);
        wrenchTag.m_128473_(WARP_UUID);
    }

    public static boolean isLinked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && (tag.m_128441_(POS_X) || tag.m_128441_(POS_Y) || tag.m_128441_(POS_Z) || tag.m_128441_(WARP_DIMENSION));
    }

    public void link(BlockPos pos, Level world, CompoundTag tag, WarpPipeBlockEntity warpPipeBE, WarpPipeBlockEntity warpPipeBEGlobal) {
        UUID uuid = warpPipeBE.getUuid();
        UUID uuidGlobal = warpPipeBEGlobal.getUuid();
        warpPipeBE.setDestinationPos(warpPipeBEGlobal.m_58899_());
        if (uuid != null) {
            warpPipeBE.setWarpUuid(tag.m_128342_(WARP_UUID));
        }
        warpPipeBE.m_6596_();
        if (warpPipeBEGlobal.m_58904_() != null) {
            warpPipeBE.setDestinationDim((ResourceKey<Level>)warpPipeBEGlobal.m_58904_().m_46472_());
        }
        warpPipeBEGlobal.setDestinationPos(pos);
        warpPipeBEGlobal.setDestinationDim((ResourceKey<Level>)world.m_46472_());
        if (uuidGlobal != null) {
            warpPipeBEGlobal.setWarpUuid(warpPipeBE.getUuid());
        }
        warpPipeBEGlobal.m_6596_();
        this.clearTags(tag);
    }

    @Nullable
    public static GlobalPos createWarpPos(CompoundTag tag) {
        Optional<ResourceKey<Level>> optional;
        boolean containsPipePos = tag.m_128441_(WARP_POS);
        boolean containsPipeDim = tag.m_128441_(WARP_DIMENSION);
        if (containsPipePos && containsPipeDim && (optional = LinkerItem.getWarpDimension(tag)).isPresent()) {
            BlockPos pos = new BlockPos(tag.m_128451_(POS_X), tag.m_128451_(POS_Y), tag.m_128451_(POS_Z));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)pos);
        }
        return null;
    }

    public void playSound(Level world, BlockPos pos, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        world.m_5594_(null, pos, soundEvent, source, volume, pitch);
    }

    private void spawnParticles(Level world, BlockPos pos, ParticleOptions particleOptions) {
        if (world.m_5776_()) {
            RandomSource random = world.m_213780_();
            for (int i = 0; i < 40; ++i) {
                world.m_7106_(particleOptions, (double)pos.m_123341_() + 0.5 + 0.5 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5 + 0.5 * (double)(random.m_188499_() ? 1 : -1), (random.m_188500_() - 0.5) * 2.0, -random.m_188500_(), (random.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    private void writeTag(ResourceKey<Level> worldKey, BlockPos pos, CompoundTag tag) {
        tag.m_128365_(WARP_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, worldKey).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(nbtElement -> tag.m_128365_(WARP_DIMENSION, nbtElement));
    }

    public static Optional<ResourceKey<Level>> getWarpDimension(CompoundTag tag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(WARP_DIMENSION)).result();
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag tooltip) {
        CompoundTag tag = stack.m_41783_();
        if (this.getBound() && tag != null && tag.m_128441_(POS_X) && tag.m_128441_(POS_Y) && tag.m_128441_(POS_Z) && tag.m_128441_(WARP_DIMENSION)) {
            list.add((Component)Component.m_237110_((String)"", (Object[])new Object[]{true}));
            list.add((Component)Component.m_237110_((String)"display.warp_pipes.linker.bound_tooltip", (Object[])new Object[]{tag.m_128451_(POS_X), tag.m_128451_(POS_Y), tag.m_128451_(POS_Z), tag.m_128461_(WARP_DIMENSION), true}).m_130940_(ChatFormatting.GOLD));
        } else {
            list.add((Component)Component.m_237110_((String)"", (Object[])new Object[]{true}));
            list.add((Component)Component.m_237110_((String)"display.warp_pipes.linker.not_bound_tooltip", (Object[])new Object[]{true}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    private static /* synthetic */ void lambda$useOn$0(UseOnContext useOnContext, Player p) {
        p.m_21190_(useOnContext.m_43724_());
    }
}

