/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.init;

import com.wenxin2.warp_pipes.WarpPipes;
import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.PipeBubblesBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WaterSpoutBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.SoundRegistry;
import com.wenxin2.warp_pipes.inventory.WarpPipeMenu;
import com.wenxin2.warp_pipes.items.WrenchItem;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="warp_pipes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModRegistry {
    public static final EnumMap<DyeColor, RegistryObject<Block>> WARP_PIPES = new EnumMap(DyeColor.class);
    public static final RegistryObject<Item> PIPE_WRENCH = ModRegistry.registerItem("pipe_wrench", () -> new WrenchItem(new Item.Properties().m_41503_(128), (Tier)Tiers.IRON));
    public static final RegistryObject<Block> CLEAR_WARP_PIPE = ModRegistry.registerBlock("clear_warp_pipe", () -> new ClearWarpPipeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_56744_).m_60960_(ModRegistry::never).m_60971_(ModRegistry::never).m_60913_(3.0f, 500.0f).m_60999_().m_60955_()));
    public static final RegistryObject<Block> PIPE_BUBBLES;
    public static final RegistryObject<Block> WATER_SPOUT;
    public static final RegistryObject<BlockEntityType<WarpPipeBlockEntity>> WARP_PIPE_BLOCK_ENTITY;
    public static final RegistryObject<MenuType<WarpPipeMenu>> WARP_PIPE_MENU;

    public static RegistryObject<Block> registerBlock(String name, Supplier<? extends Block> block) {
        RegistryObject blocks = WarpPipes.BLOCKS.register(name, block);
        WarpPipes.ITEMS.register(name, () -> new BlockItem((Block)blocks.get(), new Item.Properties()));
        return blocks;
    }

    public static RegistryObject<Block> registerNoItemBlock(String name, Supplier<? extends Block> block) {
        RegistryObject blocks = WarpPipes.BLOCKS.register(name, block);
        return blocks;
    }

    public static RegistryObject<Item> registerItem(String name, Supplier<? extends Item> item) {
        return WarpPipes.ITEMS.register(name, item);
    }

    private static boolean always(BlockState state, BlockGetter block, BlockPos pos) {
        return true;
    }

    private static boolean never(BlockState state, BlockGetter block, BlockPos pos) {
        return false;
    }

    public static void init() {
    }

    static {
        Arrays.stream(DyeColor.values()).forEach(color -> WARP_PIPES.put((DyeColor)color, ModRegistry.registerBlock(color.m_41065_() + "_warp_pipe", () -> new WarpPipeBlock(BlockBehaviour.Properties.m_284310_().m_284268_(color).m_60918_(SoundType.f_56725_).m_60913_(3.5f, 1000.0f).m_60971_(ModRegistry::always).m_60999_()))));
        PIPE_BUBBLES = ModRegistry.registerNoItemBlock("pipe_bubbles", () -> new PipeBubblesBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_280170_().m_60910_().m_222994_().m_278788_()));
        WATER_SPOUT = ModRegistry.registerNoItemBlock("water_spout", () -> new WaterSpoutBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60918_(SoundRegistry.WATER_SPOUT).m_278166_(PushReaction.DESTROY).m_60924_(ModRegistry::never).m_60960_(ModRegistry::never).m_60971_(ModRegistry::never).m_280170_().m_60910_().m_222994_()));
        WARP_PIPE_BLOCK_ENTITY = WarpPipes.BLOCK_ENTITIES.register("warp_pipe", () -> BlockEntityType.Builder.m_155273_(WarpPipeBlockEntity::new, (Block[])((Block[])Stream.concat(WARP_PIPES.values().stream().map(RegistryObject::get), Stream.of((Block)CLEAR_WARP_PIPE.get())).toArray(Block[]::new))).m_58966_(null));
        WARP_PIPE_MENU = WarpPipes.MENUS.register("warp_pipe", () -> new MenuType(WarpPipeMenu::new, FeatureFlags.f_244280_.m_247355_()));
    }
}

