/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.init;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CONFIG;
    public static final String CATEGORY_DEBUG = "Debug";
    public static final String CATEGORY_CLIENT = "Client";
    public static final String CATEGORY_COMMON = "Common";
    public static ForgeConfigSpec.BooleanValue ALLOW_FAST_TRAVEL;
    public static ForgeConfigSpec.BooleanValue ALLOW_PIPE_UNWAXING;
    public static ForgeConfigSpec.BooleanValue CREATIVE_BUBBLES;
    public static ForgeConfigSpec.BooleanValue CREATIVE_CLOSE_PIPES;
    public static ForgeConfigSpec.BooleanValue CREATIVE_WATER_SPOUT;
    public static ForgeConfigSpec.BooleanValue CREATIVE_WRENCH_PIPE_LINKING;
    public static ForgeConfigSpec.BooleanValue DEBUG_PIPE_BUBBLES_SELECTION_BOX;
    public static ForgeConfigSpec.BooleanValue DEBUG_WATER_SPOUT_SELECTION_BOX;
    public static ForgeConfigSpec.BooleanValue DEBUG_SELECTION_BOX;
    public static ForgeConfigSpec.BooleanValue DEBUG_SELECTION_BOX_CREATIVE;
    public static ForgeConfigSpec.BooleanValue DISABLE_TEXT;
    public static ForgeConfigSpec.BooleanValue TELEPORT_MOBS;
    public static ForgeConfigSpec.BooleanValue TELEPORT_NON_MOBS;
    public static ForgeConfigSpec.BooleanValue TELEPORT_PLAYERS;
    public static ForgeConfigSpec.IntValue WARP_COOLDOWN;
    public static ForgeConfigSpec.BooleanValue WARP_COOLDOWN_MESSAGE;
    public static ForgeConfigSpec.BooleanValue WARP_COOLDOWN_MESSAGE_TICKS;
    public static ForgeConfigSpec.BooleanValue WATER_SPOUTS_BUCKETABLE;
    private static final List<Predicate<Entity>> _blacklist;

    public static void initializeConfig() {
        BUILDER.push(CATEGORY_CLIENT);
        DISABLE_TEXT = BUILDER.comment("Disable text displaying on pipes. [Default: false]").define("disable_text", false);
        WARP_COOLDOWN_MESSAGE = BUILDER.comment("Display a warp cooldown message. [Default: false]").define("warp_cooldown_message", true);
        WARP_COOLDOWN_MESSAGE_TICKS = BUILDER.comment("Display a warp cooldown message with ticks. Requires \"warp_cooldown_message\". [Default: false]").define("warp_cooldown_message_with_ticks", false);
        BUILDER.pop();
        BUILDER.push(CATEGORY_COMMON);
        CREATIVE_BUBBLES = BUILDER.comment("Require creative to turn bubbles on/off. [Default: false]").define("require_creative_bubbles", false);
        CREATIVE_CLOSE_PIPES = BUILDER.comment("Require creative to open/close pipes. [Default: false]").define("require_creative_close_pipes", false);
        CREATIVE_WATER_SPOUT = BUILDER.comment("Require creative to turn water spouts on/off. [Default: false]").define("require_creative_water_spouts", false);
        CREATIVE_WRENCH_PIPE_LINKING = BUILDER.comment("Require creative to link pipes. [Default: false]").define("creative_wrench_pipe_linking", false);
        ALLOW_FAST_TRAVEL = BUILDER.comment("Allow fast travel through Clear Warp Pipes. [Default: true]").define("allow_fast_travel", true);
        ALLOW_PIPE_UNWAXING = BUILDER.comment("Allow pipes to be unwaxed with an axe. [Default: false]").define("allow_pipe_unwaxing", false);
        TELEPORT_MOBS = BUILDER.comment("Allow mobs to teleport. [Default: true]").define("teleport_mobs", true);
        TELEPORT_NON_MOBS = BUILDER.comment("Allow non living entities to teleport. [Default: true]").define("teleport_non_mobs", true);
        TELEPORT_PLAYERS = BUILDER.comment("Allow players to teleport. [Default: true]").define("teleport_players", true);
        WARP_COOLDOWN = BUILDER.comment("Cooldown between teleports in ticks. [20 ticks = 1 second] [Default: 30]").defineInRange("warp_cooldown", 50, 0, 8000);
        WATER_SPOUTS_BUCKETABLE = BUILDER.comment("Allow players to bucket water spouts. [Default: true]").define("water_spouts_bucketable", true);
        BUILDER.pop();
        BUILDER.comment("Warp Pipes Config").push(CATEGORY_DEBUG);
        DEBUG_SELECTION_BOX = BUILDER.comment("Enable debug selection box for Clear Warp Pipes. [Default: false]").define("debug_selection_box", false);
        DEBUG_SELECTION_BOX_CREATIVE = BUILDER.comment("Enable debug selection box for Clear Warp Pipes in Creative. [Default: true]").define("debug_selection_box_creative", true);
        DEBUG_PIPE_BUBBLES_SELECTION_BOX = BUILDER.comment("Enable debug selection box for Pipe Bubbles. Creative Only. [Default: false]").define("debug_pipe_bubbles_selection_box", false);
        DEBUG_WATER_SPOUT_SELECTION_BOX = BUILDER.comment("Enable debug selection box for Water Spouts. Creative Only. [Default: false]").define("debug_water_spout_selection_box", false);
        BUILDER.pop();
    }

    static {
        Config.initializeConfig();
        CONFIG = BUILDER.build();
        _blacklist = Lists.newArrayList();
    }
}

