/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks.entities;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.wenxin2.warp_pipes.blocks.PipeBubblesBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WaterSpoutBlock;
import com.wenxin2.warp_pipes.blocks.entities.PipeText;
import com.wenxin2.warp_pipes.init.ModRegistry;
import com.wenxin2.warp_pipes.init.SoundRegistry;
import com.wenxin2.warp_pipes.inventory.WarpPipeMenu;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class WarpPipeBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component DEFAULT_NAME = Component.m_237115_((String)"menu.warp_pipes.warp_pipe");
    private static final int MAX_TEXT_LINE_WIDTH = 78;
    private static final int TEXT_LINE_HEIGHT = 10;
    public PipeText pipeName = this.createDefaultPipeText();
    public static final String WARP_POS = "WarpPos";
    public static final String WARP_DIMENSION = "Dimension";
    public static final String WARP_UUID = "WarpUUID";
    public static final String UUID = "UUID";
    public static final String SPOUT_HEIGHT = "SpoutHeight";
    public static final String BUBBLES_DISTANCE = "BubblesDistance";
    public static final String PREVENT_WARP = "PreventWarp";
    public static final String IS_WAXED = "IsWaxed";
    public static final String DISPLAY_TEXT_NORTH = "displayTextNorth";
    public static final String DISPLAY_TEXT_SOUTH = "displayTextSouth";
    public static final String DISPLAY_TEXT_EAST = "displayTextEast";
    public static final String DISPLAY_TEXT_WEST = "displayTextWest";
    public static final String DISPLAY_TEXT_ABOVE = "displayTextAbove";
    public static final String DISPLAY_TEXT_BELOW = "displayTextBelow";
    public static final String CUSTOM_NAME = "CustomName";
    public static final String PIPE_NAME = "PipeName";
    @Nullable
    public Component name;
    private LockCode lockKey = LockCode.f_19102_;
    @Nullable
    public BlockPos destinationPos;
    public String dimensionTag;
    public int spoutHeight = 4;
    public int bubblesDistance = 3;
    public boolean preventWarp = Boolean.FALSE;
    public boolean isWaxed;
    public boolean displayTextNorth = Boolean.TRUE;
    public boolean displayTextSouth = Boolean.TRUE;
    public boolean displayTextEast = Boolean.TRUE;
    public boolean displayTextWest = Boolean.TRUE;
    public boolean displayTextAbove = Boolean.TRUE;
    public boolean displayTextBelow = Boolean.TRUE;
    public UUID uuid;
    public UUID warpUuid;

    public WarpPipeBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModRegistry.WARP_PIPE_BLOCK_ENTITY.get(), pos, state);
    }

    public WarpPipeBlockEntity(BlockEntityType<?> tileEntity, BlockPos pos, BlockState state) {
        super(tileEntity, pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new WarpPipeMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()));
    }

    public void setCustomName(Component name) {
        this.name = name;
        this.markUpdated();
        this.getUpdatePacket();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public Component getCustomName(Component name) {
        this.name = name;
        return this.name;
    }

    public Component m_7755_() {
        return !this.pipeName.getMessage(0, false).m_240452_((Component)Component.m_237119_()) ? this.pipeName.getMessage(0, false) : (this.name != null ? this.name : DEFAULT_NAME);
    }

    protected PipeText createDefaultPipeText() {
        return new PipeText();
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 78;
    }

    public PipeText getPipeText() {
        return this.pipeName;
    }

    public Component getPipeNameComponent() {
        return !this.pipeName.getMessage(0, false).m_240452_((Component)Component.m_237119_()) ? this.pipeName.getMessage(0, false) : (this.name != null ? this.name : DEFAULT_NAME);
    }

    public boolean updateText(UnaryOperator<PipeText> text) {
        PipeText pipeText = this.getPipeText();
        this.markUpdated();
        this.getUpdatePacket();
        return this.setText((PipeText)text.apply(pipeText));
    }

    public boolean setText(PipeText text) {
        if (text != this.pipeName) {
            this.pipeName = text;
            this.markUpdated();
            this.getUpdatePacket();
            return true;
        }
        return false;
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setWaxed(boolean isWaxed) {
        if (this.isWaxed != isWaxed) {
            this.isWaxed = isWaxed;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public boolean hasTextNorth() {
        return this.displayTextNorth;
    }

    public boolean hasTextSouth() {
        return this.displayTextSouth;
    }

    public boolean hasTextEast() {
        return this.displayTextEast;
    }

    public boolean hasTextWest() {
        return this.displayTextWest;
    }

    public boolean hasTextAbove() {
        return this.displayTextAbove;
    }

    public boolean hasTextBelow() {
        return this.displayTextBelow;
    }

    public void setTextNorth(boolean displayTextNorth) {
        if (this.displayTextNorth != displayTextNorth) {
            this.displayTextNorth = displayTextNorth;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextSouth(boolean displayTextSouth) {
        if (this.displayTextSouth != displayTextSouth) {
            this.displayTextSouth = displayTextSouth;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextEast(boolean displayTextEast) {
        if (this.displayTextEast != displayTextEast) {
            this.displayTextEast = displayTextEast;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextWest(boolean displayTextWest) {
        if (this.displayTextWest != displayTextWest) {
            this.displayTextWest = displayTextWest;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextAbove(boolean displayTextAbove) {
        if (this.displayTextAbove != displayTextAbove) {
            this.displayTextAbove = displayTextAbove;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public void setTextBelow(boolean displayTextBelow) {
        if (this.displayTextBelow != displayTextBelow) {
            this.displayTextBelow = displayTextBelow;
            this.markUpdated();
            this.getUpdatePacket();
        }
    }

    public boolean hasDestinationPos() {
        return this.destinationPos != null;
    }

    public void setDestinationPos(@Nullable BlockPos pos) {
        this.destinationPos = pos;
        if (this.f_58857_ != null && pos != null) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7731_(this.m_58899_(), state, 4);
        }
    }

    @Nullable
    public BlockPos getDestinationPos() {
        if (this.destinationPos != null) {
            return this.destinationPos;
        }
        return null;
    }

    @Nullable
    public ResourceKey<Level> getDestinationDim() {
        ResourceLocation location;
        if (this.dimensionTag != null && (location = ResourceLocation.m_135820_((String)this.dimensionTag)) != null) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
        }
        return null;
    }

    public void setDestinationDim(@Nullable ResourceKey<Level> dimension) {
        if (dimension != null) {
            this.dimensionTag = dimension.m_135782_().toString();
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), this.m_58900_(), 4);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setPreventWarp(boolean preventWarp) {
        this.preventWarp = preventWarp;
    }

    public UUID getWarpUuid() {
        return this.warpUuid;
    }

    public void setWarpUuid(UUID uuid) {
        this.warpUuid = uuid;
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private static CommandSourceStack createCommandSourceStack(@Nullable Player player, Level world, BlockPos pos) {
        String s = player == null ? "Pipe" : player.m_7755_().getString();
        MutableComponent component = player == null ? Component.m_237113_((String)"Pipe") : player.m_5446_();
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)pos), Vec2.f_82462_, (ServerLevel)world, 2, s, (Component)component, world.m_7654_(), (Entity)player);
    }

    private PipeText loadLines(PipeText text) {
        for (int i = 0; i < 1; ++i) {
            Component message = this.loadLine(text.getMessage(i, false));
            Component filteredMessage = this.loadLine(text.getMessage(i, true));
            text = text.setMessage(i, message, filteredMessage);
        }
        return text;
    }

    private Component loadLine(Component text) {
        Level world = this.f_58857_;
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            try {
                return ComponentUtils.m_130731_((CommandSourceStack)WarpPipeBlockEntity.createCommandSourceStack(null, (Level)serverWorld, this.f_58858_), (Component)text, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lockKey = LockCode.m_19111_((CompoundTag)tag);
        this.spoutHeight = tag.m_128451_(SPOUT_HEIGHT);
        this.bubblesDistance = tag.m_128451_(BUBBLES_DISTANCE);
        this.isWaxed = tag.m_128471_(IS_WAXED);
        this.displayTextNorth = tag.m_128471_(DISPLAY_TEXT_NORTH);
        this.displayTextSouth = tag.m_128471_(DISPLAY_TEXT_SOUTH);
        this.displayTextEast = tag.m_128471_(DISPLAY_TEXT_EAST);
        this.displayTextWest = tag.m_128471_(DISPLAY_TEXT_WEST);
        this.displayTextAbove = tag.m_128471_(DISPLAY_TEXT_ABOVE);
        this.displayTextBelow = tag.m_128471_(DISPLAY_TEXT_BELOW);
        if (tag.m_128425_(CUSTOM_NAME, 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_(CUSTOM_NAME));
        }
        if (tag.m_128441_(PIPE_NAME)) {
            PipeText.DIRECT_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_(PIPE_NAME)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(text -> {
                this.pipeName = this.loadLines((PipeText)text);
            });
        }
        if (tag.m_128441_(WARP_POS)) {
            this.destinationPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(WARP_POS));
            this.setDestinationPos(this.destinationPos);
        }
        if (tag.m_128441_(WARP_DIMENSION)) {
            this.dimensionTag = tag.m_128461_(WARP_DIMENSION);
        }
        if (tag.m_128441_(PREVENT_WARP)) {
            this.preventWarp = tag.m_128471_(PREVENT_WARP);
        }
        if (tag.m_128441_(UUID)) {
            this.uuid = tag.m_128342_(UUID);
        }
        if (tag.m_128441_(WARP_UUID)) {
            this.warpUuid = tag.m_128342_(WARP_UUID);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.lockKey.m_19109_(tag);
        tag.m_128405_(BUBBLES_DISTANCE, this.bubblesDistance);
        tag.m_128405_(SPOUT_HEIGHT, this.spoutHeight);
        tag.m_128379_(PREVENT_WARP, this.preventWarp);
        tag.m_128379_(IS_WAXED, this.isWaxed);
        tag.m_128379_(DISPLAY_TEXT_NORTH, this.displayTextNorth);
        tag.m_128379_(DISPLAY_TEXT_SOUTH, this.displayTextSouth);
        tag.m_128379_(DISPLAY_TEXT_EAST, this.displayTextEast);
        tag.m_128379_(DISPLAY_TEXT_WEST, this.displayTextWest);
        tag.m_128379_(DISPLAY_TEXT_ABOVE, this.displayTextAbove);
        tag.m_128379_(DISPLAY_TEXT_BELOW, this.displayTextBelow);
        if (this.name != null) {
            tag.m_128359_(CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.name));
        }
        PipeText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.pipeName).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(pipeName -> tag.m_128365_(PIPE_NAME, pipeName));
        if (this.hasDestinationPos() && this.destinationPos != null) {
            tag.m_128365_(WARP_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.destinationPos));
        }
        if (this.dimensionTag != null) {
            tag.m_128359_(WARP_DIMENSION, this.dimensionTag);
        }
        if (this.uuid != null) {
            tag.m_128362_(UUID, this.getUuid());
        }
        if (this.warpUuid != null) {
            tag.m_128362_(WARP_UUID, this.getWarpUuid());
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void closePipe(ServerPlayer player) {
        if (this.f_58857_ != null && player.f_36096_ instanceof WarpPipeMenu) {
            BlockState state = this.f_58857_.m_8055_(((WarpPipeMenu)player.f_36096_).getBlockPos());
            BlockPos menuPos = ((WarpPipeMenu)player.f_36096_).getBlockPos();
            if (((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                this.f_58857_.m_7731_(menuPos, (BlockState)state.m_61124_((Property)WarpPipeBlock.CLOSED, (Comparable)Boolean.FALSE), 3);
                this.playSound(this.f_58857_, menuPos, (SoundEvent)SoundRegistry.PIPE_OPENS.get(), SoundSource.BLOCKS, 1.0f, 0.15f);
            } else {
                if (this.f_58857_.m_8055_(menuPos.m_7494_()).m_60734_() instanceof WaterSpoutBlock) {
                    this.f_58857_.m_46961_(menuPos.m_7494_(), false);
                }
                this.f_58857_.m_7731_(menuPos, (BlockState)state.m_61124_((Property)WarpPipeBlock.CLOSED, (Comparable)Boolean.TRUE), 0);
                this.playSound(this.f_58857_, menuPos, (SoundEvent)SoundRegistry.PIPE_CLOSES.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public void toggleWaterSpout(ServerPlayer player) {
        if (this.f_58857_ != null && player.f_36096_ instanceof WarpPipeMenu) {
            BlockState state = this.f_58857_.m_8055_(((WarpPipeMenu)player.f_36096_).getBlockPos());
            BlockPos menuPos = ((WarpPipeMenu)player.f_36096_).getBlockPos();
            if (((Boolean)state.m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue()) {
                this.f_58857_.m_7731_(menuPos, (BlockState)state.m_61124_((Property)WarpPipeBlock.WATER_SPOUT, (Comparable)Boolean.FALSE), 3);
                this.playSound(this.f_58857_, menuPos, (SoundEvent)SoundRegistry.WATER_SPOUT_BREAK.get(), SoundSource.BLOCKS, 1.0f, 0.15f);
            } else {
                this.f_58857_.m_7731_(menuPos, (BlockState)state.m_61124_((Property)WarpPipeBlock.WATER_SPOUT, (Comparable)Boolean.TRUE), 3);
                this.playSound(this.f_58857_, menuPos, (SoundEvent)SoundRegistry.WATER_SPOUT_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public void waterSpoutHeight(ServerPlayer player, int spoutHeight) {
        if (this.f_58857_ != null && this.getUpdatePacket() != null && player.f_36096_ instanceof WarpPipeMenu && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof WarpPipeBlock) {
            this.setSpoutHeight(spoutHeight);
        }
    }

    public void setSpoutHeight(int spoutHeight) {
        BlockPos pos;
        BlockEntity blockEntity;
        Level world = this.f_58857_;
        if (world != null && (blockEntity = world.m_7702_(pos = this.m_58899_())) instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
            if (world.m_8055_(pos.m_7494_()).m_60734_() instanceof WaterSpoutBlock) {
                world.m_46961_(pos.m_7494_(), false);
            }
            this.spoutHeight = spoutHeight;
            pipeBlockEntity.m_6596_();
        }
    }

    public int getSpoutHeight() {
        return this.spoutHeight;
    }

    public void bubblesDistance(ServerPlayer player, int bubblesDistance) {
        if (this.f_58857_ != null && this.getUpdatePacket() != null && player.f_36096_ instanceof WarpPipeMenu && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof WarpPipeBlock) {
            this.setBubblesDistance(bubblesDistance);
        }
    }

    public void setBubblesDistance(int bubblesDistance) {
        Level world = this.f_58857_;
        if (world != null) {
            BlockPos pos = this.m_58899_();
            BlockState state = world.m_8055_(pos);
            BlockState stateAbove = world.m_8055_(pos.m_7494_());
            BlockState stateBelow = world.m_8055_(pos.m_7495_());
            BlockState stateNorth = world.m_8055_(pos.m_122012_());
            BlockState stateSouth = world.m_8055_(pos.m_122019_());
            BlockState stateEast = world.m_8055_(pos.m_122029_());
            BlockState stateWest = world.m_8055_(pos.m_122024_());
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof WarpPipeBlockEntity) {
                WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
                if (stateAbove.m_60734_() instanceof PipeBubblesBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP) {
                    world.m_46961_(pos.m_7494_(), false);
                }
                if (stateBelow.m_60734_() instanceof PipeBubblesBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN) {
                    world.m_46961_(pos.m_7495_(), false);
                }
                if (stateNorth.m_60734_() instanceof PipeBubblesBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH) {
                    world.m_46961_(pos.m_122012_(), false);
                }
                if (stateSouth.m_60734_() instanceof PipeBubblesBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH) {
                    world.m_46961_(pos.m_122019_(), false);
                }
                if (stateEast.m_60734_() instanceof PipeBubblesBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST) {
                    world.m_46961_(pos.m_122029_(), false);
                }
                if (stateWest.m_60734_() instanceof PipeBubblesBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST) {
                    world.m_46961_(pos.m_122024_(), false);
                }
                this.bubblesDistance = bubblesDistance;
                pipeBlockEntity.m_6596_();
            }
        }
    }

    public int getBubblesDistance() {
        return this.bubblesDistance;
    }

    public void togglePipeBubbles(ServerPlayer player) {
        if (this.f_58857_ != null && player.f_36096_ instanceof WarpPipeMenu) {
            BlockState state = this.f_58857_.m_8055_(((WarpPipeMenu)player.f_36096_).getBlockPos());
            BlockPos menuPos = ((WarpPipeMenu)player.f_36096_).getBlockPos();
            if (((Boolean)state.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()) {
                this.f_58857_.m_7731_(menuPos, (BlockState)state.m_61124_((Property)WarpPipeBlock.BUBBLES, (Comparable)Boolean.FALSE), 3);
                this.playSound(this.f_58857_, menuPos, SoundEvents.f_11773_, SoundSource.BLOCKS, 1.0f, 0.15f);
            } else {
                this.f_58857_.m_7731_(menuPos, (BlockState)state.m_61124_((Property)WarpPipeBlock.BUBBLES, (Comparable)Boolean.TRUE), 3);
                this.playSound(this.f_58857_, menuPos, SoundEvents.f_11774_, SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public void playSound(Level world, BlockPos pos, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        world.m_5594_(null, pos, soundEvent, source, volume, pitch);
    }

    public void sendData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.m_7726_().m_8450_(this.m_58899_());
        }
    }
}

