/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks.entities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class PipeText {
    private static final Codec<Component[]> LINES_CODEC = ExtraCodecs.f_276686_.listOf().comapFlatMap(list -> {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }, components -> List.of(components[0]));
    public static final Codec<PipeText> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LINES_CODEC.fieldOf("pipe_name").forGetter(pipeText -> pipeText.messages), (App)LINES_CODEC.optionalFieldOf("filtered_pipe_name").forGetter(PipeText::getOnlyFilteredMessages), (App)DyeColor.f_262211_.fieldOf("color").orElse((Object)DyeColor.BLACK).forGetter(pipeText -> pipeText.color), (App)Codec.BOOL.fieldOf("has_glowing_text").orElse((Object)false).forGetter(pipeText -> pipeText.hasGlowingText)).apply((Applicative)instance, PipeText::load));
    public static final int LINES = 1;
    private final Component[] messages;
    private final Component[] filteredMessages;
    private final DyeColor color;
    private final boolean hasGlowingText;
    @Nullable
    private FormattedCharSequence[] renderMessages;
    private boolean renderMessagedFiltered;

    public PipeText() {
        this(PipeText.emptyMessages(), PipeText.emptyMessages(), DyeColor.BLACK, false);
    }

    public PipeText(Component[] messages, Component[] filteredMessages, DyeColor color, boolean hasGlowingText) {
        this.messages = messages;
        this.filteredMessages = filteredMessages;
        this.color = color;
        this.hasGlowingText = hasGlowingText;
    }

    private static Component[] emptyMessages() {
        return new Component[]{CommonComponents.f_237098_};
    }

    private static PipeText load(Component[] messages, Optional<Component[]> filteredMessages, DyeColor color, boolean hasGlowingText) {
        Component[] filteredMessagesArray = filteredMessages.orElseGet(PipeText::emptyMessages);
        PipeText.populateFilteredMessagesWithRawMessages(messages, filteredMessagesArray);
        return new PipeText(messages, filteredMessagesArray, color, hasGlowingText);
    }

    private static void populateFilteredMessagesWithRawMessages(Component[] messages, Component[] filteredMessages) {
        for (int i = 0; i < 1; ++i) {
            if (!filteredMessages[i].equals(CommonComponents.f_237098_)) continue;
            filteredMessages[i] = messages[i];
        }
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public PipeText setHasGlowingText(boolean hasGlowingText) {
        return hasGlowingText == this.hasGlowingText ? this : new PipeText(this.messages, this.filteredMessages, this.color, hasGlowingText);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public PipeText setColor(DyeColor color) {
        return color == this.getColor() ? this : new PipeText(this.messages, this.filteredMessages, color, this.hasGlowingText);
    }

    public Component getMessage(int index, boolean isFiltered) {
        return this.getMessages(isFiltered)[index];
    }

    public PipeText setMessage(int index, Component text) {
        return this.setMessage(index, text, text);
    }

    public PipeText setMessage(int index, Component text, Component filteredText) {
        Component[] messagesArray = Arrays.copyOf(this.messages, this.messages.length);
        Component[] filteredMessagesArray = Arrays.copyOf(this.filteredMessages, this.filteredMessages.length);
        messagesArray[index] = text;
        filteredMessagesArray[index] = filteredText;
        return new PipeText(messagesArray, filteredMessagesArray, this.color, this.hasGlowingText);
    }

    public boolean hasMessage(Player player) {
        return Arrays.stream(this.getMessages(player.m_143387_())).anyMatch(message -> !message.getString().isEmpty());
    }

    public Component[] getMessages(boolean isFiltered) {
        return isFiltered ? this.filteredMessages : this.messages;
    }

    public FormattedCharSequence[] getRenderMessages(boolean renderMessagesFiltered, Function<Component, FormattedCharSequence> formatter) {
        if (this.renderMessages == null || this.renderMessagedFiltered != renderMessagesFiltered) {
            this.renderMessagedFiltered = renderMessagesFiltered;
            this.renderMessages = new FormattedCharSequence[1];
            for (int i = 0; i < 1; ++i) {
                this.renderMessages[i] = formatter.apply(this.getMessage(i, renderMessagesFiltered));
            }
        }
        return this.renderMessages;
    }

    private Optional<Component[]> getOnlyFilteredMessages() {
        Component[] filteredMessagesArray = new Component[1];
        boolean flag = false;
        for (int i = 0; i < 1; ++i) {
            Component filteredMessages = this.filteredMessages[i];
            if (!filteredMessages.equals(this.messages[i])) {
                filteredMessagesArray[i] = filteredMessages;
                flag = true;
                continue;
            }
            filteredMessagesArray[i] = CommonComponents.f_237098_;
        }
        return flag ? Optional.of(filteredMessagesArray) : Optional.empty();
    }

    public boolean hasAnyClickCommands(Player player) {
        for (Component component : this.getMessages(player.m_143387_())) {
            Style style = component.m_7383_();
            ClickEvent clickevent = style.m_131182_();
            if (clickevent == null || clickevent.m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }
}

