/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.PipeText;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WarpPipeBlockEntityRenderer
implements BlockEntityRenderer<WarpPipeBlockEntity> {
    private static final float TEXT_RENDER_SCALE = 0.0125f;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font font;

    public WarpPipeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(WarpPipeBlockEntity blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!((Boolean)Config.DISABLE_TEXT.get()).booleanValue()) {
            this.renderPipeWithText(blockEntity, stack, buffer, packedLight);
        }
    }

    void renderPipeWithText(WarpPipeBlockEntity pipeBlockEntity, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        BlockState state = pipeBlockEntity.m_58900_();
        stack.m_85836_();
        if (((Boolean)state.m_61143_((Property)WarpPipeBlock.ENTRANCE)).booleanValue() && state.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.NORTH && state.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.SOUTH) {
            if (pipeBlockEntity.hasTextNorth()) {
                this.renderPipeTextNorth(pipeBlockEntity, pipeBlockEntity.m_58899_(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
            if (pipeBlockEntity.hasTextSouth()) {
                this.renderPipeTextSouth(pipeBlockEntity, pipeBlockEntity.m_58899_(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
        }
        if (((Boolean)state.m_61143_((Property)WarpPipeBlock.ENTRANCE)).booleanValue() && state.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.EAST && state.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.WEST) {
            if (pipeBlockEntity.hasTextEast()) {
                this.renderPipeTextEast(pipeBlockEntity, pipeBlockEntity.m_58899_(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
            if (pipeBlockEntity.hasTextWest()) {
                this.renderPipeTextWest(pipeBlockEntity, pipeBlockEntity.m_58899_(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
        }
        if (((Boolean)state.m_61143_((Property)WarpPipeBlock.ENTRANCE)).booleanValue() && state.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.UP && state.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.DOWN) {
            if (pipeBlockEntity.hasTextAbove()) {
                this.renderPipeTextAbove(pipeBlockEntity, pipeBlockEntity.m_58899_(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
            if (pipeBlockEntity.hasTextBelow()) {
                this.renderPipeTextBelow(pipeBlockEntity, pipeBlockEntity.m_58899_(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
        }
        stack.m_85849_();
    }

    void renderPipeTextNorth(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.m_58900_();
        Level world = pipeBlockEntity.m_58904_();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        stack.m_85836_();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().m_41071_();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.m_85836_();
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP) {
                stack.m_85837_(0.5, 0.825, -0.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN) {
                stack.m_85837_(0.5, 0.175, -0.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST) {
                stack.m_85837_(0.825, 0.5, -0.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST) {
                stack.m_85837_(0.175, 0.5, -0.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            }
            stack.m_85841_(1.0f, -1.0f, -1.0f);
            stack.m_85841_(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.m_85837_(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateNorth = world.m_8055_(pos.m_122012_());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.m_60734_() instanceof ClearWarpPipeBlock) {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateNorth.m_280296_() && stateNorth.m_60804_((BlockGetter)world, pos.m_122012_()) || state.m_60734_() instanceof ClearWarpPipeBlock && stateNorth.m_60734_() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.m_168645_(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.m_85850_().m_252922_(), buffer, packedLightL);
                    continue;
                }
                this.font.m_272191_(pipeName, 0.0f, 0.0f, textColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    void renderPipeTextSouth(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.m_58900_();
        Level world = pipeBlockEntity.m_58904_();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        stack.m_85836_();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().m_41071_();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.m_85836_();
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP) {
                stack.m_85837_(0.5, 0.825, 1.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN) {
                stack.m_85837_(0.5, 0.175, 1.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST) {
                stack.m_85837_(0.825, 0.5, 1.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST) {
                stack.m_85837_(0.175, 0.5, 1.001);
                stack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            stack.m_85841_(1.0f, -1.0f, -1.0f);
            stack.m_85841_(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.m_85837_(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateSouth = world.m_8055_(pos.m_122019_());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.m_60734_() instanceof ClearWarpPipeBlock) {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateSouth.m_280296_() && stateSouth.m_60804_((BlockGetter)world, pos.m_122019_()) || state.m_60734_() instanceof ClearWarpPipeBlock && stateSouth.m_60734_() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.m_168645_(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.m_85850_().m_252922_(), buffer, packedLightL);
                    continue;
                }
                this.font.m_272191_(pipeName, 0.0f, 0.0f, textColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    void renderPipeTextEast(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.m_58900_();
        Level world = pipeBlockEntity.m_58904_();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        stack.m_85836_();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().m_41071_();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.m_85836_();
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP) {
                stack.m_85837_(1.001, 0.825, 0.5);
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN) {
                stack.m_85837_(1.001, 0.175, 0.5);
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH) {
                stack.m_85837_(1.001, 0.5, 0.175);
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH) {
                stack.m_85837_(1.001, 0.5, 0.825);
                stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            stack.m_85841_(1.0f, -1.0f, -1.0f);
            stack.m_85841_(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.m_85837_(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateEast = world.m_8055_(pos.m_122029_());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.m_60734_() instanceof ClearWarpPipeBlock) {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateEast.m_280296_() && stateEast.m_60804_((BlockGetter)world, pos.m_122029_()) || state.m_60734_() instanceof ClearWarpPipeBlock && stateEast.m_60734_() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.m_168645_(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.m_85850_().m_252922_(), buffer, packedLightL);
                    continue;
                }
                this.font.m_272191_(pipeName, 0.0f, 0.0f, textColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    void renderPipeTextWest(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.m_58900_();
        Level world = pipeBlockEntity.m_58904_();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        stack.m_85836_();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().m_41071_();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.m_85836_();
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP) {
                stack.m_85837_(-0.001, 0.825, 0.5);
                stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.DOWN) {
                stack.m_85837_(-0.001, 0.175, 0.5);
                stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH) {
                stack.m_85837_(-0.001, 0.5, 0.175);
                stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH) {
                stack.m_85837_(-0.001, 0.5, 0.825);
                stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            }
            stack.m_85841_(1.0f, -1.0f, -1.0f);
            stack.m_85841_(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.m_85837_(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateWest = world.m_8055_(pos.m_122024_());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.m_60734_() instanceof ClearWarpPipeBlock) {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateWest.m_280296_() && stateWest.m_60804_((BlockGetter)world, pos.m_122024_()) || state.m_60734_() instanceof ClearWarpPipeBlock && stateWest.m_60734_() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.m_168645_(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.m_85850_().m_252922_(), buffer, packedLightL);
                    continue;
                }
                this.font.m_272191_(pipeName, 0.0f, 0.0f, textColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    void renderPipeTextAbove(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.m_58900_();
        Level world = pipeBlockEntity.m_58904_();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        stack.m_85836_();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().m_41071_();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.m_85836_();
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH) {
                stack.m_85837_(0.5, 1.001, 0.175);
                stack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH) {
                stack.m_85837_(0.5, 1.001, 0.825);
                stack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST) {
                stack.m_85837_(0.825, 1.001, 0.5);
                stack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST) {
                stack.m_85837_(0.175, 1.001, 0.5);
                stack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            stack.m_85841_(1.0f, -1.0f, -1.0f);
            stack.m_85841_(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.m_85837_(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateAbove = world.m_8055_(pos.m_7494_());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.m_60734_() instanceof ClearWarpPipeBlock) {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateAbove.m_280296_() && stateAbove.m_60804_((BlockGetter)world, pos.m_7494_()) || state.m_60734_() instanceof ClearWarpPipeBlock && stateAbove.m_60734_() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.m_168645_(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.m_85850_().m_252922_(), buffer, packedLightL);
                    continue;
                }
                this.font.m_272191_(pipeName, 0.0f, 0.0f, textColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    void renderPipeTextBelow(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.m_58900_();
        Level world = pipeBlockEntity.m_58904_();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.font.m_92923_((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        stack.m_85836_();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().m_41071_();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.m_85836_();
            if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.NORTH) {
                stack.m_85837_(0.5, -0.001, 0.175);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.SOUTH) {
                stack.m_85837_(0.5, -0.001, 0.825);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.EAST) {
                stack.m_85837_(0.825, -0.001, 0.5);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            } else if (state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.WEST) {
                stack.m_85837_(0.175, -0.001, 0.5);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            stack.m_85841_(1.0f, -1.0f, -1.0f);
            stack.m_85841_(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.m_85837_(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateBelow = world.m_8055_(pos.m_7495_());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.m_60734_() instanceof ClearWarpPipeBlock) {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.m_85837_((double)(-this.font.m_92724_(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateBelow.m_280296_() && stateBelow.m_60804_((BlockGetter)world, pos.m_7495_()) || state.m_60734_() instanceof ClearWarpPipeBlock && stateBelow.m_60734_() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.m_168645_(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.m_85850_().m_252922_(), buffer, packedLightL);
                    continue;
                }
                this.font.m_272191_(pipeName, 0.0f, 0.0f, textColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    static boolean isOutlineVisible(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    static int getDarkColor(PipeText pipeText) {
        int textColor = pipeText.getColor().m_41071_();
        if (textColor == DyeColor.BLACK.m_41071_() && pipeText.hasGlowingText()) {
            return -988212;
        }
        double d0 = 0.4;
        int j = (int)((double)FastColor.ARGB32.m_13665_((int)textColor) * 0.4);
        int k = (int)((double)FastColor.ARGB32.m_13667_((int)textColor) * 0.4);
        int l = (int)((double)FastColor.ARGB32.m_13669_((int)textColor) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)j, (int)k, (int)l);
    }
}

