/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import com.wenxin2.warp_pipes.init.ModRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaterSpoutBlock
extends Block
implements BucketPickup {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final VoxelShape SPOUT = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0).m_83296_(), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape SPOUT_TOP = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0).m_83296_(), (VoxelShape[])new VoxelShape[0]);

    public WaterSpoutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{TOP});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Player player = (Player)((EntityCollisionContext)context).m_193113_();
        if (player != null && (player.m_20310_(1) && player.m_7500_() && (Boolean)Config.DEBUG_WATER_SPOUT_SELECTION_BOX.get() != false || player.m_21120_(player.m_7655_()).m_41720_() instanceof BucketItem && (Boolean)Config.WATER_SPOUTS_BUCKETABLE.get() != false || player.m_21120_(player.m_7655_()).m_41720_() instanceof DebugStickItem)) {
            if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
                return SPOUT_TOP;
            }
            return SPOUT;
        }
        return Shapes.m_83048_((double)8.0, (double)8.0, (double)8.0, (double)8.00001, (double)8.00001, (double)8.00001);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        super.m_7417_(state, direction, neighborState, worldAccessor, pos, neighborPos);
        BlockState stateAbove = worldAccessor.m_8055_(pos.m_7494_());
        BlockState stateBelow = worldAccessor.m_8055_(pos.m_7495_());
        if (stateBelow.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || stateBelow.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.UP || !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_50016_.m_49966_();
        }
        if (stateBelow.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || stateBelow.m_61143_((Property)WarpPipeBlock.f_52588_) != Direction.UP || !((Boolean)stateBelow.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_50016_.m_49966_();
        }
        if (!(stateBelow.m_60734_() instanceof WarpPipeBlock) && !(stateBelow.m_60734_() instanceof WaterSpoutBlock)) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_50016_.m_49966_();
        }
        if (stateAbove.m_60734_() != ModRegistry.WATER_SPOUT.get()) {
            return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.TRUE);
        }
        return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.FALSE);
    }

    public boolean m_7898_(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockState stateBelow = worldReader.m_8055_(pos.m_7495_());
        if (stateBelow.m_60713_((Block)ModRegistry.WATER_SPOUT.get())) {
            return true;
        }
        if (stateBelow.m_60713_(Blocks.f_49990_) && stateBelow.m_60819_().m_76186_() >= 8 && stateBelow.m_60819_().m_76170_()) {
            return true;
        }
        if (stateBelow.m_60734_() instanceof WarpPipeBlock && stateBelow.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP && !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !(stateBelow.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        return stateBelow.m_60734_() instanceof ClearWarpPipeBlock && stateBelow.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP && (Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED) == false && (Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.WATER_SPOUT) != false && (Boolean)stateBelow.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED) != false;
    }

    public static boolean canExistIn(LevelAccessor worldAccessor, BlockPos pos) {
        return worldAccessor.m_8055_(pos).m_60713_((Block)ModRegistry.WATER_SPOUT.get()) || worldAccessor.m_8055_(pos).m_60795_();
    }

    public static BlockState setBlockState(BlockState state, LevelAccessor worldAccessor, BlockPos pos) {
        BlockState stateAbove = worldAccessor.m_8055_(pos.m_7494_());
        if (state.m_60795_() || state.m_60713_((Block)ModRegistry.WATER_SPOUT.get()) || state.m_60734_() instanceof WarpPipeBlock && ((Boolean)state.m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
            if (state.m_60713_((Block)ModRegistry.WATER_SPOUT.get())) {
                if (!stateAbove.m_60713_((Block)ModRegistry.WATER_SPOUT.get())) {
                    return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.TRUE);
                }
                return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.FALSE);
            }
            if (state.m_60734_() instanceof WarpPipeBlock && state.m_61143_((Property)WarpPipeBlock.f_52588_) == Direction.UP && ((Boolean)state.m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                if (!stateAbove.m_60713_((Block)ModRegistry.WATER_SPOUT.get())) {
                    return (BlockState)((Block)ModRegistry.WATER_SPOUT.get()).m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.TRUE);
                }
                return (BlockState)((Block)ModRegistry.WATER_SPOUT.get()).m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.FALSE);
            }
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void addParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, int amt, double xMotion, double yMotion, double zMotion, double speed) {
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_(particleOptions, xPos, yPos, zPos, amt, xMotion, yMotion, zMotion, speed);
        }
    }

    public void addAlwaysVisibleParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, double xMotion, double yMotion, double zMotion) {
        if (world.f_46443_) {
            world.m_7107_(particleOptions, xPos, yPos, zPos, xMotion, yMotion, zMotion);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double randomNum = -1.0 + random.m_188500_();
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        if (world.m_8055_(pos.m_7494_()).m_60795_()) {
            for (int i = 0; i < 75; ++i) {
                this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123769_, x + random.m_188500_(), y + 1.0, z + random.m_188500_(), randomNum, 0.04, randomNum);
            }
        }
        if (random.m_188503_(20) == 0) {
            world.m_7785_(x, y, z, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        if (stateAbove.m_60795_()) {
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                boat.m_6845_(Boolean.FALSE.booleanValue());
            } else {
                this.onAboveUpBubbleCol(entity);
            }
            if (!world.f_46443_) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            this.onInsideUpBubbleColumn(entity);
            if (!world.f_46443_) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!world.f_46443_ && livingEntity.canDrownInFluidType(Fluids.f_76193_.getFluidType())) {
                int refillAmount = 1;
                int newAir = Math.min(livingEntity.m_20146_() + refillAmount, livingEntity.m_6062_());
                livingEntity.m_20301_(newAir);
            }
        }
    }

    public void onAboveUpBubbleCol(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = Math.min(1.8, vec3.f_82480_ + 0.1);
        entity.m_20334_(vec3.f_82479_, d0, vec3.f_82481_);
    }

    public void onInsideUpBubbleColumn(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = Math.min(0.5, vec3.f_82480_ + 0.04);
        entity.m_20334_(vec3.f_82479_, d0 + 0.05, vec3.f_82481_);
        entity.m_183634_();
    }

    public void m_213897_(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)serverWorld.m_7702_(pos.m_7495_());
        if (pipeBlockEntity != null && ((Boolean)pipeBlockEntity.m_58900_().m_61143_((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue()) {
            WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_7495_()), pipeBlockEntity.spoutHeight);
        } else {
            WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_7495_()), 0);
        }
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int spoutHeight) {
        WaterSpoutBlock.repeatColumnUp(worldAccessor, pos, worldAccessor.m_8055_(pos), state, spoutHeight);
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int spoutHeight) {
        if (WaterSpoutBlock.canExistIn(worldAccessor, pos) && spoutHeight != 0) {
            int initialDistance = 0;
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.UP);
            BlockState pipeColumnState = WaterSpoutBlock.setBlockState(neighborState, worldAccessor, pos);
            BlockState stateAbove = worldAccessor.m_8055_(mutablePos.m_7494_());
            if (pipeColumnState.m_60734_() instanceof WaterSpoutBlock) {
                if (stateAbove.m_60734_() != ModRegistry.WATER_SPOUT.get()) {
                    worldAccessor.m_7731_(pos, (BlockState)pipeColumnState.m_61124_((Property)TOP, (Comparable)Boolean.TRUE), 2);
                } else {
                    worldAccessor.m_7731_(pos, (BlockState)pipeColumnState.m_61124_((Property)TOP, (Comparable)Boolean.FALSE), 2);
                }
            } else {
                worldAccessor.m_7731_(pos, pipeColumnState, 2);
            }
            worldAccessor.m_186460_(pos, (Block)ModRegistry.WATER_SPOUT.get(), 3);
            while (WaterSpoutBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < spoutHeight - 1) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.UP);
                ++initialDistance;
                pipeColumnState = WaterSpoutBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public ItemStack m_142598_(LevelAccessor worldAccessor, BlockPos pos, BlockState state) {
        if (((Boolean)Config.WATER_SPOUTS_BUCKETABLE.get()).booleanValue()) {
            worldAccessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }
}

