/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.PipeBubblesBlock;
import com.wenxin2.warp_pipes.blocks.WaterSpoutBlock;
import com.wenxin2.warp_pipes.blocks.entities.PipeText;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import com.wenxin2.warp_pipes.init.ModRegistry;
import com.wenxin2.warp_pipes.init.SoundRegistry;
import com.wenxin2.warp_pipes.integration.CompatRegistry;
import com.wenxin2.warp_pipes.inventory.WarpPipeMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class WarpPipeBlock
extends DirectionalBlock
implements EntityBlock {
    public static final BooleanProperty ENTRANCE = BooleanProperty.m_61465_((String)"entrance");
    public static final BooleanProperty CLOSED = BooleanProperty.m_61465_((String)"closed");
    public static final BooleanProperty BUBBLES = BooleanProperty.m_61465_((String)"bubbles");
    public static final BooleanProperty WATER_SPOUT = BooleanProperty.m_61465_((String)"water_spout");
    public static final Map<Integer, Boolean> teleportedEntities = new HashMap<Integer, Boolean>();

    public WarpPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)WATER_SPOUT, (Comparable)Boolean.FALSE)).m_61124_((Property)BUBBLES, (Comparable)Boolean.TRUE)).m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE)).m_61124_((Property)CLOSED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BUBBLES, CLOSED, ENTRANCE, f_52588_, WATER_SPOUT});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WarpPipeBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        RandomSource random = world.m_213780_();
        BlockEntity blockEntity = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue() && player.m_21120_(hand).m_41720_() == ModRegistry.PIPE_WRENCH.get()) {
            if (blockEntity instanceof WarpPipeBlockEntity) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new WarpPipeMenu(id, playerInventory, ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos), pos), ((WarpPipeBlockEntity)blockEntity).m_5446_()));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof WarpPipeBlockEntity) {
            ServerPlayer serverPlayer;
            WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
            boolean isSuccesful = false;
            boolean isSuccesfulTool = false;
            if (!pipeBlockEntity.isWaxed()) {
                DyeItem dyeItem;
                if (item == Items.f_42532_) {
                    if (pipeBlockEntity.updateText(pipeText -> pipeText.setHasGlowingText(Boolean.FALSE))) {
                        world.m_5594_(player, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.coloredDustParticles(world, pos, new Vector3f(0.0f, 0.0f, 0.0f), UniformInt.m_146622_((int)8, (int)12));
                        pipeBlockEntity.m_5995_();
                        isSuccesful = true;
                    }
                } else if (item == Items.f_151056_) {
                    if (pipeBlockEntity.updateText(pipeText -> pipeText.setHasGlowingText(Boolean.TRUE))) {
                        world.m_5594_(player, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WarpPipeBlock.spawnParticlesOnBlockFaces(world, pos, (ParticleOptions)ParticleTypes.f_175827_, new Vec3(0.0, 0.0, 0.0), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                        pipeBlockEntity.m_5995_();
                        isSuccesful = true;
                    }
                } else if (item == Items.f_42784_) {
                    pipeBlockEntity.setWaxed(Boolean.TRUE);
                    world.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ParticleUtils.m_216313_((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_175828_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                    pipeBlockEntity.m_5995_();
                    isSuccesful = true;
                } else if (stack.m_150930_(Items.f_271356_)) {
                    if (hit.m_82434_() == Direction.NORTH) {
                        pipeBlockEntity.setTextNorth(!pipeBlockEntity.hasTextNorth());
                        this.dyedDustParticles(pipeBlockEntity, world, pos, Direction.NORTH);
                    } else if (hit.m_82434_() == Direction.SOUTH) {
                        pipeBlockEntity.setTextSouth(!pipeBlockEntity.hasTextSouth());
                        this.dyedDustParticles(pipeBlockEntity, world, pos, Direction.SOUTH);
                    } else if (hit.m_82434_() == Direction.EAST) {
                        pipeBlockEntity.setTextEast(!pipeBlockEntity.hasTextEast());
                        this.dyedDustParticles(pipeBlockEntity, world, pos, Direction.EAST);
                    } else if (hit.m_82434_() == Direction.WEST) {
                        pipeBlockEntity.setTextWest(!pipeBlockEntity.hasTextWest());
                        this.dyedDustParticles(pipeBlockEntity, world, pos, Direction.WEST);
                    } else if (hit.m_82434_() == Direction.UP) {
                        pipeBlockEntity.setTextAbove(!pipeBlockEntity.hasTextAbove());
                        this.dyedDustParticles(pipeBlockEntity, world, pos, Direction.UP);
                    } else if (hit.m_82434_() == Direction.DOWN) {
                        pipeBlockEntity.setTextBelow(!pipeBlockEntity.hasTextBelow());
                        this.dyedDustParticles(pipeBlockEntity, world, pos, Direction.DOWN);
                    }
                    world.m_5594_(player, pos, SoundEvents.f_271452_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pipeBlockEntity.m_5995_();
                    isSuccesfulTool = true;
                } else if (stack.m_150930_(CompatRegistry.BUBBLE_BLOWER.get()) || stack.m_150930_(CompatRegistry.SOAP.get())) {
                    if (hit.m_82434_() == Direction.NORTH && pipeBlockEntity.hasTextNorth()) {
                        pipeBlockEntity.setTextNorth(Boolean.FALSE);
                        world.m_5594_(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sudParticles(world, pos, Direction.NORTH);
                        pipeBlockEntity.m_5995_();
                        isSuccesfulTool = true;
                    } else if (hit.m_82434_() == Direction.SOUTH && pipeBlockEntity.hasTextSouth()) {
                        pipeBlockEntity.setTextSouth(Boolean.FALSE);
                        world.m_5594_(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sudParticles(world, pos, Direction.SOUTH);
                        pipeBlockEntity.m_5995_();
                        isSuccesfulTool = true;
                    } else if (hit.m_82434_() == Direction.EAST && pipeBlockEntity.hasTextEast()) {
                        pipeBlockEntity.setTextEast(Boolean.FALSE);
                        world.m_5594_(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sudParticles(world, pos, Direction.EAST);
                        pipeBlockEntity.m_5995_();
                        isSuccesfulTool = true;
                    } else if (hit.m_82434_() == Direction.WEST && pipeBlockEntity.hasTextWest()) {
                        pipeBlockEntity.setTextWest(Boolean.FALSE);
                        world.m_5594_(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sudParticles(world, pos, Direction.WEST);
                        pipeBlockEntity.m_5995_();
                        isSuccesfulTool = true;
                    } else if (hit.m_82434_() == Direction.UP && pipeBlockEntity.hasTextAbove()) {
                        pipeBlockEntity.setTextAbove(Boolean.FALSE);
                        world.m_5594_(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sudParticles(world, pos, Direction.UP);
                        pipeBlockEntity.m_5995_();
                        isSuccesfulTool = true;
                    } else if (hit.m_82434_() == Direction.DOWN && pipeBlockEntity.hasTextBelow()) {
                        pipeBlockEntity.setTextBelow(Boolean.FALSE);
                        world.m_5594_(player, pos, CompatRegistry.BUBBLE_BLOWER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sudParticles(world, pos, Direction.DOWN);
                        pipeBlockEntity.m_5995_();
                        isSuccesfulTool = true;
                    }
                } else if (item instanceof DyeItem && pipeBlockEntity.updateText(arg_0 -> WarpPipeBlock.lambda$use$3(dyeItem = (DyeItem)item, arg_0))) {
                    int textColor = dyeItem.m_41089_().m_41071_();
                    float red = (float)(textColor >> 16 & 0xFF) / 255.0f;
                    float green = (float)(textColor >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(textColor & 0xFF) / 255.0f;
                    Vector3f colorVec = new Vector3f(red, green, blue);
                    world.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ParticleUtils.m_216313_((Level)world, (BlockPos)pos, (ParticleOptions)new DustParticleOptions(colorVec, 1.0f), (IntProvider)UniformInt.m_146622_((int)8, (int)12));
                    pipeBlockEntity.m_5995_();
                    isSuccesful = true;
                }
            } else if (((Boolean)Config.ALLOW_PIPE_UNWAXING.get()).booleanValue() && (stack.m_204117_(ItemTags.f_271207_) || item instanceof AxeItem)) {
                pipeBlockEntity.setWaxed(Boolean.FALSE);
                world.m_5594_(null, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_175829_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                pipeBlockEntity.m_5995_();
                isSuccesfulTool = true;
            }
            if (isSuccesfulTool) {
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (isSuccesful) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                pipeBlockEntity.setCustomName(stack.m_41786_());
                pipeBlockEntity.m_6596_();
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        Direction direction = placeContext.m_43719_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(placeContext.m_43725_().m_276867_(placeContext.m_8083_())));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos posNeighbor, boolean b) {
        boolean isPowered;
        boolean isClosed = (Boolean)state.m_61143_((Property)CLOSED);
        boolean bl = isPowered = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        if (isClosed != isPowered) {
            if (isClosed) {
                world.m_186460_(pos, (Block)this, 4);
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)CLOSED), 2);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)CLOSED), 2);
            }
            if (isClosed) {
                this.playSound(world, pos, (SoundEvent)SoundRegistry.PIPE_CLOSES.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            } else {
                this.playSound(world, pos, (SoundEvent)SoundRegistry.PIPE_OPENS.get(), SoundSource.BLOCKS, 1.0f, 0.15f);
            }
        }
        super.m_6861_(state, world, pos, block, posNeighbor, b);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos pos2) {
        boolean facingWest;
        Block blockAbove = worldAccessor.m_8055_(pos.m_7494_()).m_60734_();
        Block blockBelow = worldAccessor.m_8055_(pos.m_7495_()).m_60734_();
        Block blockNorth = worldAccessor.m_8055_(pos.m_122012_()).m_60734_();
        Block blockSouth = worldAccessor.m_8055_(pos.m_122019_()).m_60734_();
        Block blockEast = worldAccessor.m_8055_(pos.m_122029_()).m_60734_();
        Block blockWest = worldAccessor.m_8055_(pos.m_122024_()).m_60734_();
        boolean facingUp = state.m_61143_((Property)f_52588_) == Direction.UP;
        boolean facingDown = state.m_61143_((Property)f_52588_) == Direction.DOWN;
        boolean facingNorth = state.m_61143_((Property)f_52588_) == Direction.NORTH;
        boolean facingSouth = state.m_61143_((Property)f_52588_) == Direction.SOUTH;
        boolean facingEast = state.m_61143_((Property)f_52588_) == Direction.EAST;
        boolean bl = facingWest = state.m_61143_((Property)f_52588_) == Direction.WEST;
        if (facingUp) {
            if (blockAbove == this) {
                return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
            }
            return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE);
        }
        if (facingDown) {
            if (blockBelow == this) {
                return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
            }
            return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE);
        }
        if (facingNorth) {
            if (blockNorth == this) {
                return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
            }
            return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE);
        }
        if (facingSouth) {
            if (blockSouth == this) {
                return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
            }
            return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE);
        }
        if (facingEast) {
            if (blockEast == this) {
                return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
            }
            return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE);
        }
        if (facingWest) {
            if (blockWest == this) {
                return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
            }
            return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE);
        }
        return (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE);
    }

    public void m_213897_(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)serverWorld.m_7702_(pos);
        if (!serverWorld.f_46443_ && pipeBlockEntity != null && pipeBlockEntity.getUuid() == null) {
            UUID uuid = UUID.randomUUID();
            pipeBlockEntity.setUuid(uuid);
            pipeBlockEntity.m_6596_();
        }
        if (((Boolean)state.m_61143_((Property)WATER_SPOUT)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.UP && pipeBlockEntity != null && serverWorld.m_46472_() != Level.f_46429_) {
            WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos.m_7494_(), state, pipeBlockEntity.spoutHeight);
            serverWorld.m_186460_(pos, (Block)this, 3);
        }
        if (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.UP && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos.m_7494_(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.m_186460_(pos, (Block)this, 3);
        } else if (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.DOWN && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnDown((LevelAccessor)serverWorld, pos.m_7495_(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.m_186460_(pos, (Block)this, 3);
        } else if (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.NORTH && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnNorth((LevelAccessor)serverWorld, pos.m_122012_(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.m_186460_(pos, (Block)this, 3);
        } else if (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.SOUTH && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnSouth((LevelAccessor)serverWorld, pos.m_122019_(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.m_186460_(pos, (Block)this, 3);
        } else if (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.EAST && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnEast((LevelAccessor)serverWorld, pos.m_122029_(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.m_186460_(pos, (Block)this, 3);
        } else if (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() && state.m_61143_((Property)f_52588_) == Direction.WEST && pipeBlockEntity != null) {
            PipeBubblesBlock.repeatColumnWest((LevelAccessor)serverWorld, pos.m_122024_(), state, pipeBlockEntity.bubblesDistance);
            serverWorld.m_186460_(pos, (Block)this, 3);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState neighborState, boolean b) {
        Block blockAbove = world.m_8055_(pos.m_7494_()).m_60734_();
        Block blockBelow = world.m_8055_(pos.m_7495_()).m_60734_();
        Block blockNorth = world.m_8055_(pos.m_122012_()).m_60734_();
        Block blockSouth = world.m_8055_(pos.m_122019_()).m_60734_();
        Block blockEast = world.m_8055_(pos.m_122029_()).m_60734_();
        Block blockWest = world.m_8055_(pos.m_122024_()).m_60734_();
        BlockEntity blockEntity = world.m_7702_(pos);
        BlockPos destinationPos = null;
        if (!((Boolean)state.m_61143_((Property)CLOSED)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity warpPipeBE = (WarpPipeBlockEntity)blockEntity;
            destinationPos = warpPipeBE.destinationPos;
            world.m_186460_(pos, (Block)this, 3);
        }
        if (!world.f_46443_ && blockEntity instanceof WarpPipeBlockEntity) {
            WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
            UUID uuid = UUID.randomUUID();
            pipeBlockEntity.setPreventWarp(Boolean.FALSE);
            pipeBlockEntity.setUuid(uuid);
            pipeBlockEntity.m_6596_();
        }
        if (state.m_61143_((Property)f_52588_) == Direction.UP) {
            if (blockAbove == this) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
        }
        if (state.m_61143_((Property)f_52588_) == Direction.DOWN) {
            if (blockBelow == this) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
        }
        if (state.m_61143_((Property)f_52588_) == Direction.NORTH) {
            if (blockNorth == this) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
        }
        if (state.m_61143_((Property)f_52588_) == Direction.SOUTH) {
            if (blockSouth == this) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
        }
        if (state.m_61143_((Property)f_52588_) == Direction.EAST) {
            if (blockEast == this) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
        }
        if (state.m_61143_((Property)f_52588_) == Direction.WEST) {
            if (blockWest == this) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.FALSE), 3);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENTRANCE, (Comparable)Boolean.TRUE), 3);
            }
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity warpPipeBE;
        BlockEntity blockEntity = world.m_7702_(pos);
        double dx = pos.m_123341_();
        double dy = pos.m_123342_();
        double dz = pos.m_123343_();
        Fluid fluidAbove = world.m_6425_(pos.m_7494_()).m_76152_();
        Fluid fluidBelow = world.m_6425_(pos.m_7495_()).m_76152_();
        Fluid fluidNorth = world.m_6425_(pos.m_122012_()).m_76152_();
        Fluid fluidSouth = world.m_6425_(pos.m_122019_()).m_76152_();
        Fluid fluidEast = world.m_6425_(pos.m_122029_()).m_76152_();
        Fluid fluidWest = world.m_6425_(pos.m_122024_()).m_76152_();
        Block blockAbove = world.m_8055_(pos.m_7494_()).m_60734_();
        Block blockBelow = world.m_8055_(pos.m_7495_()).m_60734_();
        Block blockNorth = world.m_8055_(pos.m_122012_()).m_60734_();
        Block blockSouth = world.m_8055_(pos.m_122019_()).m_60734_();
        Block blockEast = world.m_8055_(pos.m_122029_()).m_60734_();
        Block blockWest = world.m_8055_(pos.m_122024_()).m_60734_();
        if (!((Boolean)state.m_61143_((Property)CLOSED)).booleanValue() && (((Boolean)state.m_61143_((Property)BUBBLES)).booleanValue() || ((Boolean)state.m_61143_((Property)WATER_SPOUT)).booleanValue()) && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue() && blockEntity instanceof WarpPipeBlockEntity && (warpPipeBE = (WarpPipeBlockEntity)blockEntity).getPersistentData().m_128456_()) {
            if (state.m_61143_((Property)f_52588_) == Direction.UP) {
                if (fluidAbove instanceof LavaFluid) {
                    if (random.m_188503_(10) == 0) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, dx + 0.5, dy + 1.0, dz + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (fluidAbove instanceof WaterFluid || blockAbove instanceof PipeBubblesBlock) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123774_, dx + 0.5, dy + 1.15, dz + 0.5, 0.0, 0.4, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123774_, dx + (double)random.m_188501_(), dy + (double)random.m_188501_() + 1.15, dz + (double)random.m_188501_(), 0.0, 0.4, 0.0);
                }
            }
            if (state.m_61143_((Property)f_52588_) == Direction.DOWN) {
                if (fluidBelow instanceof LavaFluid) {
                    if (random.m_188503_(10) == 0) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, dx + 0.5, dy - 0.5, dz + 0.05, 0.0, 0.0, 0.0);
                    }
                } else if (fluidBelow instanceof WaterFluid || blockBelow instanceof PipeBubblesBlock) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + 0.5, dy - 1.15, dz + 0.5, 0.0, -0.4, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + (double)random.m_188501_(), dy - (double)random.m_188501_() - 1.15, dz + (double)random.m_188501_(), 0.0, -0.4, 0.0);
                }
            }
            if (state.m_61143_((Property)f_52588_) == Direction.NORTH) {
                if (fluidNorth instanceof LavaFluid) {
                    if (random.m_188503_(10) == 0) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, dx + 0.5, dy + 0.5, dz - 0.05, 0.0, 0.0, 0.0);
                    }
                } else if (fluidNorth instanceof WaterFluid || blockNorth instanceof PipeBubblesBlock) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + 0.5, dy + 0.5, dz - 1.15, 0.0, 0.4, -1.5);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + (double)random.m_188501_(), dy + (double)random.m_188501_(), dz + (double)random.m_188501_() - 1.15, 0.0, 0.4, -1.5);
                }
            }
            if (state.m_61143_((Property)f_52588_) == Direction.SOUTH) {
                if (fluidSouth instanceof LavaFluid) {
                    if (random.m_188503_(10) == 0) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, dx + 0.5, dy + 0.5, dz + 1.05, 0.0, 0.0, 0.0);
                    }
                } else if (fluidSouth instanceof WaterFluid || blockSouth instanceof PipeBubblesBlock) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + 0.5, dy + 0.5, dz + 1.15, 0.0, 0.4, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + (double)random.m_188501_(), dy + (double)random.m_188501_(), dz + (double)random.m_188501_() + 1.15, 0.0, 0.4, 0.0);
                }
            }
            if (state.m_61143_((Property)f_52588_) == Direction.EAST) {
                if (fluidEast instanceof LavaFluid) {
                    if (random.m_188503_(10) == 0) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, dx + 1.05, dy + 0.5, dz + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (fluidEast instanceof WaterFluid || blockEast instanceof PipeBubblesBlock) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + 1.15, dy + 0.5, dz + 0.5, 0.0, 0.4, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + (double)random.m_188501_() + 1.15, dy + (double)random.m_188501_(), dz + (double)random.m_188501_(), 0.0, 0.4, 0.0);
                }
            }
            if (state.m_61143_((Property)f_52588_) == Direction.WEST) {
                if (fluidWest instanceof LavaFluid) {
                    if (random.m_188503_(10) == 0) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, dx - 0.05, dy + 0.5, dz + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (fluidWest instanceof WaterFluid || blockWest instanceof PipeBubblesBlock) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx - 1.15, dy + 0.5, dz + 0.5, 0.0, 0.4, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, dx + (double)random.m_188501_() - 1.15, dy + (double)random.m_188501_(), dz + (double)random.m_188501_(), 0.0, 0.4, 0.0);
                }
            }
        }
        super.m_214162_(state, world, pos, random);
    }

    public void playSound(Level world, BlockPos pos, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        world.m_5594_(null, pos, soundEvent, source, volume, pitch);
    }

    public static void markEntityTeleported(Entity entity) {
        if (entity != null) {
            teleportedEntities.put(entity.m_19879_(), true);
        }
    }

    public static void warp(Entity entity, BlockPos warpPos, Level world, BlockState state) {
        if (world.m_8055_(warpPos).m_60734_() instanceof WarpPipeBlock && !((Boolean)state.m_61143_((Property)CLOSED)).booleanValue()) {
            LivingEntity passengerEntity = entity.m_6688_();
            if (state.m_60734_() instanceof ClearWarpPipeBlock && !((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_() - 1.0, (double)warpPos.m_123343_() + 0.5);
                } else {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_() - 1.0, (double)warpPos.m_123343_() + 0.5);
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            if (world.m_8055_(warpPos).m_61143_((Property)f_52588_) == Direction.UP && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_() + 1.0, (double)warpPos.m_123343_() + 0.5);
                } else {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_() + 1.0, (double)warpPos.m_123343_() + 0.5);
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            if (world.m_8055_(warpPos).m_61143_((Property)f_52588_) == Direction.DOWN && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)((float)warpPos.m_123342_() - entity.m_20206_()), (double)warpPos.m_123343_() + 0.5);
                } else {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)((float)warpPos.m_123342_() - entity.m_20206_()), (double)warpPos.m_123343_() + 0.5);
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            if (world.m_8055_(warpPos).m_61143_((Property)f_52588_) == Direction.NORTH && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_(), (double)((float)warpPos.m_123343_() - entity.m_20205_()));
                } else {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_(), (double)((float)warpPos.m_123343_() - entity.m_20205_()));
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            if (world.m_8055_(warpPos).m_61143_((Property)f_52588_) == Direction.SOUTH && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_(), (double)((float)warpPos.m_123343_() + entity.m_20205_()) + 1.0);
                } else {
                    entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_(), (double)((float)warpPos.m_123343_() + entity.m_20205_()) + 1.0);
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            if (world.m_8055_(warpPos).m_61143_((Property)f_52588_) == Direction.EAST && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)((float)warpPos.m_123341_() + entity.m_20205_()) + 1.0, (double)warpPos.m_123342_(), (double)warpPos.m_123343_() + 0.5);
                } else {
                    entity.m_6021_((double)((float)warpPos.m_123341_() + entity.m_20205_()) + 1.0, (double)warpPos.m_123342_(), (double)warpPos.m_123343_() + 0.5);
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            if (world.m_8055_(warpPos).m_61143_((Property)f_52588_) == Direction.WEST && ((Boolean)state.m_61143_((Property)ENTRANCE)).booleanValue()) {
                if (entity instanceof Player) {
                    entity.m_6021_((double)((float)warpPos.m_123341_() - entity.m_20205_()), (double)warpPos.m_123342_(), (double)warpPos.m_123343_() + 0.5);
                } else {
                    entity.m_6021_((double)((float)warpPos.m_123341_() - entity.m_20205_()), (double)warpPos.m_123342_(), (double)warpPos.m_123343_() + 0.5);
                    if (passengerEntity instanceof Player) {
                        entity.m_19877_();
                    }
                }
            }
            WarpPipeBlock.markEntityTeleported(entity);
        }
        world.m_220407_(GameEvent.f_238175_, warpPos, GameEvent.Context.m_223717_((Entity)entity));
        world.m_5594_(null, warpPos, (SoundEvent)SoundRegistry.PIPE_WARPS.get(), SoundSource.BLOCKS, 1.0f, 0.1f);
    }

    public static BlockPos findMatchingUUID(UUID uuid, Level world, BlockPos pos) {
        BlockPos closestPos = null;
        double closestDistanceSq = Double.MAX_VALUE;
        int maxDistance = 64;
        for (int x = -maxDistance; x <= maxDistance; ++x) {
            for (int y = Math.max(-maxDistance, world.m_141937_() - pos.m_123342_()); y <= Math.min(maxDistance, world.m_151558_() - pos.m_123342_()); ++y) {
                for (int z = -maxDistance; z <= maxDistance; ++z) {
                    double distanceSq;
                    WarpPipeBlockEntity pipeTileEntity;
                    UUID warpUUID;
                    BlockEntity blockEntity;
                    BlockPos checkingPos = pos.m_7918_(x, y, z);
                    BlockState blockState = world.m_8055_(checkingPos);
                    Block block = blockState.m_60734_();
                    if (!(block instanceof WarpPipeBlock) || !((blockEntity = world.m_7702_(checkingPos)) instanceof WarpPipeBlockEntity) || !uuid.equals(warpUUID = (pipeTileEntity = (WarpPipeBlockEntity)blockEntity).getWarpUuid()) || !((distanceSq = pos.m_203198_((double)checkingPos.m_123341_(), (double)checkingPos.m_123342_(), (double)checkingPos.m_123343_())) < closestDistanceSq)) continue;
                    closestPos = checkingPos.m_7949_();
                    closestDistanceSq = distanceSq;
                }
            }
        }
        return closestPos;
    }

    public void dyedDustParticles(WarpPipeBlockEntity pipeBlockEntity, Level world, BlockPos pos, Direction direction) {
        RandomSource random = world.m_213780_();
        int textColor = pipeBlockEntity.getPipeText().getColor().m_41071_();
        float red = (float)(textColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(textColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(textColor & 0xFF) / 255.0f;
        Vector3f colorVec = new Vector3f(red, green, blue);
        ParticleUtils.m_216318_((Level)world, (BlockPos)pos, (ParticleOptions)new DustParticleOptions(colorVec, 0.5f), (IntProvider)UniformInt.m_146622_((int)8, (int)12), (Direction)direction, () -> new Vec3(Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f)), (double)0.55);
    }

    public void coloredDustParticles(Level world, BlockPos pos, Vector3f colorVec, UniformInt amount) {
        ParticleUtils.m_216313_((Level)world, (BlockPos)pos, (ParticleOptions)new DustParticleOptions(colorVec, 0.5f), (IntProvider)amount);
    }

    public void sudParticles(Level world, BlockPos pos, Direction direction) {
        RandomSource random = world.m_213780_();
        ParticleUtils.m_216318_((Level)world, (BlockPos)pos, (ParticleOptions)((ParticleOptions)CompatRegistry.SUDS_PARTICLE.get()), (IntProvider)UniformInt.m_146622_((int)5, (int)8), (Direction)direction, () -> new Vec3(Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.m_216263_((RandomSource)random, (double)-0.005f, (double)0.005f)), (double)0.55);
    }

    public static void spawnParticlesOnBlockFaces(Level world, BlockPos pos, ParticleOptions particles, Vec3 speedRange, IntProvider amountRange) {
        for (Direction direction : Direction.values()) {
            ParticleUtils.m_216318_((Level)world, (BlockPos)pos, (ParticleOptions)particles, (IntProvider)amountRange, (Direction)direction, () -> speedRange, (double)0.55);
        }
    }

    private static /* synthetic */ PipeText lambda$use$3(DyeItem dyeItem, PipeText pipeText) {
        return pipeText.setColor(dyeItem.m_41089_());
    }
}

