/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.init.Config;
import com.wenxin2.warp_pipes.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBubblesBlock
extends BubbleColumnBlock
implements BucketPickup {
    public static final BooleanProperty DRAG_DOWN = BlockStateProperties.f_61430_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public PipeBubblesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)DRAG_DOWN, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{DRAG_DOWN, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Player player;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)context).m_193113_()) instanceof Player && (player = (Player)entity).m_20310_(1) && player.m_7500_() && ((Boolean)Config.DEBUG_PIPE_BUBBLES_SELECTION_BOX.get()).booleanValue()) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83048_((double)8.0, (double)8.0, (double)8.0, (double)8.00001, (double)8.00001, (double)8.00001);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        BlockState stateAbove = worldAccessor.m_8055_(pos.m_7494_());
        BlockState stateBelow = worldAccessor.m_8055_(pos.m_7495_());
        BlockState stateNorth = worldAccessor.m_8055_(pos.m_122012_());
        BlockState stateSouth = worldAccessor.m_8055_(pos.m_122019_());
        BlockState stateEast = worldAccessor.m_8055_(pos.m_122029_());
        BlockState stateWest = worldAccessor.m_8055_(pos.m_122024_());
        if (stateBelow.m_60734_() instanceof WarpPipeBlock && ((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.UP && stateBelow.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateBelow.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.DOWN && stateAbove.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateAbove.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.NORTH && stateSouth.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateSouth.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.SOUTH && stateNorth.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateNorth.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.EAST && stateWest.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateWest.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.WEST && stateEast.m_60734_() instanceof ClearWarpPipeBlock && (((Boolean)stateEast.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateEast.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateEast.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue())) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.UP && (!(stateBelow.m_60734_() instanceof WarpPipeBlock) && !(stateBelow.m_60734_() instanceof PipeBubblesBlock) || stateBelow.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.DOWN && (!(stateAbove.m_60734_() instanceof WarpPipeBlock) && !(stateAbove.m_60734_() instanceof PipeBubblesBlock) || stateAbove.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.NORTH && (!(stateSouth.m_60734_() instanceof WarpPipeBlock) && !(stateSouth.m_60734_() instanceof PipeBubblesBlock) || stateSouth.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.SOUTH && (!(stateNorth.m_60734_() instanceof WarpPipeBlock) && !(stateNorth.m_60734_() instanceof PipeBubblesBlock) || stateNorth.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.EAST && (!(stateWest.m_60734_() instanceof WarpPipeBlock) && !(stateWest.m_60734_() instanceof PipeBubblesBlock) || stateWest.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (state.m_61143_((Property)FACING) == Direction.WEST && (!(stateEast.m_60734_() instanceof WarpPipeBlock) && !(stateEast.m_60734_() instanceof PipeBubblesBlock) || stateEast.m_60734_() instanceof WarpPipeBlock && (((Boolean)stateEast.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() || !((Boolean)stateEast.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()))) {
            worldAccessor.m_46961_(pos, true);
            return Blocks.f_49990_.m_49966_();
        }
        if (!state.m_60710_((LevelReader)worldAccessor, pos) && !neighborState.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get()) && PipeBubblesBlock.m_152715_((BlockState)neighborState)) {
            worldAccessor.m_186460_(pos, (Block)this, 3);
        }
        worldAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldAccessor));
        return super.m_7417_(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockState stateAbove = worldReader.m_8055_(pos.m_7494_());
        BlockState stateBelow = worldReader.m_8055_(pos.m_7495_());
        BlockState stateNorth = worldReader.m_8055_(pos.m_7495_());
        BlockState stateSouth = worldReader.m_8055_(pos.m_7495_());
        BlockState stateEast = worldReader.m_8055_(pos.m_7495_());
        BlockState stateWest = worldReader.m_8055_(pos.m_7495_());
        if (state.m_61143_((Property)FACING) == Direction.UP && stateBelow.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.DOWN && stateAbove.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.NORTH && stateSouth.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.SOUTH && stateNorth.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.EAST && stateWest.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.WEST && stateEast.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.UP && stateBelow.m_60734_() instanceof WarpPipeBlock && !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateBelow.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.DOWN && stateAbove.m_60734_() instanceof WarpPipeBlock && !((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateAbove.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.NORTH && stateSouth.m_60734_() instanceof WarpPipeBlock && !((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateSouth.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.SOUTH && stateNorth.m_60734_() instanceof WarpPipeBlock && !((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateNorth.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.EAST && stateWest.m_60734_() instanceof WarpPipeBlock && !((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateWest.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.WEST && stateEast.m_60734_() instanceof WarpPipeBlock && !((Boolean)stateEast.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateEast.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && !(stateEast.m_60734_() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.UP && stateBelow.m_60734_() instanceof ClearWarpPipeBlock && !((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateBelow.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateBelow.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.DOWN && stateAbove.m_60734_() instanceof ClearWarpPipeBlock && !((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateAbove.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateAbove.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.NORTH && stateSouth.m_60734_() instanceof ClearWarpPipeBlock && !((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateSouth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateSouth.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.SOUTH && stateNorth.m_60734_() instanceof ClearWarpPipeBlock && !((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateNorth.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateNorth.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        if (state.m_61143_((Property)FACING) == Direction.EAST && stateWest.m_60734_() instanceof ClearWarpPipeBlock && !((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateWest.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue() && ((Boolean)stateWest.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
            return true;
        }
        return state.m_61143_((Property)FACING) == Direction.WEST && stateEast.m_60734_() instanceof ClearWarpPipeBlock && (Boolean)stateEast.m_61143_((Property)WarpPipeBlock.CLOSED) == false && (Boolean)stateEast.m_61143_((Property)WarpPipeBlock.BUBBLES) != false && (Boolean)stateEast.m_61143_((Property)ClearWarpPipeBlock.WATERLOGGED) != false;
    }

    public static boolean canExistIn(LevelAccessor worldAccessor, BlockPos pos) {
        return worldAccessor.m_8055_(pos).m_60713_((Block)ModRegistry.PIPE_BUBBLES.get()) || worldAccessor.m_8055_(pos).m_60713_(Blocks.f_49990_) && worldAccessor.m_8055_(pos).m_60819_().m_76170_();
    }

    public static BlockState setBlockState(BlockState state, LevelAccessor worldAccessor, BlockPos pos) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            posMutable.m_122159_((Vec3i)pos, direction);
        }
        if (state.m_60713_((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return state;
        }
        if (state.m_60734_() instanceof WarpPipeBlock && !((Boolean)state.m_61143_((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)state.m_61143_((Property)WarpPipeBlock.BUBBLES)).booleanValue()) {
            return (BlockState)((BlockState)((Block)ModRegistry.PIPE_BUBBLES.get()).m_49966_().m_61124_((Property)DRAG_DOWN, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
        }
        return Blocks.f_49990_.m_49966_();
    }

    public void addParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, int amt, double xMotion, double yMotion, double zMotion, double speed) {
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_(particleOptions, xPos, yPos, zPos, amt, xMotion, yMotion, zMotion, speed);
        }
    }

    public void addAlwaysVisibleParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, double xMotion, double yMotion, double zMotion) {
        if (world.f_46443_) {
            world.m_7107_(particleOptions, xPos, yPos, zPos, xMotion, yMotion, zMotion);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        if (((Boolean)state.m_61143_((Property)DRAG_DOWN)).booleanValue() || state.m_61143_((Property)FACING) == Direction.DOWN) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123773_, x + 0.5, y + 0.8, z, 0.0, -1.0, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, -1.5, 0.0);
            if (random.m_188503_(200) == 0) {
                world.m_7785_(x, y, z, SoundEvents.f_11776_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        } else if (state.m_61143_((Property)FACING) == Direction.UP) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 0.0, 1.0, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 1.0, 0.0);
        } else if (state.m_61143_((Property)FACING) == Direction.NORTH) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 0.0, 0.04, -1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 0.0, 0.04, -1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.04, -1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.04, -1.5);
        } else if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 0.0, 0.04, 1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 0.0, 0.04, 1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.04, 1.5);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.04, 1.5);
        } else if (state.m_61143_((Property)FACING) == Direction.EAST) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 1.5, 0.04, 0.0);
        } else if (state.m_61143_((Property)FACING) == Direction.WEST) {
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, -1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, -1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), -1.5, 0.04, 0.0);
            this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), -1.5, 0.04, 0.0);
        }
        if (random.m_188503_(200) == 0) {
            world.m_7785_(x, y, z, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        if (stateAbove.m_60795_() && state.m_61143_((Property)FACING) == Direction.UP) {
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                boat.m_6845_(Boolean.FALSE.booleanValue());
            } else {
                this.onAboveUpBubbleCol((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
            }
            if (!world.f_46443_) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else if (state.m_61143_((Property)FACING) == Direction.UP) {
            this.onInsideUpBubbleColumn((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
            if (!world.f_46443_) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), pos.m_123342_() + 1, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else if (state.m_61143_((Property)FACING) == Direction.DOWN) {
            this.onInsideDownBubbleColumn((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
        } else if (state.m_61143_((Property)FACING) == Direction.NORTH) {
            this.onInsideNorthBubbleColumn((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
        } else if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
            this.onInsideSouthBubbleColumn((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
        } else if (state.m_61143_((Property)FACING) == Direction.EAST) {
            this.onInsideEastBubbleColumn((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
        } else if (state.m_61143_((Property)FACING) == Direction.WEST) {
            this.onInsideWestBubbleColumn((Boolean)state.m_61143_((Property)DRAG_DOWN), entity);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!world.f_46443_ && livingEntity.canDrownInFluidType(Fluids.f_76193_.getFluidType())) {
                int refillAmount = 1;
                int newAir = Math.min(livingEntity.m_20146_() + refillAmount, livingEntity.m_6062_());
                livingEntity.m_20301_(newAir);
            }
        }
    }

    public void onAboveUpBubbleCol(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(-0.9, vec3.f_82480_ - 0.03) : Math.min(1.8, vec3.f_82480_ + 0.1);
        entity.m_20334_(vec3.f_82479_, d0, vec3.f_82481_);
    }

    public void onInsideUpBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(-0.3, vec3.f_82480_ - 0.03) : Math.min(0.5, vec3.f_82480_ + 0.04);
        entity.m_20334_(vec3.f_82479_, d0, vec3.f_82481_);
        entity.m_183634_();
    }

    public void onInsideDownBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(0.3, vec3.f_82480_ + 0.03) : Math.min(-0.5, vec3.f_82480_ - 0.04);
        entity.m_20334_(vec3.f_82479_, d0, vec3.f_82481_);
        entity.m_183634_();
    }

    public void onInsideNorthBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(0.3, vec3.f_82481_ + 0.03) : Math.min(-0.5, vec3.f_82481_ - 0.04);
        entity.m_20334_(vec3.f_82479_, vec3.f_82480_, d0);
        entity.m_183634_();
    }

    public void onInsideSouthBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(-0.3, vec3.f_82481_ - 0.03) : Math.min(0.5, vec3.f_82481_ + 0.04);
        entity.m_20334_(vec3.f_82479_, vec3.f_82480_, d0);
        entity.m_183634_();
    }

    public void onInsideEastBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(-0.3, vec3.f_82479_ - 0.03) : Math.min(0.5, vec3.f_82479_ + 0.04);
        entity.m_20334_(d0, vec3.f_82480_, vec3.f_82481_);
        entity.m_183634_();
    }

    public void onInsideWestBubbleColumn(boolean isDragDown, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = isDragDown ? Math.max(0.3, vec3.f_82479_ + 0.03) : Math.min(-0.5, vec3.f_82479_ - 0.04);
        entity.m_20334_(d0, vec3.f_82480_, vec3.f_82481_);
        entity.m_183634_();
    }

    public void m_213897_(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)serverWorld.m_7702_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (pipeBlockEntity != null) {
            if (facing == Direction.UP) {
                PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_7495_()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.DOWN) {
                PipeBubblesBlock.repeatColumnDown((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_7494_()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.NORTH) {
                PipeBubblesBlock.repeatColumnNorth((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_122019_()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.SOUTH) {
                PipeBubblesBlock.repeatColumnSouth((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_122012_()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.EAST) {
                PipeBubblesBlock.repeatColumnEast((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_122024_()), pipeBlockEntity.bubblesDistance);
            } else if (facing == Direction.WEST) {
                PipeBubblesBlock.repeatColumnWest((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_122029_()), pipeBlockEntity.bubblesDistance);
            }
        } else {
            PipeBubblesBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.m_8055_(pos.m_7495_()), 0);
        }
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnUp(worldAccessor, pos, worldAccessor.m_8055_(pos), state, bubblesDistance);
    }

    public static void repeatColumnDown(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnDown(worldAccessor, pos, worldAccessor.m_8055_(pos), state, bubblesDistance);
    }

    public static void repeatColumnNorth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnNorth(worldAccessor, pos, worldAccessor.m_8055_(pos), state, bubblesDistance);
    }

    public static void repeatColumnSouth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnSouth(worldAccessor, pos, worldAccessor.m_8055_(pos), state, bubblesDistance);
    }

    public static void repeatColumnEast(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnEast(worldAccessor, pos, worldAccessor.m_8055_(pos), state, bubblesDistance);
    }

    public static void repeatColumnWest(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int bubblesDistance) {
        PipeBubblesBlock.repeatColumnWest(worldAccessor, pos, worldAccessor.m_8055_(pos), state, bubblesDistance);
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.m_152715_((BlockState)state) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.UP);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.m_7731_(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.UP);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnDown(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.m_152715_((BlockState)state) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.DOWN);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.m_7731_(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.DOWN);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnNorth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.m_152715_((BlockState)state) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.NORTH);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.m_7731_(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.NORTH);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnSouth(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.m_152715_((BlockState)state) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.SOUTH);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.m_7731_(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.SOUTH);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnEast(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.m_152715_((BlockState)state) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.EAST);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.m_7731_(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.EAST);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public static void repeatColumnWest(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int bubblesDistance) {
        if (PipeBubblesBlock.m_152715_((BlockState)state) && bubblesDistance != 0) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(Direction.WEST);
            BlockState pipeColumnState = PipeBubblesBlock.setBlockState(neighborState, worldAccessor, pos);
            worldAccessor.m_7731_(pos, pipeColumnState, 2);
            for (int initialDistance = 0; PipeBubblesBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < bubblesDistance - 1; ++initialDistance) {
                if (!worldAccessor.m_7731_((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.m_122173_(Direction.WEST);
                pipeColumnState = PipeBubblesBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }
}

