/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.util;

import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MathUtils {
    public static VoxelShape getShapefromAngle(double x1, double y1, double z1, double x2, double y2, double z2, float angle) {
        Point p1 = Point.fromMCBlockBoxtoMathCenter(new Point(x1, y1, z1));
        Point p2 = Point.fromMCBlockBoxtoMathCenter(new Point(x2, y2, z2));
        p1 = Point.rotatePoint(p1, angle);
        p2 = Point.rotatePoint(p2, angle);
        p1 = Point.fromMathCentertoMCBlock(p1);
        p2 = Point.fromMathCentertoMCBlock(p2);
        double xmin = Math.min(p1.x, p2.x);
        double xmax = Math.max(p1.x, p2.x);
        double ymin = Math.min(p1.y, p2.y);
        double ymax = Math.max(p1.y, p2.y);
        double zmin = Math.min(p1.z, p2.z);
        double zmax = Math.max(p1.z, p2.z);
        return Block.m_49796_((double)xmin, (double)ymin, (double)zmin, (double)xmax, (double)ymax, (double)zmax);
    }

    public static VoxelShape getShapefromDirection(double x1, double y1, double z1, double x2, double y2, double z2, Direction direction, boolean useAngle) {
        switch (direction) {
            case EAST: {
                return MathUtils.getShapefromAngle(x1, y1, z1, x2, y2, z2, 270.0f);
            }
            case SOUTH: {
                return MathUtils.getShapefromAngle(x1, y1, z1, x2, y2, z2, 180.0f);
            }
            case WEST: {
                return MathUtils.getShapefromAngle(x1, y1, z1, x2, y2, z2, 90.0f);
            }
        }
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape getShapefromAngle(VoxelShape v1, int angle) {
        return MathUtils.getShapefromAngle(v1.m_83288_(Direction.Axis.X) * 16.0, v1.m_83288_(Direction.Axis.Y) * 16.0, v1.m_83288_(Direction.Axis.Z) * 16.0, v1.m_83297_(Direction.Axis.X) * 16.0, v1.m_83297_(Direction.Axis.Y) * 16.0, v1.m_83297_(Direction.Axis.Z) * 16.0, angle);
    }

    public static int getRandomSpread(Random r) {
        int select = r.nextInt(3) - 1;
        return select;
    }

    public static BlockPos getRandomSpreadPos(BlockPos pos, Random r) {
        int xOffset = MathUtils.getRandomSpread(r);
        int yOffset = MathUtils.getRandomSpread(r);
        int zOffset = MathUtils.getRandomSpread(r);
        return pos.m_7918_(xOffset, yOffset, zOffset);
    }

    public static class Point {
        public final double x;
        public final double y;
        public final double z;

        public Point(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Point(Vec3 vec3) {
            this.x = vec3.m_7096_();
            this.y = vec3.m_7098_();
            this.z = vec3.m_7094_();
        }

        public static Point[] fromVoxelShape(VoxelShape oldShape) {
            Point[] points = new Point[2];
            double x = Point.fromMCVoxelShapetoMathCenter(oldShape.m_83288_(Direction.Axis.X));
            double y = oldShape.m_83288_(Direction.Axis.Y) * 16.0;
            double z = Point.fromMCVoxelShapetoMathCenter(oldShape.m_83288_(Direction.Axis.Z));
            points[0] = new Point(x, y, z);
            x = Point.fromMCVoxelShapetoMathCenter(oldShape.m_83297_(Direction.Axis.X));
            y = oldShape.m_83297_(Direction.Axis.Y) * 16.0;
            z = Point.fromMCVoxelShapetoMathCenter(oldShape.m_83297_(Direction.Axis.Z));
            points[1] = new Point(x, y, z);
            return points;
        }

        public static Point rotatePoint(Point p, float angle) {
            float radians_angle = (float)CMath.toRadians(angle);
            double x0 = p.x * CMath.cos(radians_angle, angle) + p.z * CMath.sin(radians_angle, angle);
            double z0 = -p.x * CMath.sin(radians_angle, angle) + p.z * CMath.cos(radians_angle, angle);
            return new Point(x0, p.y, z0);
        }

        public static double fromMCVoxelShapetoMathCenter(double value) {
            value = value * 16.0 - 8.0;
            return value;
        }

        public static Point fromMathCentertoMCBlock(Point p) {
            return new Point(p.x + 8.0, p.y, p.z + 8.0);
        }

        public static Point fromMCBlockBoxtoMathCenter(Point p) {
            return new Point(p.x - 8.0, p.y, p.z - 8.0);
        }
    }

    private static class CMath {
        public static final Map<Integer, Integer> COS_ANGLE_MAP = Map.of(0, 1, 90, 0, 180, -1, 270, 0, -90, 0);

        private CMath() {
        }

        public static double toRadians(float angle) {
            return Math.toRadians(angle);
        }

        public static double cos(float angle_r, float angle0) {
            int temp = (int)angle0;
            if (COS_ANGLE_MAP.containsKey(temp)) {
                return COS_ANGLE_MAP.get(temp).intValue();
            }
            return Math.cos(angle_r);
        }

        public static double sin(float angle_r, float angle0) {
            int temp = (int)angle0 - 90;
            if (COS_ANGLE_MAP.containsKey(temp)) {
                return COS_ANGLE_MAP.get(temp).intValue();
            }
            return Math.sin(angle_r);
        }
    }
}

