/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.handler;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xueluoanping.fluiddrawerslegacy.ModConstants;
import xueluoanping.fluiddrawerslegacy.api.exchange.FluidExchangeHandlerManager;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.capability.CapabilityProvider_FluidControllerProxy;
import xueluoanping.fluiddrawerslegacy.capability.CapabilityProvider_FluidDrawerController;
import xueluoanping.fluiddrawerslegacy.handler.FluidUtilPatch;

public class ControllerFluidCapabilityHandler {
    public static final ControllerFluidCapabilityHandler instance = new ControllerFluidCapabilityHandler();
    private static final ResourceLocation CAP_FLUID_CTRL = new ResourceLocation("fluiddrawerslegacy", "fluid_ctrl");
    private static final ResourceLocation CAP_FLUID_PROXY = new ResourceLocation("fluiddrawerslegacy", "fluid_proxy");

    @SubscribeEvent
    public void onTileCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity tile = (BlockEntity)event.getObject();
        if (tile instanceof BlockEntityController) {
            event.addCapability(CAP_FLUID_CTRL, (ICapabilityProvider)new CapabilityProvider_FluidDrawerController((BlockEntityController)tile));
            event.addListener(() -> {});
        } else if (tile instanceof BlockEntitySlave) {
            event.addCapability(CAP_FLUID_PROXY, (ICapabilityProvider)new CapabilityProvider_FluidControllerProxy((BlockEntitySlave)tile));
        }
    }

    @SubscribeEvent
    public void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntityController tile;
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockState state = world.m_8055_(pos);
        ItemStack stack = event.getItemStack();
        if (state.m_60734_() != ModBlocks.CONTROLLER.get() || face != state.m_61143_((Property)BlockController.f_54117_)) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityController && (tile = (BlockEntityController)blockEntity).getCapability(ForgeCapabilities.FLUID_HANDLER).resolve().isPresent()) {
            ArrayList<FluidStack> fluidStacksList = FluidExchangeHandlerManager.getFluidInItemContainer(stack);
            if (fluidStacksList.size() == 0) {
                return;
            }
            IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER).resolve().get();
            FluidStack fluidStack = FluidStack.EMPTY;
            boolean isExist = false;
            for (FluidStack stack1 : fluidStacksList) {
                if (fluidHandler.drain(stack1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                isExist = true;
                fluidStack = stack1;
                break;
            }
            if (isExist && (FluidExchangeHandlerManager.tryHandleClickInputByMod(tile, event.getEntity(), event.getHand()) || FluidUtilPatch.interactWithFluidHandlerAndEmpty(event.getEntity(), event.getHand(), fluidHandler, fluidStack))) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            tile.getCapability(ModConstants.DRAWER_GROUP_CAPABILITY, null).ifPresent(handler -> {
                if (handler.isGroupValid() && handler.getDrawerCount() > 0) {
                    for (int i = 0; i < handler.getDrawerCount(); ++i) {
                        IDrawer drawer = handler.getDrawer(i);
                        if (drawer instanceof BlockEntityFluidDrawer.FluidDrawerData) {
                            BlockEntityFluidDrawer.FluidDrawerData fluiddrawer = (BlockEntityFluidDrawer.FluidDrawerData)drawer;
                            continue;
                        }
                        if (drawer.canItemBeStored(stack) && drawer.getStoredItemPrototype().m_150930_(stack.m_41720_())) break;
                    }
                }
            });
        }
    }
}

