/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.data.blockstate;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.util.RegisterFinderUtil;

public class BlockStatesDataProvider
extends BlockStateProvider {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public BlockStatesDataProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "fluiddrawerslegacy", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryObject entry : ModContents.DREntityBlocks.getEntries()) {
            this.getVariantBuilder((Block)entry.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(BlockStatesDataProvider.resourceBlock(entry.getId().m_135815_()))).rotationY(BlockStatesDataProvider.getRotateYByFacing(state)).build(), new Property[0]);
        }
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage_";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size() - 1, ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, BlockStatesDataProvider.resourceBlock(stageName))).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(stageName, parent, textureKey, BlockStatesDataProvider.resourceBlock(stageName))).build();
        }, ignored);
    }

    private String blockName(Block block) {
        return RegisterFinderUtil.getBlockKey(block).m_135815_();
    }

    public static ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("fluiddrawerslegacy", "block/" + path);
    }

    public ResourceLocation resourceVanillaBlock(String path) {
        return new ResourceLocation("block/" + path);
    }

    public static int getRotateYByFacing(BlockState state) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return 0;
    }
}

