/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.compat.jade;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.addon.universal.FluidStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.overlay.DisplayHelper;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.api.drawer.betterFluidManager;
import xueluoanping.fluiddrawerslegacy.block.BlockFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;

public class FluidDrawerProvider
implements IBlockComponentProvider {
    public static FluidDrawerProvider INSTANCE = new FluidDrawerProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity tileEntity;
        tooltip.remove(Identifiers.UNIVERSAL_FLUID_STORAGE);
        tooltip.remove(Identifiers.UNIVERSAL_FLUID_STORAGE_DETAILED);
        if (accessor.getBlock() instanceof BlockFluidDrawer && (tileEntity = accessor.getLevel().m_7702_(accessor.getPosition())) instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            tile.getCapability(ForgeCapabilities.FLUID_HANDLER, null).ifPresent(handler -> {
                int capacity = tile.getCapacityTankEffective();
                boolean isLocked = tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY);
                if (handler instanceof betterFluidManager) {
                    betterFluidManager h = (betterFluidManager)handler;
                    for (BlockEntityFluidDrawer.FluidDrawerData data : h.getFluidDrawerDataList()) {
                        BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = data.getTank();
                        FluidStack fluidStack = betterFluidHandler2.getFluid().copy();
                        FluidStack cache = betterFluidHandler2.getCacheFluid();
                        FluidDrawerProvider.appendTank(tooltip, accessor, fluidStack, capacity, cache, isLocked);
                    }
                }
            });
        }
    }

    public static void appendTank(ITooltip tooltip, BlockAccessor accessor, FluidStack fluidStack, int capacity, FluidStack cacheFluid, boolean isLocked) {
        if (capacity > 0) {
            MutableComponent text;
            IElementHelper helper = tooltip.getElementHelper();
            if (fluidStack.isEmpty()) {
                text = Component.m_237115_((String)"jade.fluid.empty");
                String capacityText = DisplayHelper.INSTANCE.humanReadableNumber((double)capacity, "B", true);
                text.m_130946_("\u00a77 " + capacityText);
                if (isLocked) {
                    text = Component.m_237115_((String)(I18n.m_118938_((String)new FluidStack(cacheFluid, 1).getTranslationKey(), (Object[])new Object[0]) + " 0B \u00a7e(" + I18n.m_118938_((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ") "));
                }
            } else {
                String amountText = DisplayHelper.INSTANCE.humanReadableNumber((double)fluidStack.getAmount(), "B", true);
                MutableComponent mutableComponent = text = isLocked ? Component.m_237110_((String)"jade.fluid", (Object[])new Object[]{fluidStack.getDisplayName(), amountText}).m_130946_(" \u00a7e(" + I18n.m_118938_((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ") ") : Component.m_237110_((String)"jade.fluid", (Object[])new Object[]{fluidStack.getDisplayName(), amountText});
                if (accessor.getPlayer().m_6144_()) {
                    String capacityText = DisplayHelper.INSTANCE.humanReadableNumber((double)capacity, "B", true);
                    text.m_130946_("\u00a77 / " + capacityText);
                }
            }
            IProgressStyle progressStyle = helper.progressStyle().overlay(helper.fluid(JadeFluidObject.of((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (CompoundTag)fluidStack.getTag())));
            tooltip.add(helper.progress((float)fluidStack.getAmount() / (float)capacity, (Component)text, progressStyle, (IBoxStyle)BoxStyle.DEFAULT, true));
        }
    }

    public ResourceLocation getUid() {
        return FluidDrawersLegacyMod.rl("fluiddrawer");
    }

    public int getDefaultPriority() {
        return FluidStorageProvider.INSTANCE.getDefaultPriority() + 1000;
    }
}

