/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.configuration.DistributionCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.FilterCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.FilterModeCache;
import de.maxhenkel.pipez.blocks.tileentity.configuration.RedstoneModeCache;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.inventory.ItemListInventory;
import de.maxhenkel.pipez.corelib.item.ItemUtils;
import de.maxhenkel.pipez.items.UpgradeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class UpgradeTileEntity
extends PipeTileEntity {
    protected final NonNullList<ItemStack> upgradeInventory = NonNullList.m_122780_((int)Direction.values().length, (Object)ItemStack.f_41583_);
    protected final ItemListInventory inventory = new ItemListInventory(this.upgradeInventory, this::invalidateAllCaches);
    protected RedstoneModeCache redstoneModes;
    protected DistributionCache distributions;
    protected FilterModeCache filterModes;
    protected FilterCache filters;

    public UpgradeTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.initCaches();
    }

    public void initCaches() {
        this.redstoneModes = new RedstoneModeCache(() -> this.upgradeInventory, PipeType::getDefaultRedstoneMode, this::invalidateAllCaches);
        this.distributions = new DistributionCache(() -> this.upgradeInventory, PipeType::getDefaultDistribution, this::invalidateAllCaches);
        this.filterModes = new FilterModeCache(() -> this.upgradeInventory, PipeType::getDefaultFilterMode, this::invalidateAllCaches);
        this.filters = new FilterCache(() -> this.upgradeInventory, PipeType::createFilter, this::invalidateAllCaches);
    }

    public void invalidateAllCaches() {
        this.redstoneModes.invalidate();
        this.distributions.invalidate();
        this.filterModes.invalidate();
        this.filters.invalidate();
        this.m_6596_();
    }

    public ItemStack setUpgradeItem(Direction side, ItemStack upgrade) {
        ItemStack old = (ItemStack)this.upgradeInventory.get(side.m_122411_());
        this.upgradeInventory.set(side.m_122411_(), (Object)upgrade);
        this.invalidateAllCaches();
        return old;
    }

    public ItemStack getUpgradeItem(Direction side) {
        return (ItemStack)this.upgradeInventory.get(side.m_122411_());
    }

    public RedstoneMode getRedstoneMode(Direction side, PipeType pipeType) {
        return (RedstoneMode)this.redstoneModes.getValue(side, pipeType);
    }

    public void setRedstoneMode(Direction side, PipeType pipeType, RedstoneMode redstoneMode) {
        this.redstoneModes.setValue(side, pipeType, redstoneMode);
    }

    public Distribution getDistribution(Direction side, PipeType pipeType) {
        return (Distribution)this.distributions.getValue(side, pipeType);
    }

    public void setDistribution(Direction side, PipeType pipeType, Distribution distribution) {
        this.distributions.setValue(side, pipeType, distribution);
    }

    public FilterMode getFilterMode(Direction side, PipeType pipeType) {
        return (FilterMode)this.filterModes.getValue(side, pipeType);
    }

    public void setFilterMode(Direction side, PipeType pipeType, FilterMode filterMode) {
        this.filterModes.setValue(side, pipeType, filterMode);
    }

    public <T> List<Filter<?>> getFilters(Direction side, PipeType<T> pipeType) {
        return (List)this.filters.getValue(side, pipeType);
    }

    public <T> void setFilters(Direction side, PipeType<T> pipeType, List<Filter<?>> filter) {
        this.filters.setValue(side, pipeType, filter);
    }

    @Override
    public void setExtracting(Direction side, boolean extracting) {
        super.setExtracting(side, extracting);
        if (!extracting) {
            ItemStack stack = (ItemStack)this.upgradeInventory.get(side.m_122411_());
            this.upgradeInventory.set(side.m_122411_(), (Object)ItemStack.f_41583_);
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}));
            this.m_6596_();
        }
    }

    public Container getUpgradeInventory() {
        return this.inventory;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.upgradeInventory.clear();
        ItemUtils.readInventory(compound, "Upgrades", this.upgradeInventory);
        this.invalidateAllCaches();
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ItemUtils.saveInventory(compound, "Upgrades", this.upgradeInventory);
    }

    @Nullable
    public Upgrade getUpgrade(Direction direction) {
        ItemStack stack = (ItemStack)this.upgradeInventory.get(direction.m_122411_());
        if (stack.m_41720_() instanceof UpgradeItem) {
            return ((UpgradeItem)stack.m_41720_()).getTier();
        }
        return null;
    }

    public List<PipeTileEntity.Connection> getSortedConnections(Direction side, PipeType pipeType) {
        Distribution distribution = this.getDistribution(side, pipeType);
        switch (distribution) {
            case FURTHEST: {
                return this.getConnections().stream().sorted((o1, o2) -> Integer.compare(o2.getDistance(), o1.getDistance())).collect(Collectors.toList());
            }
            case RANDOM: {
                ArrayList<PipeTileEntity.Connection> shuffle = new ArrayList<PipeTileEntity.Connection>(this.getConnections());
                Collections.shuffle(shuffle);
                return shuffle;
            }
        }
        return this.getConnections().stream().sorted(Comparator.comparingInt(PipeTileEntity.Connection::getDistance)).collect(Collectors.toList());
    }

    public static enum RedstoneMode implements ICyclable<RedstoneMode>
    {
        IGNORED("ignored"),
        OFF_WHEN_POWERED("off_when_powered"),
        ON_WHEN_POWERED("on_when_powered"),
        ALWAYS_OFF("always_off");

        private final String name;

        private RedstoneMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public RedstoneMode cycle() {
            return RedstoneMode.values()[Math.floorMod(this.ordinal() + 1, RedstoneMode.values().length)];
        }
    }

    public static enum Distribution implements ICyclable<Distribution>
    {
        NEAREST("nearest"),
        FURTHEST("furthest"),
        ROUND_ROBIN("round_robin"),
        RANDOM("random");

        private final String name;

        private Distribution(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Distribution cycle() {
            return Distribution.values()[Math.floorMod(this.ordinal() + 1, Distribution.values().length)];
        }
    }

    public static enum FilterMode implements ICyclable<FilterMode>
    {
        WHITELIST("whitelist"),
        BLACKLIST("blacklist");

        private final String name;

        private FilterMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public FilterMode cycle() {
            return FilterMode.values()[Math.floorMod(this.ordinal() + 1, FilterMode.values().length)];
        }
    }

    public static interface ICyclable<T extends Enum<?>> {
        public T cycle();
    }
}

