/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network.client;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.melongolem.network.NetworkMessages;

public class ClientPacketHandlerParticle
implements NetworkMessages.IMessage<ClientPacketHandlerParticle> {
    private ResourceLocation id;
    private Vec3 vec;
    private Vec3 vel;

    public ClientPacketHandlerParticle(ResourceLocation particle, Vec3 vertex, Vec3 vel) {
        this.id = particle;
        this.vec = vertex;
        this.vel = vel;
    }

    public static void spawnParticle(Level world, ParticleOptions particle, Vec3 vertex, Vec3 vel) {
        world.m_7106_(particle, vertex.f_82479_, vertex.f_82480_, vertex.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
    }

    private static ParticleOptions getRegisteredParticleTypes(ResourceLocation location) {
        ParticleType t = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(location);
        if (!(t instanceof ParticleOptions)) {
            throw new IllegalStateException("Invalid or unknown particle type: " + location);
        }
        return (ParticleOptions)t;
    }

    @Override
    public void handle(Player player) {
        ClientPacketHandlerParticle.spawnParticle(player.m_9236_(), ClientPacketHandlerParticle.getRegisteredParticleTypes(this.id), this.vec, this.vel);
    }

    @Override
    public void toBytes(FriendlyByteBuf packet) {
        packet.m_130085_(this.id);
        packet.writeDouble(this.vec.f_82479_);
        packet.writeDouble(this.vec.f_82480_);
        packet.writeDouble(this.vec.f_82481_);
        packet.writeDouble(this.vel.f_82479_);
        packet.writeDouble(this.vel.f_82480_);
        packet.writeDouble(this.vel.f_82481_);
    }

    @Override
    public ClientPacketHandlerParticle fromBytes(FriendlyByteBuf packet) {
        this.id = packet.m_130281_();
        this.vec = new Vec3(packet.readDouble(), packet.readDouble(), packet.readDouble());
        this.vel = new Vec3(packet.readDouble(), packet.readDouble(), packet.readDouble());
        return this;
    }
}

