/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network.client;

import com.mojang.text2speech.Narrator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.common.EntityMelonGolem;
import tamaized.melongolem.network.NetworkMessages;

public class ClientPacketHandlerMelonAmbientSound
implements NetworkMessages.IMessage<ClientPacketHandlerMelonAmbientSound> {
    private static Narrator narrator;
    private int id;

    public ClientPacketHandlerMelonAmbientSound(EntityMelonGolem golem) {
        this.id = golem.m_19879_();
    }

    private static void playAmbientSound(Player player, EntityMelonGolem golem) {
        SoundEvent soundevent = ClientPacketHandlerMelonAmbientSound.getAmbientSound();
        if (soundevent != null) {
            golem.m_9236_().m_6263_(player, golem.m_20185_(), golem.m_20186_(), golem.m_20189_(), soundevent, golem.m_5720_(), golem.m_6121_(), ClientPacketHandlerMelonAmbientSound.getVoicePitch(golem));
        }
    }

    private static float getVoicePitch(EntityMelonGolem golem) {
        return (Boolean)MelonMod.configClient.tehnutMode.get() != false ? golem.getPitch() + golem.m_9236_().m_213780_().m_188501_() * 0.25f - 0.5f : golem.m_6100_();
    }

    @Nullable
    private static SoundEvent getAmbientSound() {
        return (Boolean)MelonMod.configClient.tehnutMode.get() != false ? (SoundEvent)MelonMod.DADDY.get() : null;
    }

    @Override
    public void handle(Player player) {
        Entity entity = player.m_9236_().m_6815_(this.id);
        if (entity instanceof EntityMelonGolem) {
            EntityMelonGolem golem = (EntityMelonGolem)entity;
            if (golem.getHead().m_204117_(ItemTags.f_13157_)) {
                if (((Boolean)MelonMod.configClient.tts.get()).booleanValue() && golem.m_20280_((Entity)player) <= 225.0) {
                    if (narrator == null) {
                        narrator = Narrator.getNarrator();
                    }
                    if (!narrator.active()) {
                        return;
                    }
                    narrator.clear();
                    StringBuilder string = new StringBuilder();
                    for (int i = 0; i < 4; ++i) {
                        string.append(ChatFormatting.m_126649_((String)golem.getSignText(i).getString())).append(" ");
                    }
                    narrator.say(string.toString(), false);
                }
            } else {
                ClientPacketHandlerMelonAmbientSound.playAmbientSound(player, golem);
            }
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf packet) {
        packet.writeInt(this.id);
    }

    @Override
    public ClientPacketHandlerMelonAmbientSound fromBytes(FriendlyByteBuf packet) {
        this.id = packet.readInt();
        return this;
    }
}

