/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import tamaized.melongolem.network.client.ClientPacketHandlerMelonAmbientSound;
import tamaized.melongolem.network.client.ClientPacketHandlerParticle;
import tamaized.melongolem.network.server.ServerPacketHandlerDonatorSettings;
import tamaized.melongolem.network.server.ServerPacketHandlerMelonSign;

public class NetworkMessages {
    private static int index = 0;

    public static void register(SimpleChannel network) {
        NetworkMessages.registerMessage(network, ServerPacketHandlerMelonSign.class, IMessage.Side.SERVER);
        NetworkMessages.registerMessage(network, ServerPacketHandlerDonatorSettings.class, IMessage.Side.SERVER);
        NetworkMessages.registerMessage(network, ClientPacketHandlerMelonAmbientSound.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerParticle.class, IMessage.Side.CLIENT);
    }

    private static <M extends IMessage<M>> void registerMessage(SimpleChannel network, Class<M> type, IMessage.Side side) {
        network.registerMessage(index++, type, IMessage::encode, p -> IMessage.decode(p, type), (m, s) -> IMessage.onMessage(m, s, side));
    }

    public static interface IMessage<SELF extends IMessage<SELF>> {
        public static <M extends IMessage<M>> void encode(M message, FriendlyByteBuf packet) {
            message.toBytes(packet);
        }

        public static <M extends IMessage<M>> M decode(FriendlyByteBuf packet, Class<M> type) {
            return (M)((IMessage)UnsafeHacks.newInstance(type)).fromBytes(packet);
        }

        public static void onMessage(IMessage message, Supplier<NetworkEvent.Context> context, Side side) {
            context.get().enqueueWork(() -> message.handle((Player)(side == Side.SERVER ? ((NetworkEvent.Context)context.get()).getSender() : IMessage.getClientSidePlayer().get())));
            context.get().setPacketHandled(true);
        }

        public static Supplier<Player> getClientSidePlayer() {
            return new Supplier<Player>(){

                @Override
                public Player get() {
                    return Minecraft.m_91087_().f_91074_;
                }
            };
        }

        public void handle(Player var1);

        public void toBytes(FriendlyByteBuf var1);

        public SELF fromBytes(FriendlyByteBuf var1);

        public static enum Side {
            CLIENT,
            SERVER;

        }
    }
}

