/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common.capability;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.capability.ITinyGolemCapability;

public class TinyGolemCapabilityHandler
implements ITinyGolemCapability {
    private EntityTinyMelonGolem pet;
    private BlockPos vertex;
    private ResourceLocation dim;
    private UUID petID;

    @Override
    public EntityTinyMelonGolem getPet() {
        return this.pet;
    }

    @Override
    public void setPet(EntityTinyMelonGolem golem) {
        this.pet = golem;
    }

    @Override
    public void markDirty(BlockPos vertex, ResourceLocation dim, UUID petID) {
        this.vertex = vertex;
        this.dim = dim;
        this.petID = petID;
    }

    @Override
    public ResourceLocation getLoadDim() {
        return this.dim;
    }

    @Override
    public BlockPos getLoadPos() {
        return this.vertex;
    }

    @Override
    public UUID getLoadPetID() {
        return this.petID;
    }

    @Override
    public boolean load(boolean clear) {
        boolean flag;
        boolean bl = flag = this.pet == null && this.vertex != null && this.petID != null;
        if (clear) {
            this.dim = Level.f_46428_.m_135782_();
            this.vertex = null;
            this.petID = null;
        }
        return flag;
    }

    @Override
    public void copyFrom(ITinyGolemCapability cap) {
        this.setPet(cap.getPet());
        this.markDirty(cap.getLoadPos(), cap.getLoadDim(), cap.getLoadPetID());
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        EntityTinyMelonGolem pet = this.getPet();
        if (pet != null && pet.m_21805_() != null) {
            nbt.m_128356_("vertex", pet.m_20183_().m_121878_());
            nbt.m_128359_("dim", pet.m_9236_().m_46472_().m_135782_().toString());
            nbt.m_128362_("uuid", pet.m_20148_());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("vertex") && nbt.m_128441_("dim") && nbt.m_128441_("uuid")) {
            this.markDirty(BlockPos.m_122022_((long)nbt.m_128454_("vertex")), new ResourceLocation(nbt.m_128461_("dim")), nbt.m_128342_("uuid"));
        }
    }
}

