/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common.capability;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tamaized.melongolem.common.capability.ITinyGolemCapability;
import tamaized.melongolem.common.capability.TinyGolemCapabilityHandler;

@Mod.EventBusSubscriber(modid="melongolem")
public class CapabilityList {
    public static final Capability<ITinyGolemCapability> TINY_GOLEM = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITinyGolemCapability>(){});

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ITinyGolemCapability.class);
    }

    @SubscribeEvent
    public static void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(ITinyGolemCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                LazyOptional<ITinyGolemCapability> inst = LazyOptional.of(TinyGolemCapabilityHandler::new);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return TINY_GOLEM.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((ITinyGolemCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((ITinyGolemCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void updateClone(PlayerEvent.Clone e) {
        e.getEntity().getCapability(TINY_GOLEM).ifPresent(cap -> e.getOriginal().getCapability(TINY_GOLEM).ifPresent(cap::copyFrom));
    }
}

