/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.capability.CapabilityList;
import tamaized.melongolem.network.client.ClientPacketHandlerParticle;

public class ItemMelonStick
extends Item {
    public ItemMelonStick(Item.Properties prop) {
        super(prop.m_41499_(25));
    }

    public static void summonPet(Level world, Player owner) {
        ItemMelonStick.summonPet(world, owner, null);
    }

    public static void summonPet(Level world, Player owner, EntityTinyMelonGolem golem) {
        if (golem != null && !golem.m_6084_()) {
            return;
        }
        owner.getCapability(CapabilityList.TINY_GOLEM).ifPresent(cap -> {
            EntityTinyMelonGolem oldPet;
            if (cap.load(true)) {
                if (!(world instanceof ServerLevel) || owner.m_9236_().m_7654_() == null) {
                    return;
                }
                ServerLevel last = owner.m_9236_().m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)cap.getLoadDim()));
                if (last != null && cap.getLoadPos() != null) {
                    last.m_46865_(cap.getLoadPos());
                    Entity entity = last.m_8791_(cap.getLoadPetID());
                    if (entity instanceof EntityTinyMelonGolem) {
                        EntityTinyMelonGolem melon = (EntityTinyMelonGolem)entity;
                        if (!world.m_46472_().m_135782_().equals((Object)last.m_46472_().m_135782_())) {
                            melon.m_5489_((ServerLevel)world);
                        }
                        ItemMelonStick.summonPet(world, owner, melon);
                        return;
                    }
                }
            }
            EntityTinyMelonGolem entityTinyMelonGolem = oldPet = golem != null ? golem : cap.getPet();
            if (oldPet != null && !oldPet.m_6084_()) {
                oldPet = null;
            }
            EntityTinyMelonGolem pet = oldPet == null ? new EntityTinyMelonGolem(world) : oldPet;
            pet.m_21828_(owner);
            if (oldPet == null) {
                cap.setPet(pet);
            }
            int x = Mth.m_14107_((double)owner.m_20185_()) - 2;
            int z = Mth.m_14107_((double)owner.m_20189_()) - 2;
            int y = Mth.m_14107_((double)owner.m_20191_().f_82289_);
            block0: for (int l = pet.m_217043_().m_188503_(6); l <= 8; ++l) {
                for (int i1 = pet.m_217043_().m_188503_(6); i1 <= 8; ++i1) {
                    for (int j = 3; j > -3; --j) {
                        if (!ItemMelonStick.isTeleportFriendlyBlock(world, (Entity)pet, x, z, y + j, l, i1)) continue;
                        double posx = (float)(x + l) + 0.5f;
                        double posy = (double)y + (double)j;
                        double posz = (float)(z + i1) + 0.5f;
                        pet.m_6027_(posx, posy, posz);
                        if (!pet.m_9236_().m_46472_().m_135782_().equals((Object)owner.m_9236_().m_46472_().m_135782_())) {
                            pet = (EntityTinyMelonGolem)pet.m_5489_((ServerLevel)owner.m_9236_());
                            cap.setPet(pet);
                            if (pet == null) {
                                return;
                            }
                            pet.m_6027_(posx, posy, posz);
                        }
                        for (int i = 0; i < 25; ++i) {
                            Vec3 result = pet.m_20252_(1.0f).m_82524_(pet.m_217043_().m_188501_() * 360.0f).m_82496_(pet.m_217043_().m_188501_() * 360.0f).m_82490_((double)0.35f);
                            ItemMelonStick.spawnVanillaParticleOnServer(world, (ParticleOptions)ParticleTypes.f_123810_, pet.m_20185_() + result.f_82479_, pet.m_20186_() + (double)(pet.m_20206_() / 2.0f) + result.f_82480_, pet.m_20189_() + result.f_82481_, 0.0, 0.0, 0.0);
                        }
                        if (oldPet == null) {
                            world.m_7967_((Entity)pet);
                        }
                        world.m_5594_(null, pet.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, pet.m_217043_().m_188501_() + 0.5f);
                        break block0;
                    }
                }
            }
        });
    }

    public static void spawnVanillaParticleOnServer(Level world, ParticleOptions particle, double x, double y, double z, double xS, double yS, double zS) {
        MelonMod.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_46745_(BlockPos.m_274561_((double)x, (double)y, (double)z))), (Object)new ClientPacketHandlerParticle(ForgeRegistries.PARTICLE_TYPES.getKey((Object)particle.m_6012_()), new Vec3(x, y, z), new Vec3(xS, yS, zS)));
    }

    private static boolean isTeleportFriendlyBlock(Level world, Entity entity, int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        BlockState iblockstate = world.m_8055_(blockpos);
        return Block.m_49863_((LevelReader)world, (BlockPos)blockpos, (Direction)Direction.UP) && iblockstate.m_60643_((BlockGetter)entity.m_9236_(), entity.m_20183_(), entity.m_6095_()) && world.m_46859_(blockpos.m_7494_()) && world.m_46859_(blockpos.m_6630_(2));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        playerIn.m_6674_(handIn);
        if (worldIn.m_5776_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
        }
        ItemMelonStick.summonPet(worldIn, playerIn);
        playerIn.m_21120_(handIn).m_41622_(1, (LivingEntity)playerIn, e -> e.m_21190_(handIn));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
    }
}

