/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import tamaized.melongolem.ISignHolder;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.client.ClientListener;
import tamaized.melongolem.common.ItemMelonStick;
import tamaized.melongolem.common.capability.CapabilityList;
import tamaized.melongolem.network.DonatorHandler;

public class EntityTinyMelonGolem
extends TamableAnimal
implements IForgeShearable,
IEntityAdditionalSpawnData,
ISignHolder {
    private static final EntityDataAccessor<ItemStack> HEAD = SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> ENABLED = SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GLOWING_TEXT = SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TEXT_COLOR = SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<EntityDataAccessor<Component>> SIGN_TEXT = Lists.newArrayList((Object[])new EntityDataAccessor[]{SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_), SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_), SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_), SynchedEntityData.m_135353_(EntityTinyMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_)});

    public EntityTinyMelonGolem(Level worldIn) {
        super(Objects.requireNonNull((EntityType)MelonMod.ENTITY_TYPE_TINY_MELON_GOLEM.get()), worldIn);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GLOWING_TEXT, (Object)false);
        this.f_19804_.m_135372_(TEXT_COLOR, (Object)DyeColor.BLACK.m_41060_());
        this.f_19804_.m_135372_(ENABLED, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)0xFFFFFF);
        for (EntityDataAccessor<Component> sign : SIGN_TEXT) {
            this.f_19804_.m_135372_(sign, (Object)Component.m_237113_((String)""));
        }
    }

    public void m_8119_() {
        DonatorHandler.DonatorSettings settings;
        super.m_8119_();
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return;
        }
        if (this.m_269323_() != null && this.m_269323_().m_6084_() && DonatorHandler.donators.contains(this.m_21805_()) && (settings = DonatorHandler.settings.get(this.m_21805_())) != null) {
            this.f_19804_.m_135381_(ENABLED, (Object)settings.enabled);
            this.f_19804_.m_135381_(COLOR, (Object)settings.color);
        }
        if (this.m_269323_() instanceof Player) {
            this.m_269323_().getCapability(CapabilityList.TINY_GOLEM).ifPresent(cap -> {
                if (cap.getPet() != this) {
                    if (cap.getPet() != null && cap.getPet().m_20148_().equals(this.m_20148_())) {
                        this.m_146870_();
                        return;
                    }
                    ItemMelonStick.summonPet(this.m_9236_(), (Player)this.m_269323_(), this);
                    if (cap.getPet() == null) {
                        cap.setPet(this);
                    } else {
                        this.m_6469_(this.m_269291_().m_287172_(), Float.MAX_VALUE);
                    }
                }
            });
        }
    }

    public boolean isEnabled() {
        return (Boolean)this.f_19804_.m_135370_(ENABLED);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    @Override
    public void setSignText(int index, Component text) {
        this.f_19804_.m_135381_(SIGN_TEXT.get(index), (Object)text);
    }

    @Override
    public int networkID() {
        return this.m_19879_();
    }

    @Override
    public boolean glowingText() {
        return (Boolean)this.m_20088_().m_135370_(GLOWING_TEXT);
    }

    @Override
    public DyeColor getTextColor() {
        return DyeColor.m_41053_((int)((Integer)this.m_20088_().m_135370_(TEXT_COLOR)));
    }

    @Override
    public Component getSignText(int index) {
        return (Component)this.f_19804_.m_135370_(SIGN_TEXT.get(index));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 4.0f, 2.0f, true));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos vertex) {
        return !this.getHead().m_41619_();
    }

    public float m_6100_() {
        return this.f_19796_.m_188501_() * 0.5f + 2.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12386_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if ((Boolean)MelonMod.config.hats.get() == false) return InteractionResult.FAIL;
        if (player.m_21205_().m_41720_() instanceof ShearsItem) return InteractionResult.FAIL;
        if (player.m_21206_().m_41720_() instanceof ShearsItem) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getHead().m_41619_()) {
            if (Block.m_49814_((Item)stack.m_41720_()) == Blocks.f_50016_) {
                if (!stack.m_204117_(ItemTags.f_13157_)) return InteractionResult.FAIL;
            }
            this.setHead(stack);
            if (player.m_7500_()) return InteractionResult.SUCCESS;
            player.m_21120_(hand).m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.getHead().m_41619_()) return InteractionResult.FAIL;
        if (!this.getHead().m_204117_(ItemTags.f_13157_)) return InteractionResult.FAIL;
        if (stack.m_150930_(Items.f_151056_) && !((Boolean)this.m_20088_().m_135370_(GLOWING_TEXT)).booleanValue()) {
            this.m_20088_().m_135381_(GLOWING_TEXT, (Object)true);
            this.m_216990_(SoundEvents.f_144153_);
            if (player.m_7500_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            player.m_21120_(hand).m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (stack.m_150930_(Items.f_42532_) && ((Boolean)this.m_20088_().m_135370_(GLOWING_TEXT)).booleanValue()) {
            this.m_20088_().m_135381_(GLOWING_TEXT, (Object)false);
            this.m_216990_(SoundEvents.f_144181_);
            if (player.m_7500_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            player.m_21120_(hand).m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (this.getTextColor() != dye.m_41089_()) {
                this.m_20088_().m_135381_(TEXT_COLOR, (Object)dye.m_41089_().m_41060_());
                this.m_216990_(SoundEvents.f_144133_);
                if (player.m_7500_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                player.m_21120_(hand).m_41774_(1);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        if (!this.m_9236_().m_5776_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        ClientListener.openSignHolderGui(this);
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public float getEyeHeightAccess(Pose pose, EntityDimensions dimensions) {
        return 0.425f;
    }

    @Override
    public float _distanceTo(Entity entityIn) {
        return this.m_20270_(entityIn);
    }

    @Override
    public ItemStack getHead() {
        return (ItemStack)this.f_19804_.m_135370_(HEAD);
    }

    public void setHead(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            this.setSignText(i, (Component)Component.m_237113_((String)""));
        }
        ItemStack newstack = stack.m_41777_();
        newstack.m_41764_(1);
        this.f_19804_.m_135381_(HEAD, (Object)newstack);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos vertex, int fortune) {
        ArrayList list = Lists.newArrayList((Object[])new ItemStack[]{(Boolean)MelonMod.config.shear.get() != false ? this.getHead() : ItemStack.f_41583_});
        this.setHead(ItemStack.f_41583_);
        return list;
    }

    public void m_6667_(@Nonnull DamageSource cause) {
        super.m_6667_(cause);
        ItemStack stack = this.getHead();
        if (!this.m_9236_().m_5776_() && !stack.m_41619_()) {
            ItemEntity e = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
            e.m_20256_(e.m_20184_().m_82520_((double)(this.m_217043_().m_188501_() * 0.05f), (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.1f), (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.1f)));
            this.m_9236_().m_7967_((Entity)e);
        }
    }

    @Nonnull
    public CompoundTag m_20240_(CompoundTag compound) {
        compound.m_128365_("head", (Tag)this.getHead().serializeNBT());
        compound.m_128379_("glowingText", this.glowingText());
        compound.m_128405_("textColor", this.getTextColor().m_41060_());
        compound.m_128379_("donator_enabled", this.isEnabled());
        compound.m_128405_("donator_color", this.getColor());
        for (int i = 0; i < 4; ++i) {
            String s = Component.Serializer.m_130703_((Component)this.getSignText(i));
            compound.m_128359_("Text" + (i + 1), s);
        }
        return super.m_20240_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("donator_enabled")) {
            this.f_19804_.m_135381_(ENABLED, (Object)compound.m_128471_("donator_enabled"));
        }
        if (compound.m_128441_("donator_color")) {
            this.f_19804_.m_135381_(COLOR, (Object)compound.m_128451_("donator_color"));
        }
        this.setHead(ItemStack.m_41712_((CompoundTag)compound.m_128469_("head")));
        this.m_20088_().m_135381_(GLOWING_TEXT, (Object)compound.m_128471_("glowingText"));
        this.m_20088_().m_135381_(TEXT_COLOR, (Object)compound.m_128451_("textColor"));
        for (int i = 0; i < 4; ++i) {
            String s = compound.m_128461_("Text" + (i + 1));
            MutableComponent itextcomponent = Component.Serializer.m_130701_((String)s);
            try {
                this.setSignText(i, (Component)(itextcomponent == null ? Component.m_237113_((String)"") : ComponentUtils.m_130731_((CommandSourceStack)this.m_20203_(), (Component)itextcomponent, null, (int)0)));
                continue;
            }
            catch (CommandSyntaxException | CommandRuntimeException var7) {
                this.setSignText(i, (Component)itextcomponent);
            }
        }
        super.m_7378_(compound);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.getHead());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setHead(additionalData.m_130267_());
    }
}

