/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import tamaized.melongolem.ISignHolder;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.client.ClientListener;
import tamaized.melongolem.common.EntityGlisteringMelonGolem;
import tamaized.melongolem.common.EntityMelonSlice;
import tamaized.melongolem.network.client.ClientPacketHandlerMelonAmbientSound;

public class EntityMelonGolem
extends AbstractGolem
implements RangedAttackMob,
IForgeShearable,
IEntityAdditionalSpawnData,
ISignHolder {
    private static final EntityDataAccessor<ItemStack> HEAD = SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> GLOWING_TEXT = SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TEXT_COLOR = SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<EntityDataAccessor<Component>> SIGN_TEXT = Lists.newArrayList((Object[])new EntityDataAccessor[]{SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_), SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_), SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_), SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135031_)});
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(EntityMelonGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static BlockState SIGN_TILE_BLOCKSTATE = Blocks.f_50158_.m_49966_();
    public static final SignBlockEntity te = new SignBlockEntity(BlockPos.f_121853_, SIGN_TILE_BLOCKSTATE){

        @Nonnull
        public BlockState m_58900_() {
            return SIGN_TILE_BLOCKSTATE;
        }

        @Nonnull
        public BlockPos m_58899_() {
            return FMLEnvironment.dist == Dist.CLIENT && Minecraft.m_91087_().m_91288_() != null ? Minecraft.m_91087_().m_91288_().m_20183_() : this.f_58858_;
        }
    };

    public EntityMelonGolem(Level level) {
        this((EntityType<? extends AbstractGolem>)Objects.requireNonNull((EntityType)MelonMod.ENTITY_TYPE_MELON_GOLEM.get()), level);
    }

    protected EntityMelonGolem(EntityType<? extends AbstractGolem> entity, Level level) {
        super(entity, level);
    }

    public static AttributeSupplier.Builder _registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GLOWING_TEXT, (Object)false);
        this.f_19804_.m_135372_(TEXT_COLOR, (Object)DyeColor.BLACK.m_41060_());
        for (EntityDataAccessor<Component> sign : SIGN_TEXT) {
            this.f_19804_.m_135372_(sign, (Object)Component.m_237113_((String)""));
        }
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(this.m_217043_().m_188501_() * 3.0f));
    }

    @Override
    public void setSignText(int index, Component text) {
        this.f_19804_.m_135381_(SIGN_TEXT.get(index), (Object)text);
    }

    @Override
    public int networkID() {
        return this.m_19879_();
    }

    @Override
    public boolean glowingText() {
        return (Boolean)this.m_20088_().m_135370_(GLOWING_TEXT);
    }

    @Override
    public DyeColor getTextColor() {
        return DyeColor.m_41053_((int)((Integer)this.m_20088_().m_135370_(TEXT_COLOR)));
    }

    @Override
    public Component getSignText(int index) {
        return (Component)this.f_19804_.m_135370_(SIGN_TEXT.get(index));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new EntityAISearchAndEatMelons((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof Enemy));
    }

    public void m_6504_(@Nonnull LivingEntity target, float distanceFactor) {
        EntityMelonSlice slice = new EntityMelonSlice(this.m_9236_(), (LivingEntity)this);
        double d0 = target.m_20186_() + (double)target.m_20192_() - (double)1.1f;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - slice.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        slice.m_6686_(d1, d2 + f, d3, 1.6f, 12.0f);
        this.m_5496_(SoundEvents.f_12479_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        slice.m_6021_(slice.m_20185_(), slice.m_20186_(), slice.m_20189_());
        this.m_9236_().m_7967_((Entity)slice);
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos vertex) {
        return !this.getHead().m_41619_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12386_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    public int m_8100_() {
        return this.getHead().m_204117_(ItemTags.f_13157_) ? 200 : super.m_8100_();
    }

    public float m_6100_() {
        return super.m_6100_();
    }

    public float m_6121_() {
        return super.m_6121_();
    }

    public void m_8032_() {
        if (this.m_9236_() != null && !this.m_9236_().m_5776_()) {
            MelonMod.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientPacketHandlerMelonAmbientSound(this));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if ((Boolean)MelonMod.config.hats.get() == false) return InteractionResult.FAIL;
        if (player.m_21205_().m_41720_() instanceof ShearsItem) return InteractionResult.FAIL;
        if (player.m_21206_().m_41720_() instanceof ShearsItem) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getHead().m_41619_()) {
            if (Block.m_49814_((Item)stack.m_41720_()) == Blocks.f_50016_) {
                if (!stack.m_204117_(ItemTags.f_13157_)) return InteractionResult.FAIL;
            }
            this.setHead(stack);
            if (player.m_7500_()) return InteractionResult.SUCCESS;
            player.m_21120_(hand).m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.getHead().m_41619_()) return InteractionResult.FAIL;
        if (!this.getHead().m_204117_(ItemTags.f_13157_)) return InteractionResult.FAIL;
        if (stack.m_150930_(Items.f_151056_) && !((Boolean)this.m_20088_().m_135370_(GLOWING_TEXT)).booleanValue()) {
            this.m_20088_().m_135381_(GLOWING_TEXT, (Object)true);
            this.m_216990_(SoundEvents.f_144153_);
            if (player.m_7500_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            player.m_21120_(hand).m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (stack.m_150930_(Items.f_42532_) && ((Boolean)this.m_20088_().m_135370_(GLOWING_TEXT)).booleanValue()) {
            this.m_20088_().m_135381_(GLOWING_TEXT, (Object)false);
            this.m_216990_(SoundEvents.f_144181_);
            if (player.m_7500_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            player.m_21120_(hand).m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (this.getTextColor() != dye.m_41089_()) {
                this.m_20088_().m_135381_(TEXT_COLOR, (Object)dye.m_41089_().m_41060_());
                this.m_216990_(SoundEvents.f_144133_);
                if (player.m_7500_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                player.m_21120_(hand).m_41774_(1);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        if (!this.m_9236_().m_5776_()) return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        ClientListener.openSignHolderGui(this);
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.7f;
    }

    @Override
    public float _distanceTo(Entity entityIn) {
        return this.m_20270_(entityIn);
    }

    @Override
    public ItemStack getHead() {
        return (ItemStack)this.f_19804_.m_135370_(HEAD);
    }

    public void setHead(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            this.setSignText(i, (Component)Component.m_237113_((String)""));
        }
        ItemStack newstack = stack.m_41777_();
        newstack.m_41764_(1);
        this.f_19804_.m_135381_(HEAD, (Object)newstack);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos vertex, int fortune) {
        ArrayList list = Lists.newArrayList((Object[])new ItemStack[]{(Boolean)MelonMod.config.shear.get() != false ? this.getHead() : ItemStack.f_41583_});
        this.setHead(ItemStack.f_41583_);
        return list;
    }

    public void m_6667_(@Nonnull DamageSource cause) {
        super.m_6667_(cause);
        ItemStack stack = this.getHead();
        if (!this.m_9236_().m_5776_() && !stack.m_41619_()) {
            ItemEntity e = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
            e.m_20256_(e.m_20184_().m_82520_((double)(this.m_217043_().m_188501_() * 0.05f), (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.1f), (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.1f)));
            this.m_9236_().m_7967_((Entity)e);
        }
    }

    @Nonnull
    public CompoundTag m_20240_(CompoundTag compound) {
        compound.m_128365_("head", (Tag)this.getHead().serializeNBT());
        compound.m_128379_("glowingText", this.glowingText());
        compound.m_128405_("textColor", this.getTextColor().m_41060_());
        for (int i = 0; i < 4; ++i) {
            String s = Component.Serializer.m_130703_((Component)this.getSignText(i));
            compound.m_128359_("Text" + (i + 1), s);
        }
        return super.m_20240_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        this.setHead(ItemStack.m_41712_((CompoundTag)compound.m_128469_("head")));
        this.m_20088_().m_135381_(GLOWING_TEXT, (Object)compound.m_128471_("glowingText"));
        this.m_20088_().m_135381_(TEXT_COLOR, (Object)compound.m_128451_("textColor"));
        for (int i = 0; i < 4; ++i) {
            String s = compound.m_128461_("Text" + (i + 1));
            MutableComponent itextcomponent = Component.Serializer.m_130701_((String)s);
            try {
                this.setSignText(i, (Component)(itextcomponent == null ? Component.m_237113_((String)"") : ComponentUtils.m_130731_((CommandSourceStack)this.m_20203_(), (Component)itextcomponent, null, (int)0)));
                continue;
            }
            catch (CommandSyntaxException | CommandRuntimeException var7) {
                this.setSignText(i, (Component)itextcomponent);
            }
        }
        super.m_7378_(compound);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.getHead());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setHead(additionalData.m_130267_());
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    static class EntityAISearchAndEatMelons
    extends Goal {
        private final Mob parent;
        private final Item melon;
        private final Block melonblock;
        private int cooldown;
        private BlockPos.MutableBlockPos vertex = new BlockPos.MutableBlockPos();
        private boolean foundMelon = false;

        EntityAISearchAndEatMelons(Mob entity) {
            this.parent = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.melon = entity instanceof EntityGlisteringMelonGolem ? Items.f_42546_ : Items.f_42575_;
            this.melonblock = entity instanceof EntityGlisteringMelonGolem ? (Block)MelonMod.BLOCK_GLISTERING_MELON.get() : Blocks.f_50186_;
        }

        public boolean m_8036_() {
            return (Boolean)MelonMod.config.eats.get() != false && this.parent.m_21223_() < this.parent.m_21233_();
        }

        public void m_8041_() {
            this.cooldown = 0;
        }

        private boolean isMelon(ItemEntity item) {
            return this.isMelon(item.m_32055_());
        }

        private boolean isMelon(ItemStack item) {
            return this.isMelon(item.m_41720_());
        }

        private boolean isMelon(Item item) {
            return item == this.melon || item == this.melonblock.m_5456_();
        }

        public void m_8037_() {
            if (this.parent == null) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            int radius = 25;
            AABB area = new AABB(this.parent.m_20185_() - 25.0, this.parent.m_20186_() - 25.0, this.parent.m_20189_() - 25.0, this.parent.m_20185_() + 25.0, this.parent.m_20186_() + 25.0, this.parent.m_20189_() + 25.0);
            List items = this.parent.m_9236_().m_45976_(ItemEntity.class, area);
            for (ItemEntity item : items) {
                if (this.parent.m_21573_().m_26571_() && this.isMelon(item)) {
                    this.parent.m_21573_().m_5624_((Entity)item, 1.25);
                    this.parent.m_21563_().m_24960_((Entity)item, 30.0f, 30.0f);
                }
                if (this.cooldown > 0 || !item.m_6084_() || !this.isMelon(item) || !item.m_20191_().m_82381_(this.parent.m_20191_().m_82400_(1.0))) continue;
                boolean flag = item.m_32055_().m_41720_() == this.melonblock.m_5456_();
                item.m_32055_().m_41774_(1);
                this.parent.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
                this.parent.m_5634_(((Double)MelonMod.config.heal.get()).floatValue() * (float)(flag ? 9 : 1));
                this.cooldown = 30 + this.parent.m_217043_().m_188503_(40);
            }
            if (this.parent.m_21573_().m_26571_()) {
                this.foundMelon = false;
                block1: for (int x = -25; x < 25; ++x) {
                    for (int y = -25; y < 25; ++y) {
                        for (int z = -25; z < 25; ++z) {
                            BlockEntity te;
                            this.vertex.m_122190_((Vec3i)this.parent.m_20183_().m_7918_(x, y, z));
                            if (!this.parent.m_9236_().m_46805_((BlockPos)this.vertex) || (te = this.parent.m_9236_().m_7702_((BlockPos)this.vertex)) == null) continue;
                            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(cap -> {
                                for (int i = 0; i < cap.getSlots(); ++i) {
                                    if (!this.isMelon(cap.getStackInSlot(i))) continue;
                                    this.foundMelon = this.parent.m_20275_((double)this.vertex.m_123341_(), (double)this.vertex.m_123342_(), (double)this.vertex.m_123343_()) < 4.0 || this.parent.m_21573_().m_26519_((double)this.vertex.m_123341_(), (double)this.vertex.m_123342_(), (double)this.vertex.m_123343_(), 1.25);
                                    break;
                                }
                            });
                            if (this.foundMelon) break block1;
                        }
                    }
                }
            }
            if (this.foundMelon) {
                if (!this.parent.m_9236_().m_46805_((BlockPos)this.vertex)) {
                    this.parent.m_21573_().m_26573_();
                    this.foundMelon = false;
                    return;
                }
                BlockEntity te = this.parent.m_9236_().m_7702_((BlockPos)this.vertex);
                if (te == null || !te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).isPresent()) {
                    this.parent.m_21573_().m_26573_();
                    this.foundMelon = false;
                    return;
                }
                LazyOptional handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP);
                if (handler.isPresent()) {
                    handler.ifPresent(cap -> {
                        int i;
                        boolean valid = false;
                        for (i = 0; i < cap.getSlots(); ++i) {
                            if (!this.isMelon(cap.getStackInSlot(i))) continue;
                            valid = true;
                            break;
                        }
                        if (!valid) {
                            this.parent.m_21573_().m_26573_();
                            this.foundMelon = false;
                            return;
                        }
                        if (this.cooldown <= 0 && this.parent.m_20275_((double)this.vertex.m_123341_(), (double)this.vertex.m_123342_(), (double)this.vertex.m_123343_()) < 4.0) {
                            boolean flag = cap.getStackInSlot(i).m_41720_() == this.melonblock.m_5456_();
                            cap.getStackInSlot(i).m_41774_(1);
                            this.parent.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
                            this.parent.m_5634_(((Double)MelonMod.config.heal.get()).floatValue() * (float)(flag ? 9 : 1));
                            this.cooldown = 10 + this.parent.m_217043_().m_188503_(40);
                        }
                    });
                } else {
                    this.parent.m_21573_().m_26573_();
                    this.foundMelon = false;
                }
            }
        }
    }
}

