/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.melongolem.client.LayerMelonHead;
import tamaized.melongolem.common.EntityTinyMelonGolem;

@OnlyIn(value=Dist.CLIENT)
public class RenderMelonGolem<T extends Mob>
extends MobRenderer<T, SnowGolemModel<T>> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("melongolem", "textures/entity/golem.png");
    private static final ResourceLocation TEXTURES_GREY = new ResourceLocation("melongolem", "textures/entity/greygolem.png");
    private static final ResourceLocation TEXTURES_GLISTER = new ResourceLocation("melongolem", "textures/entity/glistening_melon_golem.png");
    private static final ResourceLocation TEXTURES_GLISTER_OVERLAY = new ResourceLocation("melongolem", "textures/entity/glistening_melon_golem_overlay.png");
    private static final ColorHack COLOR_STATE = new ColorHack();
    private final Type type;

    public RenderMelonGolem(EntityRendererProvider.Context renderManagerIn, Type type) {
        super(renderManagerIn, (EntityModel)new SnowGolemModel<T>(renderManagerIn.m_174023_(ModelLayers.f_171243_)){

            public void m_7695_(@Nonnull PoseStack stack, @Nonnull VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha) {
                super.m_7695_(stack, buffer, light, overlay, RenderMelonGolem.COLOR_STATE.red, RenderMelonGolem.COLOR_STATE.green, RenderMelonGolem.COLOR_STATE.blue, alpha);
            }
        }, type == Type.TINY ? 0.125f : 0.5f);
        this.m_115326_(new LayerMelonHead(this));
        if (type == Type.GLISTER) {
            this.m_115326_(new LayerMelonGlister(this));
        }
        this.type = type;
    }

    public void m_7392_(T entity, float rotation, float partialTicks, @Nonnull PoseStack stack, @Nonnull MultiBufferSource buffer, int light) {
        EntityTinyMelonGolem golem;
        stack.m_85836_();
        if (this.type == Type.TINY && (golem = (EntityTinyMelonGolem)entity).isEnabled()) {
            int color = golem.getColor();
            RenderMelonGolem.COLOR_STATE.red = (float)(color >> 16 & 0xFF) / 255.0f;
            RenderMelonGolem.COLOR_STATE.green = (float)(color >> 8 & 0xFF) / 255.0f;
            RenderMelonGolem.COLOR_STATE.blue = (float)(color & 0xFF) / 255.0f;
        }
        super.m_7392_(entity, rotation, partialTicks, stack, buffer, light);
        stack.m_85849_();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull T entity) {
        return entity instanceof EntityTinyMelonGolem && ((EntityTinyMelonGolem)entity).isEnabled() ? TEXTURES_GREY : (this.type == Type.GLISTER ? TEXTURES_GLISTER : TEXTURES);
    }

    protected void scale(T entity, PoseStack stack, float partialTicks) {
        if (this.type == Type.TINY) {
            stack.m_85841_(0.25f, 0.25f, 0.25f);
        }
    }

    public static enum Type {
        NORMAL,
        TINY,
        GLISTER;

    }

    class LayerMelonGlister<E extends T>
    extends RenderLayer<E, SnowGolemModel<E>> {
        public LayerMelonGlister(RenderLayerParent<E, SnowGolemModel<E>> p_i50926_1_) {
            super(p_i50926_1_);
        }

        public void render(@Nonnull PoseStack stack, @Nonnull MultiBufferSource buffer, int light, @Nonnull E entity, float limbSwing, float limbSwingAmount, float partialTicks, float rotation, float yawHead, float pitch) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110436_((ResourceLocation)TEXTURES_GLISTER_OVERLAY, (float)0.0f, (float)0.0f));
            stack.m_85836_();
            float s = 1.01f;
            stack.m_85841_(1.01f, 1.01f, 1.01f);
            ((SnowGolemModel)this.m_117386_()).m_7695_(stack, builder, 0xF000F0, LivingEntityRenderer.m_115338_(entity, (float)RenderMelonGolem.this.m_6931_(entity, partialTicks)), 1.0f, 1.0f, 1.0f, !RenderMelonGolem.this.m_5933_(entity) && !entity.m_20177_((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_)) ? 0.15f : 1.0f);
            stack.m_85849_();
        }
    }

    private static class ColorHack {
        private float red = 1.0f;
        private float green = 1.0f;
        private float blue = 1.0f;

        private ColorHack() {
        }
    }

    public static class Factory {
        public static RenderMelonGolem normal(EntityRendererProvider.Context renderManager) {
            return new RenderMelonGolem(renderManager, Type.NORMAL);
        }

        public static RenderMelonGolem tiny(EntityRendererProvider.Context renderManager) {
            return new RenderMelonGolem(renderManager, Type.TINY);
        }

        public static RenderMelonGolem glister(EntityRendererProvider.Context renderManager) {
            return new RenderMelonGolem(renderManager, Type.GLISTER);
        }
    }
}

