/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tamaized.melongolem.MelonConfig;
import tamaized.melongolem.client.MelonConfigScreen;
import tamaized.melongolem.common.EntityGlisteringMelonGolem;
import tamaized.melongolem.common.EntityMelonGolem;
import tamaized.melongolem.common.EntityMelonSlice;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.ItemMelonStick;
import tamaized.melongolem.network.DonatorHandler;
import tamaized.melongolem.network.NetworkMessages;

@Mod(value="melongolem")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MelonMod {
    public static final String MODID = "melongolem";
    public static MelonConfig config;
    public static MelonConfig.Client configClient;
    public static final SimpleChannel network;
    public static final Logger logger;
    private static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> attributes;
    private static final DeferredRegister<Item> ITEM_REGISTRY;
    private static final DeferredRegister<Block> BLOCK_REGISTRY;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTRY;
    public static final DeferredRegister<SoundEvent> SOUND_REGISTRY;
    public static final RegistryObject<Item> ITEM_MELON_STICK;
    public static final RegistryObject<Block> BLOCK_GLISTERING_MELON;
    public static final RegistryObject<BlockItem> ITEMBLOCK_GLISTERING_MELON;
    public static final RegistryObject<EntityType<? extends AbstractGolem>> ENTITY_TYPE_MELON_GOLEM;
    public static final RegistryObject<EntityType<? extends AbstractGolem>> ENTITY_TYPE_GLISTERING_MELON_GOLEM;
    public static final RegistryObject<EntityType<? extends EntityMelonSlice>> ENTITY_TYPE_MELON_SLICE;
    public static final RegistryObject<EntityType<? extends TamableAnimal>> ENTITY_TYPE_TINY_MELON_GOLEM;
    public static final RegistryObject<Item> ITEM_SPAWN_EGG_MELON_GOLEM;
    public static final RegistryObject<Item> ITEM_SPAWN_EGG_GLISTERING_MELON_GOLEM;
    public static final RegistryObject<SoundEvent> DADDY;

    public MelonMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEM_REGISTRY.register(modBus);
        BLOCK_REGISTRY.register(modBus);
        ENTITY_REGISTRY.register(modBus);
        SOUND_REGISTRY.register(modBus);
        Pair specPair = new ForgeConfigSpec.Builder().configure(MelonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        config = (MelonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(MelonConfig.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        configClient = (MelonConfig.Client)specPair.getLeft();
        DonatorHandler.start();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(MelonConfigScreen::new));
    }

    @SubscribeEvent
    public static void addStuffToTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42028_), (Object)new ItemStack((ItemLike)ITEMBLOCK_GLISTERING_MELON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42685_), (Object)new ItemStack((ItemLike)ITEM_MELON_STICK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42623_), (Object)new ItemStack((ItemLike)ITEM_SPAWN_EGG_MELON_GOLEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putBefore((Object)new ItemStack((ItemLike)Items.f_151061_), (Object)new ItemStack((ItemLike)ITEM_SPAWN_EGG_GLISTERING_MELON_GOLEM.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        attributes.forEach((type, attribute) -> event.put(type, ((AttributeSupplier.Builder)attribute.get()).m_22265_()));
    }

    private static <T extends LivingEntity> EntityType<T> assign(Class<T> entity, float w, float h, int range, int freq, boolean updates, MobCategory classification, Supplier<AttributeSupplier.Builder> attributes) {
        EntityType<T> type = MelonMod.assign(entity, w, h, range, freq, updates, classification);
        MelonMod.attributes.put(type, attributes);
        return type;
    }

    private static <T extends Entity> EntityType<T> assign(Class<T> entity, float w, float h, int range, int freq, boolean updates, MobCategory classification) {
        String name = entity.getSimpleName().toLowerCase();
        return EntityType.Builder.m_20704_((et, world) -> {
            try {
                return (Entity)entity.getConstructor(Level.class).newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }, (MobCategory)classification).setTrackingRange(range).setUpdateInterval(freq).setShouldReceiveVelocityUpdates(updates).m_20699_(w, h).m_20712_(name);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NetworkMessages.register(network);
    }

    @SubscribeEvent
    public static void init(FMLLoadCompleteEvent event) {
        MelonConfig.setupStabby();
        MelonConfig.setupColor();
    }

    static {
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, MODID)).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
        logger = LogManager.getLogger((String)MODID);
        attributes = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();
        ITEM_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        BLOCK_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        ENTITY_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)MODID);
        SOUND_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)MODID);
        ITEM_MELON_STICK = ITEM_REGISTRY.register("melonstick", () -> new ItemMelonStick(new Item.Properties()));
        BLOCK_GLISTERING_MELON = BLOCK_REGISTRY.register("glisteringmelonblock", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_).m_278166_(PushReaction.DESTROY).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60953_(state -> 4)));
        ITEMBLOCK_GLISTERING_MELON = ITEM_REGISTRY.register("glisteringmelonblock", () -> new BlockItem((Block)BLOCK_GLISTERING_MELON.get(), new Item.Properties().setNoRepair()));
        ENTITY_TYPE_MELON_GOLEM = ENTITY_REGISTRY.register("entitymelongolem", () -> MelonMod.assign(EntityMelonGolem.class, 0.7f, 1.9f, 128, 1, true, MobCategory.CREATURE, EntityMelonGolem::_registerAttributes));
        ENTITY_TYPE_GLISTERING_MELON_GOLEM = ENTITY_REGISTRY.register("entityglisteringmelongolem", () -> MelonMod.assign(EntityGlisteringMelonGolem.class, 0.7f, 1.9f, 128, 1, true, MobCategory.CREATURE, EntityMelonGolem::_registerAttributes));
        ENTITY_TYPE_MELON_SLICE = ENTITY_REGISTRY.register("entitymelonslice", () -> MelonMod.assign(EntityMelonSlice.class, 0.25f, 0.25f, 128, 1, true, MobCategory.MISC));
        ENTITY_TYPE_TINY_MELON_GOLEM = ENTITY_REGISTRY.register("entitytinymelongolem", () -> MelonMod.assign(EntityTinyMelonGolem.class, 0.175f, 0.475f, 128, 1, true, MobCategory.CREATURE, EntityMelonGolem::_registerAttributes));
        ITEM_SPAWN_EGG_MELON_GOLEM = ITEM_REGISTRY.register("melongolemspawnegg", () -> new ForgeSpawnEggItem(ENTITY_TYPE_MELON_GOLEM, 65280, 0, new Item.Properties()));
        ITEM_SPAWN_EGG_GLISTERING_MELON_GOLEM = ITEM_REGISTRY.register("glisteringmelongolemspawnegg", () -> new ForgeSpawnEggItem(ENTITY_TYPE_GLISTERING_MELON_GOLEM, 0xAAFF00, 0xFFCC00, new Item.Properties()));
        DADDY = SOUND_REGISTRY.register("melonmedaddy", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, "melonmedaddy")));
    }
}

