/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.melongolem.MelonMod;

@Mod.EventBusSubscriber(modid="melongolem")
public class MelonConfig {
    public static boolean dirty = true;
    public static Item stabItem = Items.f_42398_;
    public final DonatorSettings DONATOR_SETTINGS = new DonatorSettings();
    public ForgeConfigSpec.DoubleValue health;
    public ForgeConfigSpec.DoubleValue damage;
    public ForgeConfigSpec.DoubleValue glisterDamageAmp;
    public ForgeConfigSpec.BooleanValue hats;
    public ForgeConfigSpec.BooleanValue shear;
    public ForgeConfigSpec.BooleanValue eats;
    public ForgeConfigSpec.DoubleValue heal;
    public ForgeConfigSpec.ConfigValue<String> stabby;

    public MelonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Donator Settings").push("Donator Settings");
        this.DONATOR_SETTINGS.enable = builder.translation("Enable").comment("Enables donator settings for yourself").define("enable", true);
        this.DONATOR_SETTINGS.color = builder.translation("Color").comment("Sets the mini-golem color for yourself (0xRRGGBB)").define("color", (Object)"0xFFFFFF");
        builder.pop();
        this.health = builder.translation("Base Golem Health").comment("").defineInRange("health", 8.0, 0.5, 3.4028234663852886E38);
        this.damage = builder.translation("Melon Slice Damage").comment("").defineInRange("damage", 4.0, 0.5, 3.4028234663852886E38);
        this.glisterDamageAmp = builder.translation("Glistering Melon Slice Damage Amplification").comment("").defineInRange("damage", 1.5, 1.0, 3.4028234663852886E38);
        this.hats = builder.translation("Enable Golem Block Heads").comment("Enables the placement of blocks on golems' heads").define("hats", true);
        this.shear = builder.translation("Shears Spawn Block").comment("If disabled, shearing a golem destroys the block").define("shear", true);
        this.eats = builder.translation("Golem Eats Melons").comment("If enabled, golems will hunt for nearby melon slices to replensih health").define("eats", true);
        this.heal = builder.translation("Melon Heal Amount").comment("The amount a golem will heal for after consuming a melon slice").defineInRange("heal", 1.0, 0.5, 3.4028234663852886E38);
        this.stabby = builder.translation("Stabby Life Item").comment("The item used to spawn a melon golem\n\n[domain:name] domain will default to `minecraft`").define("stabby", (Object)Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)Items.f_42398_)).m_135815_());
    }

    public static void setupStabby() {
        Item item;
        String[] split = ((String)MelonMod.config.stabby.get()).split(":");
        String domain = "minecraft";
        String regname = split[0];
        if (split.length > 1) {
            domain = split[0];
            regname = split[1];
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(domain, regname))) == null || item instanceof AirItem) {
            return;
        }
        stabItem = item;
    }

    public static boolean compareStabbyItem(ItemStack stack) {
        return stack.m_41720_() == stabItem;
    }

    public static void setupColor() {
        try {
            MelonMod.config.DONATOR_SETTINGS.colorint = Integer.decode((String)MelonMod.config.DONATOR_SETTINGS.color.get());
        }
        catch (Throwable e) {
            MelonMod.config.DONATOR_SETTINGS.color.set((Object)"0xFFFFFF");
            MelonMod.config.DONATOR_SETTINGS.color.save();
            MelonMod.config.DONATOR_SETTINGS.colorint = 0xFFFFFF;
        }
        dirty = true;
    }

    public static class DonatorSettings {
        public ForgeConfigSpec.BooleanValue enable;
        public ForgeConfigSpec.ConfigValue<String> color;
        public int colorint = 0xFFFFFF;
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue tehnutMode;
        public ForgeConfigSpec.BooleanValue tts;

        public Client(ForgeConfigSpec.Builder builder) {
            this.tehnutMode = builder.translation("TehNut Mode").comment(":^)").define("tehnutMode", false);
            this.tts = builder.translation("TTS Signs").comment("When enabled, written signs on a golem's head will play text to speech audio").define("tts", true);
        }
    }
}

