/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.strainers.util.ModTags;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StrainerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final double outputChance;
    private final double chanceIncreasePerTier;
    private final NonNullList<Ingredient> inputItem;
    private final int meshTier;
    private final int duration;
    private final String blockAbove;
    private final String fluidAbove;

    public StrainerRecipe(ResourceLocation id, ItemStack output, double outputChance, double chanceIncreasePerTier, NonNullList<Ingredient> inputItem, int meshTier, int duration, String blockAbove, String fluidAbove) {
        this.id = id;
        this.output = output;
        this.outputChance = outputChance;
        this.chanceIncreasePerTier = chanceIncreasePerTier;
        this.inputItem = inputItem;
        this.meshTier = meshTier;
        this.duration = duration;
        this.blockAbove = blockAbove;
        this.fluidAbove = fluidAbove;
    }

    public boolean matches(@NotNull SimpleContainer pContainer, @NotNull Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        if (((Ingredient)this.inputItem.get(0)).test(pContainer.m_8020_(2))) {
            ItemStack meshItem = pContainer.m_8020_(1);
            return switch (this.meshTier) {
                case 1 -> {
                    if (meshItem.m_204117_(ModTags.Items.TIER_1_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_2_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_3_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (meshItem.m_204117_(ModTags.Items.TIER_2_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_3_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (meshItem.m_204117_(ModTags.Items.TIER_3_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES)) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
                default -> false;
            };
        }
        return false;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ItemStack assemble(SimpleContainer p_44001_, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public double getOutputChance() {
        return this.outputChance;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public double getChanceIncreasePerTier() {
        return this.chanceIncreasePerTier;
    }

    public int getMeshTier() {
        return this.meshTier;
    }

    public int getDuration() {
        return this.duration;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItem;
    }

    public String getBlockAbove() {
        return this.blockAbove;
    }

    public String getFluidAbove() {
        return this.fluidAbove;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<StrainerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("strainers", "strainer");

        public StrainerRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = json.has("output") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output")) : ItemStack.f_41583_;
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            double chance = GsonHelper.m_144784_((JsonObject)json, (String)"chance");
            double chanceIncreasePerTier = GsonHelper.m_144784_((JsonObject)json, (String)"chanceIncreasePerTier");
            int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)120);
            int minMeshTier = GsonHelper.m_13927_((JsonObject)json, (String)"minMeshTier");
            String blockAbove = GsonHelper.m_13851_((JsonObject)json, (String)"aboveBlock", (String)"");
            String fluidAbove = GsonHelper.m_13851_((JsonObject)json, (String)"aboveFluid", (String)"");
            return new StrainerRecipe(id, output, chance, chanceIncreasePerTier, (NonNullList<Ingredient>)inputs, minMeshTier, duration, blockAbove, fluidAbove);
        }

        public StrainerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ItemStack output = buf.m_130267_();
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            double chance = buf.readDouble();
            double chanceIncreasePerTier = buf.readDouble();
            int duration = buf.readInt();
            int minMeshTier = buf.readInt();
            String blockAbove = buf.m_130136_(Short.MAX_VALUE);
            String fluidAbove = buf.m_130136_(Short.MAX_VALUE);
            return new StrainerRecipe(id, output, chance, chanceIncreasePerTier, (NonNullList<Ingredient>)inputs, minMeshTier, duration, blockAbove, fluidAbove);
        }

        public void toNetwork(FriendlyByteBuf buf, StrainerRecipe recipe) {
            buf.m_130055_(recipe.getOutput());
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeDouble(recipe.getOutputChance());
            buf.writeDouble(recipe.getChanceIncreasePerTier());
            buf.writeInt(recipe.getDuration());
            buf.writeInt(recipe.getMeshTier());
            buf.m_130072_(recipe.getBlockAbove(), Short.MAX_VALUE);
            buf.m_130072_(recipe.getFluidAbove(), Short.MAX_VALUE);
        }
    }

    public static class Type
    implements RecipeType<StrainerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "strainer";

        private Type() {
        }
    }
}

