/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.integration.jei.JEIStrainersPlugin;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import com.benbenlaw.strainers.util.ModTags;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class StrainerRecipeCategory
implements IRecipeCategory<StrainerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("strainers", "strainer");
    public static final ResourceLocation TEXTURE = new ResourceLocation("strainers", "textures/gui/jei_strainer.png");
    static final RecipeType<StrainerRecipe> RECIPE_TYPE = RecipeType.create((String)"strainers", (String)"strainer", StrainerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public StrainerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 180, 40);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.WOODEN_STRAINER.get()));
    }

    public RecipeType<StrainerRecipe> getRecipeType() {
        return JEIStrainersPlugin.STRAINER;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Strainers");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StrainerRecipe recipe, IFocusGroup focusGroup) {
        Block blockInRecipe;
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 23).addIngredients((Ingredient)recipe.m_7527_().get(0));
        if (recipe.getMeshTier() == 1) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 23).addIngredients(Ingredient.m_204132_(ModTags.Items.TIER_1_MESHES))).addTooltipCallback(this.tier1Mesh());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 161, 23).addItemStack(recipe.getOutput())).addTooltipCallback(this.tier1MeshStats(recipe));
        }
        if (recipe.getMeshTier() == 2) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 23).addIngredients(Ingredient.m_204132_(ModTags.Items.TIER_2_MESHES))).addTooltipCallback(this.tier2Mesh());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 161, 23).addItemStack(recipe.getOutput())).addTooltipCallback(this.tier2MeshStats(recipe));
        }
        if (recipe.getMeshTier() == 3) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 23).addIngredients(Ingredient.m_204132_(ModTags.Items.TIER_3_MESHES))).addTooltipCallback(this.tier3Mesh());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 161, 23).addItemStack(recipe.getOutput())).addTooltipCallback(this.tier3MeshStats(recipe));
        }
        if (recipe.getMeshTier() == 4) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 23).addIngredients(Ingredient.m_204132_(ModTags.Items.TIER_4_MESHES))).addTooltipCallback(this.tier4Mesh());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 161, 23).addItemStack(recipe.getOutput())).addTooltipCallback(this.tier4MeshStats(recipe));
        }
        if (recipe.getMeshTier() == 5) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 23).addIngredients(Ingredient.m_204132_(ModTags.Items.TIER_5_MESHES))).addTooltipCallback(this.tier5Mesh());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 161, 23).addItemStack(recipe.getOutput())).addTooltipCallback(this.tier5MeshStats(recipe));
        }
        if (recipe.getMeshTier() == 6) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 23).addIngredients(Ingredient.m_204132_(ModTags.Items.TIER_6_MESHES))).addTooltipCallback(this.tier6Mesh());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 161, 23).addItemStack(recipe.getOutput())).addTooltipCallback(this.tier6MeshStats(recipe));
        }
        if (!(blockInRecipe = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(recipe.getBlockAbove()))).m_5456_().equals(Items.f_41852_)) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 4, 3).addItemStack(blockInRecipe.m_5456_().m_7968_())).addTooltipCallback(this.getPlaceAbove());
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(recipe.getFluidAbove()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 4, 3).addFluidStack(fluid, 1000L)).setFluidRenderer(1000L, true, 16, 16);
    }

    private IRecipeSlotTooltipCallback getPlaceAbove() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Place above the strainer"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier1Mesh() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Minimum Mesh Tier 1"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier2Mesh() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Minimum Mesh Tier 2"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier3Mesh() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Minimum Mesh Tier 3"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier4Mesh() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Minimum Mesh Tier 4"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier5Mesh() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Minimum Mesh Tier 5"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier6Mesh() {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)"Minimum Mesh Tier 6"));
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier1MeshStats(StrainerRecipe recipe) {
        return (chance, addTooltip) -> {
            if (!Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Default Chance: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)"Press \u00a7eSHIFT\u00a7r for more Information"));
            }
            if (Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Tier 1 Mesh: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 2 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 1.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 3 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 2.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 4 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 3.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 5 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 4.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 6 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 5.0 + recipe.getOutputChance()) * 100.0) + "%")));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier2MeshStats(StrainerRecipe recipe) {
        return (chance, addTooltip) -> {
            if (!Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Default Chance: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)"Press \u00a7eSHIFT\u00a7r for more Information"));
            }
            if (Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Tier 2 Mesh: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 3 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 1.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 4 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 2.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 5 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 3.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 6 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 4.0 + recipe.getOutputChance()) * 100.0) + "%")));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier3MeshStats(StrainerRecipe recipe) {
        return (chance, addTooltip) -> {
            if (!Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Default Chance: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)"Press \u00a7eSHIFT\u00a7r for more Information"));
            }
            if (Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Tier 3 Mesh: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 4 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 1.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 5 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 2.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 6 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 3.0 + recipe.getOutputChance()) * 100.0) + "%")));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier4MeshStats(StrainerRecipe recipe) {
        return (chance, addTooltip) -> {
            if (!Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Default Chance: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)"Press \u00a7eSHIFT\u00a7r for more Information"));
            }
            if (Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Tier 4 Mesh: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 5 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 1.0 + recipe.getOutputChance()) * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 6 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 2.0 + recipe.getOutputChance()) * 100.0) + "%")));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier5MeshStats(StrainerRecipe recipe) {
        return (chance, addTooltip) -> {
            if (!Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Default Chance: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)"Press \u00a7eSHIFT\u00a7r for more Information"));
            }
            if (Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Tier 5 Mesh: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)("Tier 6 Mesh: " + (int)((recipe.getChanceIncreasePerTier() * 1.0 + recipe.getOutputChance()) * 100.0) + "%")));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback tier6MeshStats(StrainerRecipe recipe) {
        return (chance, addTooltip) -> {
            if (!Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Default Chance: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
                addTooltip.add(Component.m_237113_((String)"Press \u00a7eSHIFT\u00a7r for more Information"));
            }
            if (Screen.m_96638_()) {
                addTooltip.add(Component.m_237113_((String)("Tier 6 Mesh: " + (int)(recipe.getOutputChance() * 100.0) + "%")));
            }
        };
    }

    public void draw(StrainerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!recipe.getBlockAbove().isEmpty()) {
            guiGraphics.m_280430_(minecraft.f_91062_.self(), (Component)Component.m_237115_((String)"jei.strainer.place_block"), 25, 6, Color.WHITE.getRGB());
        }
        if (!recipe.getFluidAbove().isEmpty()) {
            guiGraphics.m_280430_(minecraft.f_91062_.self(), (Component)Component.m_237115_((String)"jei.strainer.place_fluid"), 25, 6, Color.WHITE.getRGB());
        }
        int duration = recipe.getDuration();
        guiGraphics.m_280430_(minecraft.f_91062_.self(), (Component)Component.m_237113_((String)(duration + " ticks")), 77, 26, Color.WHITE.getRGB());
    }
}

