/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity;

import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.networking.ModMessages;
import com.benbenlaw.strainers.networking.packets.PacketSyncFluidToClient;
import com.benbenlaw.strainers.util.IFluidHandlingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrainerTankBlockEntity
extends BlockEntity
implements IFluidHandlingBlockEntity {
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    public final FluidTank FLUID_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            StrainerTankBlockEntity.this.m_6596_();
            assert (StrainerTankBlockEntity.this.f_58857_ != null);
            if (!StrainerTankBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncFluidToClient(this.fluid, StrainerTankBlockEntity.this.f_58858_));
            }
        }
    };

    @Override
    public void setFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public void getFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.FLUID_TANK.getFluid();
    }

    public StrainerTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STRAINER_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_TANK);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidHandler.invalidate();
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        tag = this.FLUID_TANK.writeToNBT(tag);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.FLUID_TANK.readFromNBT(tag);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.FLUID_TANK);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }
}

