/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.wind;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.wind.generator.OpenSimplexNoise;
import fuzs.hangglider.world.item.GliderItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WindHelper {
    private static final OpenSimplexNoise NOISE_GENERATOR = new OpenSimplexNoise();

    public static void applyWind(Player player, ItemStack glider) {
        ServerConfig config = (ServerConfig)HangGlider.CONFIG.get(ServerConfig.class);
        if (!config.wind.allowWind) {
            return;
        }
        double windGustSize = config.wind.gustSize;
        double windFrequency = config.wind.frequency;
        double windRainingMultiplier = config.wind.rainingMultiplier;
        double windSpeedMultiplier = config.wind.speedMultiplier;
        double windHeightMultiplier = config.wind.heightMultiplier;
        double windOverallPower = config.wind.overallPower;
        double noise = NOISE_GENERATOR.eval(player.m_20185_() / windGustSize, player.m_20189_() / windGustSize);
        double d = player.m_9236_().m_46471_() ? windRainingMultiplier * windFrequency : windFrequency;
        double velocity = Math.sqrt(Math.pow(player.m_20184_().f_82479_, 2.0) + Math.pow(player.m_20184_().f_82481_, 2.0));
        double speedStabilized = (noise *= d) * 1.0 / (velocity * windSpeedMultiplier + 1.0);
        double height = player.m_20186_() < 256.0 ? player.m_20186_() / 256.0 * windHeightMultiplier : windHeightMultiplier;
        double wind = speedStabilized * height;
        double additionalDamagePercentage = glider.m_41768_() ? config.wind.durabilityMultiplier * ((double)glider.m_41773_() / (double)glider.m_41776_()) : 0.0;
        wind *= 1.0 + additionalDamagePercentage;
        wind *= windOverallPower;
        player.m_146922_((float)((double)player.m_146908_() + (wind *= ((GliderItem)glider.m_41720_()).getGliderMaterialSettings().windModifier)));
    }
}

