/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block;

import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotationHandler;
import com.hrznstudio.titanium.block.tile.BasicTile;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RotatableBlock<T extends BasicTile<T>>
extends BasicTileBlock<T> {
    public static final DirectionProperty FACING_ALL = DirectionProperty.m_61549_((String)"facing", (Direction[])Direction.values());
    public static final DirectionProperty FACING_HORIZONTAL = DirectionProperty.m_61546_((String)"subfacing", (Predicate)Direction.Plane.HORIZONTAL);

    public RotatableBlock(String name, BlockBehaviour.Properties properties, Class<T> tileClass) {
        super(name, properties, tileClass);
    }

    @Nonnull
    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        return this.getRotationType().getHandler().getStateForPlacement(this, p_196258_1_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        if (this.getRotationType().getProperties() != null) {
            p_206840_1_.m_61104_((Property[])this.getRotationType().getProperties());
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (this.getRotationType().getProperties().length > 0) {
            return (BlockState)state.m_61124_((Property)this.getRotationType().getProperties()[0], (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)this.getRotationType().getProperties()[0])));
        }
        return super.m_6843_(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (this.getRotationType().getProperties().length > 0) {
            return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)this.getRotationType().getProperties()[0])));
        }
        return super.m_6943_(state, mirrorIn);
    }

    public static enum RotationType {
        NONE((block, context) -> block.m_49966_(), new DirectionProperty[0]),
        FOUR_WAY((block, context) -> (BlockState)block.m_49966_().m_61124_((Property)FACING_HORIZONTAL, (Comparable)context.m_8125_().m_122424_()), FACING_HORIZONTAL),
        SIX_WAY((block, context) -> (BlockState)block.m_49966_().m_61124_((Property)FACING_ALL, (Comparable)context.m_7820_().m_122424_()), FACING_ALL),
        TWENTY_FOUR_WAY((block, context) -> (BlockState)block.m_49966_().m_61124_((Property)FACING_ALL, (Comparable)context.m_7820_()), FACING_ALL, FACING_HORIZONTAL);

        private final RotationHandler handler;
        private final DirectionProperty[] properties;

        private RotationType(RotationHandler handler, DirectionProperty ... properties) {
            this.handler = handler;
            this.properties = properties;
        }

        public RotationHandler getHandler() {
            return this.handler;
        }

        public DirectionProperty[] getProperties() {
            return this.properties;
        }
    }
}

