/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.entity.custom.ItemRepairerBlockEntity;
import com.benbenlaw.opolisutilities.screen.ModMenuTypes;
import com.benbenlaw.opolisutilities.screen.slot.utils.BlacklistTagInputSlot;
import com.benbenlaw.opolisutilities.screen.slot.utils.ModResultSlot;
import com.benbenlaw.opolisutilities.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class ItemRepairerMenu
extends AbstractContainerMenu {
    public final ItemRepairerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public ItemRepairerMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public ItemRepairerMenu(int containerID, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.ITEM_REPAIRER_MENU.get(), containerID);
        ItemRepairerMenu.m_38869_((Container)inventory, (int)2);
        this.blockEntity = (ItemRepairerBlockEntity)entity;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new BlacklistTagInputSlot((IItemHandler)handler, 0, 80, 18, ModTags.Items.BANNED_IN_ITEM_REPAIRER, 1));
            this.m_38897_((Slot)new ModResultSlot((IItemHandler)handler, 1, 80, 60));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getScaledProgress(Level world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ItemRepairerBlockEntity) {
            ItemRepairerBlockEntity itemRepairer = (ItemRepairerBlockEntity)tileEntity;
            int progress = this.data.m_6413_(0);
            int maxProgress = this.data.m_6413_(1);
            int progressArrowSize = 26;
            return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
        }
        return 0;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 38, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 38) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return ItemRepairerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.ITEM_REPAIRER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 144));
        }
    }
}

