/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen;

import com.benbenlaw.opolisutilities.recipe.CatalogueRecipe;
import com.benbenlaw.opolisutilities.screen.CatalogueMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class CatalogueScreen
extends AbstractContainerScreen<CatalogueMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("opolisutilities", "textures/gui/shop_inventory.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 18;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 48;
    private static final int RECIPES_Y = 23;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private EditBox searchBar;
    private int selectedRecipeIndex = -1;
    private List<CatalogueRecipe> filteredRecipes;

    public CatalogueScreen(CatalogueMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        pMenu.registerUpdateListener(this::containerChanged);
        this.f_97729_ = 4;
        this.f_97728_ = 4;
        this.f_97731_ = 100000;
        this.f_97730_ = 9;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_96547_ = this.getMinecraft().f_91062_;
        this.searchBar = new EditBox(this.f_96547_, this.f_96543_ / 2 - 21, this.f_96544_ / 2 - 77, 100, 14, (Component)Component.m_237113_((String)"")){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                boolean result = super.m_6375_(mouseX, mouseY, button);
                if (button == 1 && this.m_5953_(mouseX, mouseY)) {
                    this.m_94144_("");
                    return true;
                }
                this.m_93692_(result);
                return result;
            }
        };
        this.searchBar.m_94199_(50);
        this.m_7787_((GuiEventListener)this.searchBar);
        this.filteredRecipes = ((CatalogueMenu)this.f_97732_).getRecipes();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        this.searchBar.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private void updateFilteredRecipes() {
        String searchQuery = this.searchBar.m_94155_().toLowerCase();
        this.filteredRecipes = searchQuery.isEmpty() ? ((CatalogueMenu)this.f_97732_).getRecipes() : ((CatalogueMenu)this.f_97732_).getRecipes().stream().filter(recipe -> recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41786_().getString().toLowerCase().contains(searchQuery)).collect(Collectors.toList());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.m_7933_(keyCode, scanCode, modifiers) || this.searchBar.m_94204_()) {
            String searchQuery = this.searchBar.m_94155_().toLowerCase();
            this.filteredRecipes = searchQuery.isEmpty() ? ((CatalogueMenu)this.f_97732_).getRecipes() : ((CatalogueMenu)this.f_97732_).getRecipes().stream().filter(recipe -> recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41786_().getString().toLowerCase().contains(searchQuery)).collect(Collectors.toList());
            this.startIndex = 0;
            this.selectedRecipeIndex = -1;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char charTyped, int keyCode) {
        if (this.searchBar.m_5534_(charTyped, keyCode)) {
            return true;
        }
        return super.m_5534_(charTyped, keyCode);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float pPartialTick, int pX, int pY) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(39.0f * this.scrollOffs);
        guiGraphics.m_280218_(TEXTURE, i + 123, j + 26 + k, 220 + (!this.isScrollBarActive() ? 24 : (this.scrolling ? 12 : 0)), 0, 12, 15);
        int l = this.f_97735_ + 48;
        int i1 = this.f_97736_ + 23;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, pX, pY, l, i1, j1, false);
        this.renderRecipes(guiGraphics, l, i1, j1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!((CatalogueMenu)this.f_97732_).resultContainer.m_7983_()) {
            guiGraphics.m_280218_(TEXTURE, i + 146, j + 46, 211, 0, 8, 11);
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int pX, int pY) {
        boolean shouldRenderTooltips;
        super.m_280072_(guiGraphics, pX, pY);
        boolean searchBarFocused = this.searchBar.m_93696_();
        boolean bl = shouldRenderTooltips = this.displayRecipes || searchBarFocused;
        if (shouldRenderTooltips) {
            int i = this.f_97735_ + 48;
            int j = this.f_97736_ + 23;
            int k = this.startIndex + 12;
            List<CatalogueRecipe> list = searchBarFocused ? this.filteredRecipes : ((CatalogueMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < list.size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 18 + 2;
                int k1 = j + i1 / 4 * 18 + 2;
                if (pX < j1 || pX >= j1 + 18 || pY < k1 || pY >= k1 + 18) continue;
                CatalogueRecipe recipe = list.get(l);
                ItemStack result = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
                assert (Minecraft.m_91087_().f_91073_ != null);
                guiGraphics.m_280153_(this.f_96547_, result, pX, pY);
                if (!searchBarFocused) {
                    this.selectedRecipeIndex = ((CatalogueMenu)this.f_97732_).getRecipes().indexOf((Object)recipe);
                }
                return;
            }
        }
        if (CatalogueScreen.isHovering(pX, pY, this.f_97735_ + 142, this.f_97736_ + 32, 16.0, 16.0)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"Price"), pX, pY);
        }
    }

    public static boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void renderButtons(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int pX, int pY, int pLastVisibleElementIndex, boolean overlay) {
        List<CatalogueRecipe> list = ((CatalogueMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < list.size(); ++i) {
            int xOffset;
            int j = i - this.startIndex;
            int k = pX + j % 4 * 18;
            int l = j / 4;
            int i1 = pY + l * 18 + 2;
            int j1 = 0;
            int n = xOffset = overlay ? 22 : 0;
            if (i >= this.filteredRecipes.size() && !this.searchBar.m_94155_().isEmpty()) continue;
            if (i == ((CatalogueMenu)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 22;
            } else if (pMouseX >= k + 2 && pMouseY >= i1 + 2 && pMouseX < k + 2 + 18 && pMouseY < i1 + 2 + 18) {
                j1 += 44;
            }
            guiGraphics.m_280168_();
            if (overlay) {
                guiGraphics.m_280168_().m_252880_(0.0f, 50.0f, 100.0f);
            }
            guiGraphics.m_280218_(TEXTURE, k, i1 - 1, xOffset, 122 + j1 + 50, 22, 22);
            guiGraphics.m_280168_();
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int pLeft, int pTop, int pRecipeIndexOffsetMax) {
        List<CatalogueRecipe> list = ((CatalogueMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < pRecipeIndexOffsetMax && i < list.size(); ++i) {
            int j = i - this.startIndex;
            int k = pLeft + j % 4 * 18 + 3;
            int l = j / 4;
            int i1 = pTop + l * 18 + 4;
            if (i >= this.filteredRecipes.size() && !this.searchBar.m_94155_().isEmpty()) continue;
            CatalogueRecipe recipe = this.searchBar.m_94155_().isEmpty() ? list.get(i) : this.filteredRecipes.get(i);
            ItemStack result = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
            guiGraphics.m_280480_(result, k, i1);
            guiGraphics.m_280370_(this.f_96547_, result, k, i1);
        }
        if (((CatalogueMenu)this.f_97732_).getSelectedRecipeIndex() != -1 && ((CatalogueMenu)this.f_97732_).getRecipes().size() >= ((CatalogueMenu)this.f_97732_).getSelectedRecipeIndex() + 1) {
            CatalogueRecipe recipe = ((CatalogueMenu)this.f_97732_).getRecipes().get(((CatalogueMenu)this.f_97732_).getSelectedRecipeIndex());
            ItemStack stack = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0];
            stack.m_41764_(recipe.itemInCount);
            guiGraphics.m_280480_(stack, this.f_97735_ + 142, this.f_97736_ + 32);
            guiGraphics.m_280370_(this.f_96547_, stack, this.f_97735_ + 142, this.f_97736_ + 32);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.searchBar.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 48;
            int j = this.f_97736_ + 23;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int recipeIndex;
                int i1 = l - this.startIndex;
                double d0 = pMouseX - (double)(i + i1 % 4 * 18 + 2);
                double d1 = pMouseY - (double)(j + i1 / 4 * 18 + 3);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 18.0) || !(d1 < 18.0) || (recipeIndex = this.startIndex + i1) < 0 || recipeIndex >= this.filteredRecipes.size()) continue;
                CatalogueRecipe recipe = this.filteredRecipes.get(recipeIndex);
                int originalIndex = ((CatalogueMenu)this.f_97732_).getRecipes().indexOf((Object)recipe);
                if (originalIndex < 0) continue;
                assert (Minecraft.m_91087_().f_91073_ != null);
                ItemStack result = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
                if (result.m_41619_()) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                assert (Objects.requireNonNull(this.f_96541_).f_91072_ != null);
                assert (this.f_96541_.f_91072_ != null);
                this.f_96541_.f_91072_.m_105208_(((CatalogueMenu)this.f_97732_).f_38840_, originalIndex);
                this.selectedRecipeIndex = originalIndex;
                this.searchBar.m_94144_("");
                return true;
            }
            i = this.f_97735_ + 123;
            j = this.f_97736_ + 26;
            if (pMouseX >= (double)i && pMouseX < (double)(i + 12) && pMouseY >= (double)j && pMouseY < (double)(j + 54)) {
                if (this.isScrollBarActive()) {
                    this.scrolling = true;
                    i = this.f_97736_ + 26;
                    j = i + 54;
                    this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
                    this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
                    this.startIndex = Math.max(0, (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4);
                } else {
                    this.scrollOffs = 0.0f;
                    this.startIndex = 0;
                }
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 26;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((CatalogueMenu)this.f_97732_).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((CatalogueMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((CatalogueMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updateFilteredRecipes();
    }
}

