/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.item.custom.WalletItem;
import com.benbenlaw.opolisutilities.recipe.CatalogueRecipe;
import com.benbenlaw.opolisutilities.screen.ModMenuTypes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CatalogueMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<CatalogueRecipe> recipes = Lists.newArrayList();
    private CatalogueRecipe lastUsedRecipe = null;
    private int recipesSize = 0;
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack lastNonAirInput = ItemStack.f_41583_;
    private ItemStack lastInput = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            CatalogueMenu.this.m_6199_((Container)this);
            CatalogueMenu.this.slotUpdateListener.run();
        }
    };
    public final ResultContainer resultContainer = new ResultContainer();

    public CatalogueMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public CatalogueMenu(int pContainerId, Inventory pPlayerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)ModMenuTypes.CATALOGUE_MENU.get(), pContainerId);
        int i;
        this.access = pAccess;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 26, 44));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 142, 56){

            public boolean m_5857_(@NotNull ItemStack p_40362_) {
                return false;
            }

            public boolean m_8010_(@NotNull Player pPlayer) {
                if (CatalogueMenu.this.selectedRecipeIndex.m_6501_() == -1) {
                    return false;
                }
                if (CatalogueMenu.this.recipes.isEmpty()) {
                    return false;
                }
                if (CatalogueMenu.this.recipes.size() < CatalogueMenu.this.selectedRecipeIndex.m_6501_()) {
                    return false;
                }
                return super.m_8010_(pPlayer);
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                CatalogueMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack input = CatalogueMenu.this.inputSlot.m_7993_();
                Item item = input.m_41720_();
                if (item instanceof WalletItem) {
                    WalletItem walletItem = (WalletItem)item;
                    CatalogueRecipe recipe = CatalogueMenu.this.recipes.get(CatalogueMenu.this.selectedRecipeIndex.m_6501_());
                    Item rItem = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41720_();
                    if (!CatalogueMenu.this.level.f_46443_) {
                        walletItem.extractCurrency(input, rItem, recipe.itemInCount);
                    }
                    CatalogueMenu.this.inputSlot.m_6654_();
                    CatalogueMenu.this.setupResultSlot();
                } else {
                    if (!CatalogueMenu.this.level.f_46443_) {
                        input.m_41774_(CatalogueMenu.this.recipes.get((int)CatalogueMenu.this.selectedRecipeIndex.m_6501_()).itemInCount);
                    }
                    CatalogueMenu.this.inputSlot.m_6654_();
                    CatalogueMenu.this.setupResultSlot();
                }
                pAccess.m_39292_((p_40364_, p_40365_) -> {
                    long l = p_40364_.m_46467_();
                    if (CatalogueMenu.this.lastSoundTime != l) {
                        p_40364_.m_5594_(null, p_40365_, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.4f, 1.0f);
                        CatalogueMenu.this.lastSoundTime = l;
                    }
                });
                CatalogueMenu.this.m_6199_(CatalogueMenu.this.container);
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(CatalogueMenu.this.inputSlot.m_7993_());
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)pPlayerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)pPlayerInventory, i, 8 + i * 18, 144));
        }
        this.m_38895_(this.selectedRecipeIndex);
        this.selectedRecipeIndex.m_6422_(-1);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<CatalogueRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return CatalogueMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.CATALOGUE.get()));
    }

    public boolean m_6366_(@NotNull Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void m_6199_(@NotNull Container pInventory) {
        ItemStack itemstack = this.inputSlot.m_7993_().m_41777_();
        this.setupRecipeList(pInventory, itemstack);
        this.input = itemstack.m_41777_();
    }

    private void setupRecipeList(Container pContainer, ItemStack pStack) {
        this.recipes = new ArrayList<CatalogueRecipe>();
        if (!this.input.m_150930_(pStack.m_41720_())) {
            if (!(this.input.m_150930_(Items.f_41852_) || this.input.m_150930_(this.lastInput.m_41720_()) || this.lastInput.m_150930_(Items.f_41852_))) {
                this.selectedRecipeIndex.m_6422_(-1);
            }
            if (!this.input.m_150930_(this.lastInput.m_41720_())) {
                this.lastInput = this.input;
            }
        }
        if (!pStack.m_41619_()) {
            Item item = pStack.m_41720_();
            if (item instanceof WalletItem) {
                WalletItem walletItem = (WalletItem)item;
                this.recipes = this.level.m_7465_().m_44013_((RecipeType)CatalogueRecipe.Type.INSTANCE).stream().filter(recipe -> {
                    Item rItem = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41720_();
                    return walletItem.getCurrencyStored(pStack, rItem) >= recipe.itemInCount;
                }).toList();
            } else {
                this.recipes = this.level.m_7465_().m_44056_((RecipeType)CatalogueRecipe.Type.INSTANCE, pContainer, this.level);
            }
        }
        if (this.recipesSize != this.recipes.size() && this.selectedRecipeIndex.m_6501_() != -1) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                if (this.recipes.get(i) != this.lastUsedRecipe) continue;
                this.selectedRecipeIndex.m_6422_(i);
                break;
            }
        }
        this.recipes = this.recipes.stream().sorted(Comparator.comparing(r -> r.m_6423_().toString())).toList();
        this.recipesSize = this.recipes.size();
        if (!this.input.m_150930_(pStack.m_41720_()) || pStack.m_41613_() != this.input.m_41613_()) {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
            if (this.lastInput.m_150930_(Items.f_41852_)) {
                this.setupResultSlot();
            }
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            CatalogueRecipe catalogueRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            this.resultContainer.m_6029_((Recipe)catalogueRecipe);
            this.lastUsedRecipe = catalogueRecipe;
            this.resultSlot.m_5852_(catalogueRecipe.m_5874_(this.container, this.level.m_9598_()));
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.lastNonAirInput = this.input;
        this.m_38946_();
    }

    public int getTotalWalletCurrency(ItemStack wallet, Item item) {
        Item item2 = wallet.m_41720_();
        if (item2 instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item2;
            return walletItem.getCurrencyStored(wallet, item);
        }
        return 0;
    }

    public boolean isWallet(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.WALLET.get());
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return (MenuType)ModMenuTypes.CATALOGUE_MENU.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean m_5882_(@NotNull ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultContainer && super.m_5882_(pStack, pSlot);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                item.m_7836_(itemstack1, pPlayer.m_9236_(), pPlayer);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)CatalogueRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (pIndex >= 2 && pIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : pIndex >= 29 && pIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player pPlayer) {
        super.m_6877_(pPlayer);
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(pPlayer, this.container));
    }
}

