/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class UpgradeRecipeUtil
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack upgradeItem;
    private final double outputIncreaseChance;
    private final int outputIncreaseAmount;
    private final double durationMultiplier;
    private final int durationSetAmount;
    private final double rfPerTickMultiplier;
    private final int rfPerTickAmount;
    private final double meshUseChance;
    private final int meshExtraDamage;
    private final double inputItemConsumeChance;
    private final int inputItemExtraAmount;

    public UpgradeRecipeUtil(ResourceLocation id, ItemStack upgradeItem, double outputIncreaseChance, int outputIncreaseAmount, double durationMultiplier, int durationSetAmount, double rfPerTickMultiplier, int rfPerTickAmount, double meshUseChance, int meshExtraDamage, double inputItemConsumeChance, int inputItemExtraAmount) {
        this.id = id;
        this.upgradeItem = upgradeItem;
        this.outputIncreaseChance = outputIncreaseChance;
        this.outputIncreaseAmount = outputIncreaseAmount;
        this.durationMultiplier = durationMultiplier;
        this.durationSetAmount = durationSetAmount;
        this.rfPerTickMultiplier = rfPerTickMultiplier;
        this.rfPerTickAmount = rfPerTickAmount;
        this.meshUseChance = meshUseChance;
        this.meshExtraDamage = meshExtraDamage;
        this.inputItemConsumeChance = inputItemConsumeChance;
        this.inputItemExtraAmount = inputItemExtraAmount;
    }

    public boolean matches(SimpleContainer pContainer, @NotNull Level pLevel) {
        return true;
    }

    public ItemStack getUpgradeItem() {
        return this.upgradeItem;
    }

    public double getOutputIncreaseChance() {
        return this.outputIncreaseChance;
    }

    public int getOutputIncreaseAmount() {
        return this.outputIncreaseAmount;
    }

    public double getRFPerTick() {
        return this.rfPerTickMultiplier;
    }

    public double getMeshUseChance() {
        return this.meshUseChance;
    }

    public double getInputItemConsumeChance() {
        return this.inputItemConsumeChance;
    }

    public double getDurationMultiplier() {
        return this.durationMultiplier;
    }

    public int getDurationSetAmount() {
        return this.durationSetAmount;
    }

    public int getRfPerTickAmount() {
        return this.rfPerTickAmount;
    }

    public int getMeshExtraDamage() {
        return this.meshExtraDamage;
    }

    public int getInputItemExtraAmount() {
        return this.inputItemExtraAmount;
    }

    @NotNull
    public ItemStack assemble(SimpleContainer p_44001_, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeRecipeUtil> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("opolisutilities", "upgrades");

        public UpgradeRecipeUtil fromJson(ResourceLocation id, JsonObject json) {
            ItemStack upgradeItem = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
            double outputIncreaseChance = GsonHelper.m_144742_((JsonObject)json, (String)"output_increase_chance", (double)0.0);
            int outputIncreaseAmount = GsonHelper.m_13824_((JsonObject)json, (String)"output_increase_amount", (int)0);
            double durationMultiplier = GsonHelper.m_144742_((JsonObject)json, (String)"duration_multiplier", (double)0.0);
            int durationSetAmount = GsonHelper.m_13824_((JsonObject)json, (String)"duration_set_amount", (int)0);
            double rfPerTickMultiplier = GsonHelper.m_144742_((JsonObject)json, (String)"rf_per_tick_multiplier", (double)0.0);
            int rfPerTickAmount = GsonHelper.m_13824_((JsonObject)json, (String)"rf_per_tick_amount", (int)0);
            double meshUseChance = GsonHelper.m_144742_((JsonObject)json, (String)"mesh_use_chance", (double)0.0);
            int meshExtraDamage = GsonHelper.m_13824_((JsonObject)json, (String)"mesh_extra_damage", (int)0);
            double inputItemConsumeChance = GsonHelper.m_144742_((JsonObject)json, (String)"input_item_consume_chance", (double)0.0);
            int inputItemExtraAmount = GsonHelper.m_13824_((JsonObject)json, (String)"input_item_extra_amount", (int)0);
            return new UpgradeRecipeUtil(id, upgradeItem, outputIncreaseChance, outputIncreaseAmount, durationMultiplier, durationSetAmount, rfPerTickMultiplier, rfPerTickAmount, meshUseChance, meshExtraDamage, inputItemConsumeChance, inputItemExtraAmount);
        }

        public UpgradeRecipeUtil fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ItemStack upgradeItem = buf.m_130267_();
            double outputIncreaseChance = buf.readDouble();
            int outputIncreaseAmount = buf.readInt();
            double durationMultiplier = buf.readDouble();
            int durationSetAmount = buf.readInt();
            double rfPerTickMultiplier = buf.readDouble();
            int rfPerTickAmount = buf.readInt();
            double meshUseChance = buf.readDouble();
            int meshExtraDamage = buf.readInt();
            double inputItemConsumeChance = buf.readDouble();
            int inputItemExtraAmount = buf.readInt();
            return new UpgradeRecipeUtil(id, upgradeItem, outputIncreaseChance, outputIncreaseAmount, durationMultiplier, durationSetAmount, rfPerTickMultiplier, rfPerTickAmount, meshUseChance, meshExtraDamage, inputItemConsumeChance, inputItemExtraAmount);
        }

        public void toNetwork(FriendlyByteBuf buf, UpgradeRecipeUtil recipe) {
            buf.m_130055_(recipe.upgradeItem);
            buf.writeDouble(recipe.outputIncreaseChance);
            buf.writeInt(recipe.outputIncreaseAmount);
            buf.writeDouble(recipe.durationMultiplier);
            buf.writeInt(recipe.durationSetAmount);
            buf.writeDouble(recipe.rfPerTickMultiplier);
            buf.writeInt(recipe.rfPerTickAmount);
            buf.writeDouble(recipe.meshUseChance);
            buf.writeInt(recipe.meshExtraDamage);
            buf.writeDouble(recipe.inputItemConsumeChance);
            buf.writeInt(recipe.inputItemExtraAmount);
        }
    }

    public static class Type
    implements RecipeType<UpgradeRecipeUtil> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "upgrades";

        private Type() {
        }
    }
}

