/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ResourceGeneratorRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    public final int duration;

    public ResourceGeneratorRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, int duration) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.duration = duration;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (((Ingredient)this.recipeItems.get(0)).test(pContainer.m_8020_(0))) {
            return this.duration >= 0;
        }
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer p_44001_, RegistryAccess p_267165_) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    public int getDuration() {
        return this.duration;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ResourceGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("opolisutilities", "resource_generator");

        public ResourceGeneratorRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new ResourceGeneratorRecipe(id, output, (NonNullList<Ingredient>)inputs, duration);
        }

        public ResourceGeneratorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            int duration = buf.readInt();
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new ResourceGeneratorRecipe(id, output, (NonNullList<Ingredient>)inputs, duration);
        }

        public void toNetwork(FriendlyByteBuf buf, ResourceGeneratorRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            buf.writeInt(recipe.getDuration());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(recipe.output, false);
        }
    }

    public static class Type
    implements RecipeType<ResourceGeneratorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "resource_generator";

        private Type() {
        }
    }
}

