/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.benbenlaw.opolisutilities.recipe.ModRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CatalogueRecipe
extends SingleItemRecipe {
    public int itemInCount;

    public CatalogueRecipe(ResourceLocation pId, String pGroup, Ingredient pIngredient, ItemStack pResult, int itemInCount) {
        super((RecipeType)Type.INSTANCE, (RecipeSerializer)ModRecipes.CATALOGUE_SERIALIZER.get(), pId, pGroup, pIngredient, pResult);
        this.itemInCount = itemInCount;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_5818_(Container p_44483_, Level p_44484_) {
        ItemStack itemIn = p_44483_.m_8020_(0);
        return this.f_44409_.test(itemIn) && itemIn.m_41613_() >= this.itemInCount;
    }

    public static class Type
    implements RecipeType<CatalogueRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "catalogue";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<CatalogueRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("opolisutilities", "catalogue");

        @NotNull
        public CatalogueRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String group = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            int itemInCount = GsonHelper.m_13824_((JsonObject)pJson, (String)"itemInCount", (int)1);
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            String result = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            int count = GsonHelper.m_13824_((JsonObject)pJson, (String)"itemOutCount", (int)1);
            ItemStack itemstack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(result))), count);
            return new CatalogueRecipe(pRecipeId, group, ingredient, itemstack, itemInCount);
        }

        public CatalogueRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            int itemInCount = pBuffer.readInt();
            return new CatalogueRecipe(pRecipeId, group, ingredient, result, itemInCount);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CatalogueRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.f_44412_);
            pRecipe.f_44409_.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.f_44410_);
            pBuffer.writeInt(pRecipe.itemInCount);
        }
    }
}

