/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ModLootTables {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    public static final ResourceLocation BASIC_LOOT_BOX = ModLootTables.register("loot_boxes/basic_loot_box");
    public static final ResourceLocation ADVANCED_LOOT_BOX = ModLootTables.register("loot_boxes/advanced_loot_box");
    public static final ResourceLocation ELITE_LOOT_BOX = ModLootTables.register("loot_boxes/elite_loot_box");
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);

    private static ResourceLocation register(String string) {
        return ModLootTables.register(new ResourceLocation("opolisutilities", string));
    }

    private static ResourceLocation register(ResourceLocation location) {
        if (LOCATIONS.add(location)) {
            return location;
        }
        throw new IllegalArgumentException(location + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

