/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.config.ConfigFile;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalNetItem
extends Item {
    public AnimalNetItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, Player player, @NotNull LivingEntity livingEntity, @NotNull InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        assert (player != null);
        ItemStack itemstack = player.m_21120_(hand);
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        CompoundTag nbt = itemstack.m_41783_();
        assert (nbt != null);
        if (!level.m_5776_() && nbt.m_128441_("entity")) {
            EntityType type = EntityType.m_20632_((String)itemstack.m_41783_().m_128461_("entity")).orElse(null);
            if (type != null) {
                Entity entity = type.m_20615_(level);
                assert (entity != null);
                entity.m_20258_(itemstack.m_41783_());
                entity.m_19890_((double)pos.m_121945_(direction).m_123341_() + 0.5, (double)pos.m_121945_(direction).m_123342_(), (double)pos.m_121945_(direction).m_123343_() + 0.5, 0.0f, 0.0f);
                nbt.m_128473_("entity");
                itemstack.m_41751_(null);
                if (((Boolean)ConfigFile.animalNetTakesDamage.get()).equals(true)) {
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, damage -> player.m_21190_(player.m_7655_()));
                }
                level.m_7967_(entity);
                level.m_247517_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"tooltips.animal_net.no_mob").m_130940_(ChatFormatting.RED));
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (Screen.m_96638_()) {
            if (stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("entity")) {
                CompoundTag nbt = stack.m_41783_();
                EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(nbt.m_128461_("entity")));
                components.add((Component)Component.m_237115_((String)"tooltips.animal_net.shift.held").m_130940_(ChatFormatting.BLUE));
                components.add((Component)Component.m_237115_((String)entity.toString()).m_130940_(ChatFormatting.GREEN));
            } else {
                boolean hostileMobs = (Boolean)ConfigFile.animalNetHostileMobs.get();
                boolean waterMobs = (Boolean)ConfigFile.animalNetWaterMobs.get();
                boolean animalMobs = (Boolean)ConfigFile.animalNetAnimalMobs.get();
                boolean villagerMobs = (Boolean)ConfigFile.animalNetVillagerMobs.get();
                components.add((Component)Component.m_237115_((String)"tooltips.animal_net.mob_types").m_130940_(ChatFormatting.BLUE));
                if (hostileMobs) {
                    components.add((Component)Component.m_237115_((String)"tooltips.animal_net.hostile_mobs").m_130940_(ChatFormatting.GREEN));
                }
                if (waterMobs) {
                    components.add((Component)Component.m_237115_((String)"tooltips.animal_net.water_mobs").m_130940_(ChatFormatting.GREEN));
                }
                if (animalMobs) {
                    components.add((Component)Component.m_237115_((String)"tooltips.animal_net.animal_mobs").m_130940_(ChatFormatting.GREEN));
                }
                if (villagerMobs) {
                    components.add((Component)Component.m_237115_((String)"tooltips.animal_net.villager_mobs").m_130940_(ChatFormatting.GREEN));
                }
                components.add((Component)Component.m_237115_((String)"tooltips.animal_net.no_mob").m_130940_(ChatFormatting.RED));
            }
        } else {
            components.add((Component)Component.m_237115_((String)"tooltips.animal_net.hover.shift").m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(stack, level, components, flag);
    }
}

