/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.recipe.UpgradeRecipeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class UpgradeRecipeUtilCategory
implements IRecipeCategory<UpgradeRecipeUtil> {
    public static final ResourceLocation UID = new ResourceLocation("opolisutilities", "upgrades");
    public static final ResourceLocation TEXTURE = new ResourceLocation("opolisutilities", "textures/gui/jei_dynamic.png");
    public static final RecipeType<UpgradeRecipeUtil> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"upgrades", UpgradeRecipeUtil.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;

    public UpgradeRecipeUtilCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 114);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.UPGRADE_BASE.get()));
    }

    @NotNull
    public RecipeType<UpgradeRecipeUtil> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.UPGRADE_RECIPE_UTIL;
    }

    public boolean isHandled(@NotNull UpgradeRecipeUtil recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237113_((String)"Upgrades");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull UpgradeRecipeUtil recipe, @NotNull IFocusGroup focusGroup) {
        ++this.tabs_used;
        assert (Minecraft.m_91087_().f_91073_ != null);
        ArrayList<UpgradeRecipeUtil> durationRecipes = new ArrayList<UpgradeRecipeUtil>(Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)UpgradeRecipeUtil.Type.INSTANCE));
        durationRecipes.sort(Comparator.comparingDouble(UpgradeRecipeUtil::getDurationMultiplier));
        int numRows = (int)Math.ceil((double)durationRecipes.size() / 9.0);
        int numCols = Math.min(9, durationRecipes.size());
        int backgroundWidth = 4 + numCols * 19;
        int backgroundHeight = 2 + numRows * 19;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, backgroundWidth, backgroundHeight);
        for (int i = 0; i < durationRecipes.size(); ++i) {
            int slotX = 4 + i % 9 * 19;
            int slotY = 2 + i / 9 * 19;
            ItemStack stack = new ItemStack((ItemLike)((UpgradeRecipeUtil)durationRecipes.get(i)).getUpgradeItem().m_41720_());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addItemStack(stack)).addTooltipCallback(this.informationTooltip((UpgradeRecipeUtil)durationRecipes.get(i))).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, slotX - i % 9 * 19 - 5, slotY - (2 + i / 9 * 19) - 1);
        }
    }

    private IRecipeSlotTooltipCallback informationTooltip(UpgradeRecipeUtil recipe) {
        return (chance, addTooltip) -> {
            String string;
            String string2;
            String string3;
            if (recipe.getDurationMultiplier() != 0.0 && recipe.getDurationMultiplier() < 1.0) {
                string3 = "Duration Modifier: x" + recipe.getDurationMultiplier() + " (Faster)";
                addTooltip.add(Component.m_237113_((String)string3).m_130940_(ChatFormatting.GREEN));
            }
            if (recipe.getDurationMultiplier() != 0.0 && recipe.getDurationMultiplier() > 1.0) {
                string3 = "Duration Modifier: x" + recipe.getDurationMultiplier() + " (Slower)";
                addTooltip.add(Component.m_237113_((String)string3).m_130940_(ChatFormatting.RED));
            }
            if (recipe.getDurationSetAmount() != 0) {
                addTooltip.add(Component.m_237113_((String)("Duration Set Amount: " + recipe.getDurationSetAmount())));
            }
            int percentage = (int)(100.0 - recipe.getOutputIncreaseChance() * 100.0);
            if (recipe.getOutputIncreaseChance() != 0.0 && percentage < 100) {
                string2 = "Additional Output Chance: " + percentage + "%";
                addTooltip.add(Component.m_237113_((String)string2).m_130940_(ChatFormatting.GREEN));
            }
            if (recipe.getOutputIncreaseChance() != 0.0 && percentage > 100) {
                string2 = "Additional Output Chance: " + percentage + "%";
                addTooltip.add(Component.m_237113_((String)string2).m_130940_(ChatFormatting.RED));
            }
            if (recipe.getOutputIncreaseAmount() != 0) {
                addTooltip.add(Component.m_237113_((String)("Additional Output Rolls: " + recipe.getOutputIncreaseAmount())));
            }
            int percentageInputItem = (int)(recipe.getInputItemConsumeChance() * 100.0);
            if (recipe.getInputItemConsumeChance() != 1.0 && percentageInputItem < 100) {
                string = "Input Consume Chance: " + percentageInputItem + "%";
                addTooltip.add(Component.m_237113_((String)string).m_130940_(ChatFormatting.GREEN));
            }
            if (recipe.getInputItemConsumeChance() != 1.0 && percentageInputItem > 100) {
                string = "Input Consume Chance: " + percentageInputItem + "%";
                addTooltip.add(Component.m_237113_((String)string).m_130940_(ChatFormatting.RED));
            }
            if (recipe.getInputItemExtraAmount() > 0) {
                addTooltip.add(Component.m_237113_((String)("Additional Consume Amount: " + recipe.getInputItemExtraAmount())).m_130940_(ChatFormatting.RED));
            }
            if (recipe.getInputItemExtraAmount() == -1) {
                addTooltip.add(Component.m_237113_((String)"Additional Consume Amount: Item Never Consumed!").m_130940_(ChatFormatting.GREEN));
            }
            if (recipe.getRFPerTick() != 0.0) {
                addTooltip.add(Component.m_237113_((String)("RFPer Tick Multiplier: " + recipe.getRFPerTick())));
            }
            if (recipe.getRfPerTickAmount() != 0) {
                addTooltip.add(Component.m_237113_((String)("RFPer Tick Amount: " + recipe.getRfPerTickAmount())));
            }
            if (ModList.get().isLoaded("strainers")) {
                int percentageMeshDamage = (int)(recipe.getMeshUseChance() * 100.0);
                if (recipe.getMeshUseChance() != 0.0) {
                    addTooltip.add(Component.m_237113_((String)("Mesh Damage Chance: " + percentageMeshDamage + "%")).m_130940_(ChatFormatting.GREEN));
                }
                if (recipe.getMeshExtraDamage() > 0) {
                    addTooltip.add(Component.m_237113_((String)("Mesh Extra Damage: " + recipe.getMeshExtraDamage())).m_130940_(ChatFormatting.RED));
                }
            }
        };
    }
}

