/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.JEIOpolisUtilitiesPlugin;
import com.benbenlaw.opolisutilities.recipe.RG2SpeedBlocksRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RG2SpeedBlocksRecipeCategory
implements IRecipeCategory<RG2SpeedBlocksRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("opolisutilities", "rg2_speed_blocks");
    public static final ResourceLocation TEXTURE = new ResourceLocation("opolisutilities", "textures/gui/jei_dynamic.png");
    static final RecipeType<RG2SpeedBlocksRecipe> RECIPE_TYPE = RecipeType.create((String)"opolisutilities", (String)"rg2_speed_blocks", RG2SpeedBlocksRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;

    public RG2SpeedBlocksRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 114);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RESOURCE_GENERATOR_2.get()));
    }

    @NotNull
    public RecipeType<RG2SpeedBlocksRecipe> getRecipeType() {
        return JEIOpolisUtilitiesPlugin.RG2_SPEED_BLOCKS;
    }

    public boolean isHandled(RG2SpeedBlocksRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237113_((String)"Speed Blocks");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RG2SpeedBlocksRecipe recipe, IFocusGroup focusGroup) {
        ++this.tabs_used;
        ArrayList recipes = new ArrayList(Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)RG2SpeedBlocksRecipe.Type.INSTANCE));
        Collections.sort(recipes, Comparator.comparingInt(RG2SpeedBlocksRecipe::getTickRate));
        int numRows = (int)Math.ceil((double)recipes.size() / 9.0);
        int numCols = Math.min(9, recipes.size());
        int backgroundWidth = 4 + numCols * 19;
        int backgroundHeight = 2 + numRows * 19;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, backgroundWidth, backgroundHeight);
        for (int i = 0; i < recipes.size(); ++i) {
            int slotX = 4 + i % 9 * 19;
            int slotY = 2 + i / 9 * 19;
            String blockName = ((RG2SpeedBlocksRecipe)recipes.get(i)).getBlock();
            Block rgBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            TagKey itemTag = ItemTags.create((ResourceLocation)new ResourceLocation(blockName));
            int duration = ((RG2SpeedBlocksRecipe)recipes.get(i)).getTickRate();
            if (rgBlock == Blocks.f_50016_) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addIngredients(Ingredient.m_204132_((TagKey)itemTag))).addTooltipCallback(this.durationTime(duration));
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, slotX, slotY).addIngredients(Ingredient.m_204132_((TagKey)itemTag))).addTooltipCallback(this.durationTime(duration)).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, slotX - i % 9 * 19 - 5, slotY - (2 + i / 9 * 19) - 1);
                continue;
            }
            assert (rgBlock != null);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addItemStack(new ItemStack((ItemLike)rgBlock.m_5456_()))).addTooltipCallback(this.durationTime(duration));
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, slotX, slotY).addItemStack(new ItemStack((ItemLike)rgBlock.m_5456_()))).addTooltipCallback(this.durationTime(duration)).setBackground((IDrawable)JEIOpolisUtilitiesPlugin.slotDrawable, slotX - i % 9 * 19 - 5, slotY - (2 + i / 9 * 19) - 1);
        }
    }

    @Contract(pure=true)
    @NotNull
    private IRecipeSlotTooltipCallback durationTime(int duration) {
        return (chance, addTooltip) -> addTooltip.add(Component.m_237113_((String)(duration / 20 + "s / " + duration + " ticks")));
    }
}

