/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.capabillties;

import java.util.HashMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class CapabilityMigration {
    private final HashMap<Capability<?>, IMigrator<?>> CAPS = new HashMap();

    public static CapabilityMigration create() {
        return new CapabilityMigration();
    }

    private CapabilityMigration() {
    }

    public <T> void register(Capability<T> capability, IMigrator<T> updater) {
        if (this.CAPS.containsKey(capability)) {
            return;
        }
        this.CAPS.put(capability, updater);
    }

    private void handle(CapabilityProvider oldProvider, CapabilityProvider newProvider) {
        oldProvider.reviveCaps();
        this.CAPS.forEach((cap, migrator) -> {
            LazyOptional oldCap = oldProvider.getCapability(cap);
            LazyOptional newCap = newProvider.getCapability(cap);
            if (oldCap.resolve().isPresent() && newCap.resolve().isPresent()) {
                migrator.migrateCast(oldCap.resolve().get(), newCap.resolve().get());
            }
        });
        oldProvider.invalidateCaps();
    }

    public void onRespawn(PlayerEvent.Clone playerClone) {
        if (playerClone.isWasDeath()) {
            this.handle((CapabilityProvider)playerClone.getOriginal(), (CapabilityProvider)playerClone.getEntity());
        }
    }

    public void register(IEventBus bus) {
        bus.addListener(this::onRespawn);
    }

    public static interface IMigrator<T> {
        public void migrate(T var1, T var2);

        default public void migrateCast(Object oldObj, Object newObj) {
            this.migrate(oldObj, newObj);
        }
    }
}

