/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.capabillties;

import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class CapabilityAttacher {
    private final HashMap<Capability<?>, Attacher> CAPS = new HashMap();

    public static CapabilityAttacher create() {
        return new CapabilityAttacher();
    }

    private CapabilityAttacher() {
    }

    public <T> void register(Capability<T> capability, Attacher attacher) {
        if (this.CAPS.containsKey(capability)) {
            return;
        }
        this.CAPS.put(capability, attacher);
    }

    public void capAttach(AttachCapabilitiesEvent<?> event) {
        AttachCapabilitiesEvent<?> a = event;
        this.CAPS.forEach((cap, attach) -> {
            if (attach.canAttach(event.getObject())) {
                event.addCapability(attach.getKey(), attach.getProvider());
            }
        });
    }

    public void addAttachEvents(Class<?> ... types) {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        Class<?>[] classArray = types;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> type;
            Class<?> eventType = type = classArray[i];
            Consumer<AttachCapabilitiesEvent> event = this::capAttach;
            bus.addGenericListener(eventType, event);
        }
    }

    public void register(IEventBus bus) {
        this.addAttachEvents(Entity.class, BlockEntity.class, Item.class, Level.class, ItemStack.class);
    }

    public static class Attacher {
        private final Predicate<Object> predicate;
        private final ResourceLocation key;
        private final Supplier<ICapabilityProvider> capabilityProviderSupplier;

        public static Attacher create(Predicate<Object> predicate, ResourceLocation key, Supplier<ICapabilityProvider> capabilityProviderSupplier) {
            return new Attacher(predicate, key, capabilityProviderSupplier);
        }

        private Attacher(Predicate<Object> predicate, ResourceLocation key, Supplier<ICapabilityProvider> capabilityProviderSupplier) {
            this.predicate = predicate;
            this.key = key;
            this.capabilityProviderSupplier = capabilityProviderSupplier;
        }

        public boolean canAttach(Object object) {
            return this.predicate.test(object);
        }

        public ResourceLocation getKey() {
            return this.key;
        }

        public ICapabilityProvider getProvider() {
            return this.capabilityProviderSupplier.get();
        }
    }
}

