/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.ResourceGenerator2Block;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.RG2BlocksRecipe;
import com.benbenlaw.opolisutilities.recipe.RG2SpeedBlocksRecipe;
import com.benbenlaw.opolisutilities.util.ModTags;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ResourceGenerator2BlockEntity
extends BlockEntity {
    private int progress = 0;
    private int maxProgress = 220;
    public String resource = "";
    private boolean isValidStructure = false;

    public ResourceGenerator2BlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.RESOURCE_GENERATOR_2_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        BlockPos blockPos = this.f_58858_;
        assert (pLevel != null);
        ResourceGenerator2BlockEntity entity = this;
        ++entity.progress;
        if (!this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_50016_)) {
            for (RG2SpeedBlocksRecipe match : this.f_58857_.m_7465_().m_44056_((RecipeType)RG2SpeedBlocksRecipe.Type.INSTANCE, (Container)NoInventoryRecipe.INSTANCE, this.f_58857_)) {
                String blockName = match.getBlock();
                Block speedBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
                TagKey speedBlockTag = BlockTags.create((ResourceLocation)new ResourceLocation(blockName));
                if (!this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_222976_().containsTag(speedBlockTag) && !this.f_58857_.m_8055_(blockPos.m_6630_(2)).m_60713_(Objects.requireNonNull(speedBlock))) continue;
                this.maxProgress = match.getTickRate();
            }
        }
        if (entity.progress % 5 == 0) {
            for (RG2BlocksRecipe genBlocks : this.f_58857_.m_7465_().m_44056_((RecipeType)RG2BlocksRecipe.Type.INSTANCE, (Container)NoInventoryRecipe.INSTANCE, this.f_58857_)) {
                String genBlock = genBlocks.getBlock();
                Block genBlockBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(genBlock));
                TagKey genBlockTag = BlockTags.create((ResourceLocation)new ResourceLocation(genBlock));
                if (this.f_58857_.m_8055_(blockPos.m_6630_(1)).m_222976_().containsTag(genBlockTag) && genBlockTag != ModTags.Blocks.EMPTY) {
                    this.isValidStructure = this.f_58857_.m_8055_(blockPos.m_6630_(1)).m_222976_().containsTag(genBlockTag);
                    this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)ResourceGenerator2Block.LIT, (Comparable)Boolean.valueOf(true)));
                    this.resource = this.f_58857_.m_8055_(blockPos.m_6630_(1)).m_60734_().toString();
                    break;
                }
                if (this.f_58857_.m_8055_(blockPos.m_6630_(1)).m_60713_(genBlockBlock)) {
                    this.isValidStructure = this.f_58857_.m_8055_(blockPos.m_6630_(1)).m_60713_(genBlockBlock) && genBlockBlock != Blocks.f_50016_;
                    this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)ResourceGenerator2Block.LIT, (Comparable)Boolean.valueOf(true)));
                    this.resource = this.f_58857_.m_8055_(blockPos.m_6630_(1)).m_60734_().toString();
                    break;
                }
                this.isValidStructure = false;
                this.resource = "";
            }
        }
        if (this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.RESOURCE_GENERATOR_2.get()) && !this.isValidStructure) {
            this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)ResourceGenerator2Block.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (this.progress >= this.maxProgress && this.isValidStructure) {
            this.progress = 0;
            if (this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.RESOURCE_GENERATOR_2.get()) && this.f_58857_.m_7702_(blockPos.m_7495_()) != null) {
                BlockEntity ent = this.f_58857_.m_7702_(blockPos.m_7495_());
                Block blockAbove = this.f_58857_.m_8055_(blockPos.m_7494_()).m_60734_();
                assert (ent != null);
                ent.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(itemHandler -> {
                    ItemStack stack = new ItemStack((ItemLike)blockAbove.m_5456_());
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!itemHandler.isItemValid(i, stack) || !itemHandler.insertItem(i, stack, true).m_41619_()) continue;
                        itemHandler.insertItem(i, stack, false);
                        break;
                    }
                });
            }
        }
    }

    public int getTickrate() {
        return this.maxProgress;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getResource() {
        return this.resource;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("resource_generator_2.progress", this.progress);
        tag.m_128405_("resource_generator_2.maxProgress", this.maxProgress);
        tag.m_128359_("resource", this.resource);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("resource_generator_2.progress");
        this.maxProgress = nbt.m_128451_("resource_generator_2.maxProgress");
        this.resource = nbt.m_128461_("resource");
    }
}

