/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.ItemRepairerBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.networking.ModMessages;
import com.benbenlaw.opolisutilities.networking.packets.PacketSyncItemStackToClient;
import com.benbenlaw.opolisutilities.screen.ItemRepairerMenu;
import com.benbenlaw.opolisutilities.util.ModTags;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRepairerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ItemRepairerBlockEntity.this.m_6596_();
            if (!ItemRepairerBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncItemStackToClient(this, ItemRepairerBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 1, (i, s) -> false)), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_ITEM_REPAIRER))), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_ITEM_REPAIRER))), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_ITEM_REPAIRER))), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_ITEM_REPAIRER))), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack) && !stack.m_204117_(ModTags.Items.BANNED_IN_ITEM_REPAIRER))));
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ItemRepairerBlockEntity.this.progress;
                case 1 -> ItemRepairerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ItemRepairerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ItemRepairerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 40;

    @Override
    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemRepairerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ITEM_REPAIRER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Item Repairer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new ItemRepairerMenu(containerID, inventory, this, this.data);
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("item_repairer.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("item_repairer.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        BlockPos pPos = this.f_58858_;
        assert (pLevel != null);
        BlockState pState = pLevel.m_8055_(pPos);
        ItemRepairerBlockEntity pBlockEntity = this;
        ItemStack inputAsStack = new ItemStack((ItemLike)pBlockEntity.itemHandler.getStackInSlot(0).m_41720_());
        boolean isDamaged = inputAsStack.m_41768_();
        int damageValue = pBlockEntity.itemHandler.getStackInSlot(0).m_41773_();
        ItemStack stackInSlot0 = pBlockEntity.itemHandler.getStackInSlot(0);
        ItemStack copiedStack = stackInSlot0.m_41777_();
        if (!pState.m_60795_() && !pState.m_60713_(Blocks.f_50626_) && this.f_58857_ instanceof ServerLevel) {
            if (inputAsStack.m_41763_() && damageValue != 0 && ((Boolean)pState.m_61143_((Property)ItemRepairerBlock.POWERED)).booleanValue()) {
                ++pBlockEntity.progress;
                ItemRepairerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                    if (!isDamaged) {
                        pBlockEntity.itemHandler.getStackInSlot(0).m_220157_(-1, RandomSource.m_216327_(), null);
                        pLevel.m_7785_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_11671_, SoundSource.BLOCKS, 0.5f, 3.0f, false);
                    }
                    pBlockEntity.resetProgress();
                    ItemRepairerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                }
            }
            if (inputAsStack.m_41763_() && damageValue == 0 && pBlockEntity.itemHandler.getStackInSlot(1).m_41619_()) {
                pBlockEntity.itemHandler.setStackInSlot(1, copiedStack);
                pBlockEntity.itemHandler.extractItem(0, 1, false);
                pBlockEntity.resetProgress();
                ItemRepairerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
            if (!inputAsStack.m_41763_() && pBlockEntity.itemHandler.getStackInSlot(1).m_41619_()) {
                pBlockEntity.itemHandler.setStackInSlot(1, copiedStack);
                pBlockEntity.itemHandler.extractItem(0, copiedStack.m_41613_(), false);
                pBlockEntity.resetProgress();
                ItemRepairerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }
}

