/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.networking.ModMessages;
import com.benbenlaw.opolisutilities.networking.packets.PacketSyncItemStackToClient;
import com.benbenlaw.opolisutilities.screen.BlockBreakerMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBreakerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            BlockBreakerBlockEntity.this.m_6596_();
            assert (BlockBreakerBlockEntity.this.f_58857_ != null);
            if (!BlockBreakerBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncItemStackToClient(this, BlockBreakerBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack))), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack))), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack))), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack))), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack))), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0, (index, stack) -> index == 0 && this.itemHandler.isItemValid(0, stack))));
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BlockBreakerBlockEntity.this.progress;
                case 1 -> BlockBreakerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BlockBreakerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    BlockBreakerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 80;

    @Override
    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public BlockBreakerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BLOCK_BREAKER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Block Breaker");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new BlockBreakerMenu(containerID, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("block_breaker.progress", this.progress);
        tag.m_128405_("block_breaker.maxProgress", this.maxProgress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("block_breaker.progress");
        this.maxProgress = nbt.m_128451_("block_breaker.maxProgress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private static void spawnBlockAsEntity(Level level, BlockPos pos, ItemStack stack) {
        if (level.f_46443_ || stack.m_41619_() || !level.m_46469_().m_46207_(GameRules.f_46136_) || level.restoringBlockSnapshots) {
            // empty if block
        }
        ItemEntity itemAsEntity = new ItemEntity(level, (double)level.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123341_(), (double)level.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123342_(), (double)level.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123343_(), stack);
        itemAsEntity.m_32060_();
        itemAsEntity.m_20334_((double)level.f_46441_.m_188501_() * 0.1 - 0.05, (double)level.f_46441_.m_188501_() * 0.1 - 0.03, (double)level.f_46441_.m_188501_() * 0.1 - 0.05);
        level.m_7967_((Entity)itemAsEntity);
    }

    public void tick() {
        Level level = this.f_58857_;
        BlockPos pos = this.f_58858_;
        assert (level != null);
        BlockState blockState = level.m_8055_(pos);
        this.maxProgress = (Integer)this.m_58900_().m_61143_((Property)BlockBreakerBlock.TIMER);
        if (!blockState.m_60795_() && !blockState.m_60713_(Blocks.f_50626_) && level instanceof ServerLevel && blockState.m_61138_((Property)BlockBreakerBlock.FACING) && ((Boolean)blockState.m_61143_((Property)BlockBreakerBlock.POWERED)).booleanValue()) {
            Direction direction = (Direction)blockState.m_61143_((Property)BlockBreakerBlock.FACING);
            BlockPos placeHere = pos.m_121945_(direction);
            Block block = this.f_58857_.m_8055_(placeHere).m_60734_();
            ItemStack tool = this.itemHandler.getStackInSlot(0);
            int damageValue = this.itemHandler.getStackInSlot(0).m_41773_();
            List blockDrops = Block.m_49874_((BlockState)block.m_49966_(), (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)placeHere, (BlockEntity)this.f_58857_.m_7702_(pos), null, (ItemStack)tool);
            SoundType blockSounds = this.f_58857_.m_8055_(placeHere).m_60734_().getSoundType(this.f_58857_.m_8055_(placeHere).m_60734_().m_49966_(), (LevelReader)this.f_58857_, pos, null);
            if (level.m_8055_(placeHere).m_60734_() != Blocks.f_50016_ && !blockState.m_60713_(Blocks.f_50626_) && !blockState.m_60795_()) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.progress = 0;
                    if (tool.m_41720_().m_8096_(block.m_49966_()) || !block.m_49966_().m_60834_()) {
                        if (this.itemHandler.getStackInSlot(1).m_150930_(Item.m_41439_((Block)block)) && this.itemHandler.getStackInSlot(2).m_41619_()) {
                            this.f_58857_.m_46597_(placeHere, Blocks.f_50016_.m_49966_());
                            for (ItemStack drop : blockDrops) {
                                BlockBreakerBlockEntity.spawnBlockAsEntity(this.f_58857_, placeHere, drop);
                            }
                            if (tool.m_41763_()) {
                                this.itemHandler.getStackInSlot(0).m_220157_(1, RandomSource.m_216327_(), null);
                                level.m_5594_(null, pos, blockSounds.m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                            if (damageValue + 1 == tool.m_41776_()) {
                                this.itemHandler.extractItem(0, 1, false);
                                level.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        } else if (!this.itemHandler.getStackInSlot(2).m_150930_(Item.m_41439_((Block)block)) && this.itemHandler.getStackInSlot(1).m_41619_()) {
                            this.f_58857_.m_46597_(placeHere, Blocks.f_50016_.m_49966_());
                            for (ItemStack drop : blockDrops) {
                                BlockBreakerBlockEntity.spawnBlockAsEntity(this.f_58857_, placeHere, drop);
                            }
                            if (tool.m_41763_()) {
                                this.itemHandler.getStackInSlot(0).m_220157_(1, RandomSource.m_216327_(), null);
                                level.m_5594_(null, pos, blockSounds.m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                            if (damageValue + 1 == tool.m_41776_()) {
                                this.itemHandler.extractItem(0, 1, false);
                                level.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        } else if (this.itemHandler.getStackInSlot(1).m_41619_() && this.itemHandler.getStackInSlot(2).m_41619_()) {
                            this.f_58857_.m_46597_(placeHere, Blocks.f_50016_.m_49966_());
                            for (ItemStack drop : blockDrops) {
                                BlockBreakerBlockEntity.spawnBlockAsEntity(this.f_58857_, placeHere, drop);
                            }
                            if (tool.m_41763_()) {
                                this.itemHandler.getStackInSlot(0).m_220157_(1, RandomSource.m_216327_(), null);
                                level.m_5594_(null, pos, blockSounds.m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                            if (damageValue + 1 == tool.m_41776_()) {
                                this.itemHandler.extractItem(0, 1, false);
                                level.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    }
                }
            }
        }
        if (!this.f_58857_.m_5776_()) {
            ModMessages.sendToClients(new PacketSyncItemStackToClient(this.itemHandler, this.f_58858_));
        }
    }
}

