/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block;

import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.block.custom.BlockPlacerBlock;
import com.benbenlaw.opolisutilities.block.custom.CatalogueBlock;
import com.benbenlaw.opolisutilities.block.custom.CrafterBlock;
import com.benbenlaw.opolisutilities.block.custom.DryingTableBlock;
import com.benbenlaw.opolisutilities.block.custom.EnderOreBlock;
import com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock;
import com.benbenlaw.opolisutilities.block.custom.FanBlock;
import com.benbenlaw.opolisutilities.block.custom.FluidGeneratorBlock;
import com.benbenlaw.opolisutilities.block.custom.ItemRepairerBlock;
import com.benbenlaw.opolisutilities.block.custom.RedstoneClockBlock;
import com.benbenlaw.opolisutilities.block.custom.ResourceGenerator2Block;
import com.benbenlaw.opolisutilities.block.custom.ResourceGeneratorBlock;
import com.benbenlaw.opolisutilities.item.ModItems;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"opolisutilities");
    public static final RegistryObject<Block> FLOATING_BLOCK = ModBlocks.registerBlockWithoutBlockItem("floating_block_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60966_()));
    public static final RegistryObject<Block> DRYING_TABLE = ModBlocks.registerBlock("drying_table", () -> new DryingTableBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> CRAFTER = ModBlocks.registerBlock("crafter", () -> new CrafterBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> BLOCK_PLACER = ModBlocks.registerBlock("block_placer", () -> new BlockPlacerBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> BLOCK_BREAKER = ModBlocks.registerBlock("block_breaker", () -> new BlockBreakerBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> ITEM_REPAIRER = ModBlocks.registerBlock("item_repairer", () -> new ItemRepairerBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> RESOURCE_GENERATOR = ModBlocks.registerBlock("resource_generator", () -> new ResourceGeneratorBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> RESOURCE_GENERATOR_2 = ModBlocks.registerBlock("resource_generator_2", () -> new ResourceGenerator2Block(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> FLUID_GENERATOR = ModBlocks.registerBlock("fluid_generator", () -> new FluidGeneratorBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> CATALOGUE = ModBlocks.registerBlock("catalogue", () -> new CatalogueBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> REDSTONE_CLOCK = ModBlocks.registerBlock("redstone_clock", () -> new RedstoneClockBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_60955_()));
    public static final RegistryObject<Block> ENDER_ORE = ModBlocks.registerBlock("ender_ore", () -> new EnderOreBlock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60999_().m_60918_(SoundType.f_56742_).m_60953_(ModBlocks.litBlockEmission(9)), UniformInt.m_146622_((int)2, (int)4)));
    public static final RegistryObject<Block> DEEPSLATE_ENDER_ORE = ModBlocks.registerBlock("deepslate_ender_ore", () -> new EnderOreBlock(BlockBehaviour.Properties.m_284310_().m_60913_(4.5f, 3.0f).m_60999_().m_60918_(SoundType.f_154677_).m_60953_(ModBlocks.litBlockEmission(9)), UniformInt.m_146622_((int)2, (int)4)));
    public static final RegistryObject<Block> ENDER_SCRAMBLER = ModBlocks.registerBlock("ender_scrambler", () -> new EnderScramblerBlock(BlockBehaviour.Properties.m_284310_().m_60913_(4.5f, 3.0f).m_60999_().m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> FAN = ModBlocks.registerBlock("fan", () -> new FanBlock(BlockBehaviour.Properties.m_284310_().m_60913_(4.5f, 3.0f).m_60999_().m_60918_(SoundType.f_56742_)));

    private static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.m_61143_((Property)BlockStateProperties.f_61443_) != false ? p_50760_ : 0;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

