/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import java.util.List;
import nanonestor.cursedearth.CursedEarth;
import nanonestor.cursedearth.CursedEarthBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BlessedEarthBlock
extends GrassBlock {
    public static final Block blessed_earth = new BlessedEarthBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50440_));
    public static final Item blessed_earth_item = new BlockItem(blessed_earth, new Item.Properties());

    public BlessedEarthBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        this.schedule(pos, world);
    }

    public void schedule(BlockPos pos, Level level) {
        int maxTime = 3 * (Integer)CursedEarth.ServerConfig.maxTickTime.get();
        int minTime = 2 * (Integer)CursedEarth.ServerConfig.minTickTime.get();
        level.m_186460_(pos, (Block)this, level.f_46441_.m_188503_(maxTime - minTime));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            if (!world.f_46443_) {
                ServerChunkCache s = (ServerChunkCache)world.m_7726_();
                List<MobSpawnSettings.SpawnerData> entries = s.m_8481_().m_223133_(world.m_204166_(pos), ((ServerLevel)world).m_215010_(), MobCategory.CREATURE, pos.m_7494_()).m_146338_().stream().filter(spawners -> !spawners.f_48404_.m_204039_(CursedEarth.blacklisted_entities)).toList();
                if (entries.size() == 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"text.cursedearth.nospawns"), true);
                } else {
                    MutableComponent names = Component.m_237113_((String)"Mobs: ");
                    for (int i = 0; i < entries.size(); ++i) {
                        MobSpawnSettings.SpawnerData spawners2 = entries.get(i);
                        names.m_7220_(spawners2.f_48404_.m_20676_());
                        if (i >= entries.size() - 1) continue;
                        names.m_7220_((Component)Component.m_237113_((String)", "));
                    }
                    player.m_213846_((Component)names);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.f_46443_) {
            boolean dark;
            this.schedule(pos, (Level)world);
            if (!world.isAreaLoaded(pos, 3)) {
                return;
            }
            boolean bl = dark = world.m_46803_(pos.m_7494_()) <= 7;
            if (dark) {
                world.m_46597_(pos, CursedEarthBlock.cursed_earth.m_49966_());
            } else if (!dark && ((Boolean)CursedEarth.ServerConfig.naturallySpreads.get()).booleanValue() && world.m_8055_(pos.m_7494_()).m_60795_()) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos pos1 = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                    if (!world.m_8055_(pos1).m_204336_(CursedEarth.spreadable) || !world.m_8055_(pos1.m_7494_()).m_60795_()) continue;
                    world.m_46597_(pos1, (BlockState)blockstate.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(world.m_8055_(pos1.m_7494_()).m_60734_() == Blocks.f_50125_)));
                }
            }
            if (!world.m_6425_(pos.m_7494_()).m_76178_()) {
                return;
            }
            if (world.m_6106_().m_5472_() == Difficulty.PEACEFUL) {
                return;
            }
            if (!dark) {
                int r = (Integer)CursedEarth.ServerConfig.spawnRadius.get();
                if (world.m_45976_(Player.class, new AABB((double)(-r), (double)(-r), (double)(-r), (double)r, (double)r, (double)r)).size() > 0) {
                    return;
                }
                Entity en2 = this.findMobToSpawn(world, pos.m_7494_(), random);
                if (en2 != null) {
                    en2.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                    if (!world.m_45786_(en2) || !world.m_45784_(en2)) {
                        return;
                    }
                    world.m_7967_(en2);
                }
            }
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean p_176473_4_) {
        return false;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    private Entity findMobToSpawn(ServerLevel world, BlockPos pos, RandomSource rand) {
        ServerChunkCache s = world.m_7726_();
        List<MobSpawnSettings.SpawnerData> spawnOptions = s.m_8481_().m_223133_(world.m_204166_(pos), world.m_215010_(), MobCategory.CREATURE, pos).m_146338_().stream().filter(spawners -> !spawners.f_48404_.m_204039_(CursedEarth.blacklisted_entities)).toList();
        if (spawnOptions.size() == 0) {
            return null;
        }
        int found = rand.m_188503_(spawnOptions.size());
        MobSpawnSettings.SpawnerData entry = spawnOptions.get(found);
        EntityType type = entry.f_48404_;
        Entity ent = type.m_20615_((Level)world);
        if (ent instanceof Mob) {
            ((Mob)ent).m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
        }
        return ent;
    }
}

