/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientListCache {
    private static final IngredientListCache INSTANCE = new IngredientListCache();
    private final Map<ResourceLocation, List<List<Component>>> lists = new HashMap<ResourceLocation, List<List<Component>>>();

    private IngredientListCache() {
    }

    public List<Component> getIngredientsList(ResourceLocation id, NonNullList<Ingredient> ingredients) {
        return this.lists.computeIfAbsent(id, r -> IngredientListCache.createIngredientsList(ingredients)).stream().map(l -> {
            long index = System.currentTimeMillis() / 2000L % (long)l.size();
            return (Component)l.get(Math.toIntExact(index));
        }).toList();
    }

    public void onResourceManagerReload(ResourceManager manager) {
        this.lists.clear();
    }

    public static IngredientListCache getInstance() {
        return INSTANCE;
    }

    private static List<List<Component>> createIngredientsList(NonNullList<Ingredient> ingredients) {
        ArrayList<ItemList> lists = new ArrayList<ItemList>();
        for (Ingredient ingredient : ingredients) {
            List<Item> items = Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).toList();
            boolean matched = false;
            for (ItemList list : lists) {
                if (!list.containsAll(items)) continue;
                ++list.quantity;
                matched = true;
                break;
            }
            if (matched) continue;
            lists.add(new ItemList(items));
        }
        return lists.stream().map(s -> s.items.stream().map(i -> Component.m_237113_((String)(s.quantity + "x ")).m_7220_(i.m_7968_().m_41786_())).toList()).toList();
    }

    private static class ItemList {
        private final Set<Item> itemSet;
        public final List<Item> items;
        public int quantity;

        public ItemList(List<Item> items) {
            this.itemSet = new HashSet<Item>(items);
            this.items = items;
            this.quantity = 1;
        }

        public boolean containsAll(Collection<Item> items) {
            return this.itemSet.containsAll(items);
        }
    }
}

